package com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser

import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.ProtocolContent
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolVersion
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser.parserUtil.parseBaseInfo
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser.parserUtil.parseInputDeviceContent
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser.parserUtil.parseOutputDeviceContent
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser.parserUtil.parseTimerContent
import kotlinx.serialization.json.JsonObject
import kotlin.jvm.JvmStatic

internal class ProtocolParser {
    companion object {
        @JvmStatic
        fun parse(jsonObject: JsonObject, protocolVersion: ProtocolVersion): ProtocolContent {
            return ProtocolContent().also {
                it.parseBaseInfo(jsonObject, protocolVersion)
                it.parseOutputDeviceContent(jsonObject)
                it.parseInputDeviceContent(jsonObject)
                it.parseTimerContent(jsonObject)
            }
        }
    }

//    fun parseAsync(jsonObject: JsonObject, block: (ProtocolContent?) -> Unit) {
//        val parseInBg = CoroutineScope(Dispatchers.Default).async {
//            KMMLogger.d("Parser.parse begin: ${this.coroutineContext}")
//
//            return@async ProtocolContent().also {
//                it.parseBaseInfo(jsonObject)
//                it.parseOutputDeviceContent(jsonObject)
//                it.parseInputDeviceContent(jsonObject)
//                it.parseTimerContent(jsonObject)
//                it.freezeSelf()
//            }
//        }
//
//        CoroutineScope(Dispatchers.Default).launch {
//            val protocolContent = parseInBg.await()
//
//            MainScope().launch {
//                block(protocolContent)
//                KMMLogger.d("Parser.parse done: ${this.coroutineContext}")
//            }
//        }
//    }
}