package com.sentray.kmmprotocolmodule

//import kotlin.native.concurrent.freeze
//
//actual fun <T> freeze(t: T): T = t.freeze()


import io.ktor.client.*
import io.ktor.client.engine.darwin.*

actual abstract class KMMContext
actual class KMMApplication
internal object IosFakeContext : KMMContext()

@Suppress("VARIABLE_IN_SINGLETON_WITHOUT_THREAD_LOCAL")
actual object KmmApplicationCache {
    internal actual var kmmApplication: KMMApplication? = null

    actual fun injectApplication(application: KMMApplication) {
        kmmApplication = application
    }

    internal actual fun getContext(): KMMContext? {
        return IosFakeContext
    }
}

actual fun httpClient(config: HttpClientConfig<*>.() -> Unit) = HttpClient(Darwin) {
    config(this)
    engine {
        configureRequest {
            setAllowsCellularAccess(true)
        }
    }
}