package com.sentray.kmmprotocolmodule.sdk.parser

import com.sentray.kmmprotocolmodule.cryptor.baseCryptor.L1DataCryptor
import com.sentray.kmmprotocolmodule.sdk.parser.parserResult.ParserResult
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.ProtocolContent
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolComm
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolKey
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolVersion
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser.ProtocolParser
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser.parserUtil.StickPackageHandler
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser.parserUtil.value
import com.sentray.kmmprotocolmodule.utilityToolKit.loggerKit.KMMLogger
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonObject
import kotlinx.serialization.json.jsonObject

class Parser {
    private val stickPackageHandler = StickPackageHandler()

    fun parse(message: String): List<ParserResult> {
        val parserResultList = mutableListOf<ParserResult>()
        val jsonObjectList = stickPackageHandler.split(message)
        try {
            jsonObjectList.forEach { validJsonObject ->
                classify(validJsonObject)?.let { protocolContent ->
                    val parserResult = ParserResult(protocolContent)
                    parserResultList.add(parserResult)
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return parserResultList.toList()
    }

    private val json = Json {
        ignoreUnknownKeys = true
    }


    private fun classify(jsonObject: JsonObject): ProtocolContent? {
        var protocolContent: ProtocolContent? = null

        jsonObject.value<Int>(ProtocolKey.ProtocolVersion.raw)?.let { protocolVersion ->
            when (protocolVersion) {
                ProtocolVersion.V3.raw -> {
                    //服务器包 : 由于去掉了 tcp login 指令，目前暂时没有 V3 包
                }
                ProtocolVersion.V2.raw -> {
                    L1DataCryptor.decode(jsonObject)?.let { l1DecodeString ->
                        try {
                            json.parseToJsonElement(l1DecodeString).jsonObject.let {
                                protocolContent = ProtocolParser.parse(it, ProtocolVersion.V2)
                            }
                        } catch (e: Exception) {
                            e.printStackTrace()
                            KMMLogger.d("controllerProtocolParse : L1Data解密失败 : $l1DecodeString")
                        }
                    }
                }
                ProtocolVersion.V1.raw -> {
                    protocolContent = ProtocolParser.parse(jsonObject, ProtocolVersion.V1)
                }
                else -> {
                    KMMLogger.d("controllerProtocolParse : protocolVersion无效 : $protocolVersion")
                }
            }
        } ?: run {
            //点名中控版本，protocolVersion 为 null, 此处人为设置成 V1
            protocolContent = ProtocolParser.parse(jsonObject, ProtocolVersion.V1)
        }

        return protocolContent
    }

    private fun cleanup(revMessage: String): JsonObject? {
        var validJsonObject: JsonObject? = null

        val jsonPackageStringList = revMessage.split(ProtocolComm.Suffix.raw)

        for (index in (0 until jsonPackageStringList.count())) {
            val jsonPackageStr = jsonPackageStringList[index]

            //忽略空包
            if (jsonPackageStr.isEmpty()) {
                continue
            }

            //判断是否有 @@@ or $$$
            var startIndex = jsonPackageStr.indexOf(ProtocolComm.LanPrefix.raw)
            if (startIndex < 0) {
                startIndex = jsonPackageStr.indexOf(ProtocolComm.WanPrefix.raw)
            }

            if (startIndex >= 0) {
                //若存在开始符，则判断为有效包，去除头尾部
                val validJsonString = jsonPackageStr.substring(startIndex + 3)
                //测试是否为有效 json 字符串，若是，则加入 validJsonStringList，若不是，则缓存起来，等待下一个数据包一并处理
                try {
                    validJsonObject = Json.parseToJsonElement(validJsonString).jsonObject
                } catch (e: Exception) {
                    e.printStackTrace()
                    KMMLogger.d("RecPackageHandler : 无效包，等待下一包处理 : $jsonPackageStr")
                }
            }
        }
        return validJsonObject
    }
}