package com.sentray.kmmprotocolmodule.task

import com.sentray.kmmprotocolmodule.network.smartlink.FailureCallback
import com.sentray.kmmprotocolmodule.network.smartlink.FinishCallback
import com.sentray.kmmprotocolmodule.network.smartlink.SmartLinkManager
import com.sentray.kmmprotocolmodule.network.smartlink.SuccessCallback
import com.sentray.kmmprotocolmodule.network.udp.DeviceFoundCallback
import com.sentray.kmmprotocolmodule.network.udp.DiscoveryFinishedCallback
import com.sentray.kmmprotocolmodule.network.udp.UdpClientManager
import com.sentray.kmmprotocolmodule.utilityToolKit.asyncKit.KAsync

//1. smartlink 后，会得到 mac，通过发送空 get 后得到 sn，库使用者自行保存好 sn 和 mac
//2. app 启动时必须执行 udp discover 和发送空 get，此时也会有 mac 和 sn，库使用者自行保存好 sn 和 mac
//3. 若使用云模式，则不需要 mac，同时也代表已经有帐号，库使用者自行保存好 sn 和 mac；后续考虑把账户同步做进来
//TODO: 问题：服务器上 user 对应的 snList 如何更新，若上传 WiFiDevInfo，则其他所有数据是否都应该上传!!!! 结论，不做云模式通讯

//结论 : 用户使用时，只单纯使用 smartlink，udpDiscover 和 命令解析及生成功能
class WifiConfTask {
    companion object {
        //1. 对于点名中控，需要发送空 get 后才能知道 sn
        //2. 对于后续中控，sn = "macmac"
        //3. 统一处理方式：根据 mac 创建中控数据，后续中控回复时，根据 tcpClient 的 mac 对 sn 进行赋值
        fun startWiFiConfig(
            ssid: String,
            pwd: String,
            timeoutSeconds: Long,
            successCallback: SuccessCallback,
            failureCallback: FailureCallback,
            finishCallback: FinishCallback
        ) {
            KAsync.main {
                //1. 需要在主进程中启动 SmartLink，否则崩溃
                SmartLinkManager.startSmartLink(ssid, pwd, timeoutSeconds,
                    { mac, ip ->
                        //2.1. SmartLink 成功，返回结果
                        KAsync.main {
                            successCallback.invoke(mac, ip)
                        }
                    },
                    { message ->
                        //2.2. SmartLink 失败，返回原因
//                    result.result = false
//                    result.errorMessage = message
                        KAsync.main {
                            failureCallback.invoke(message)
                            //由于错误时 SDK 不会调用 finishCallback，所以人为增加调用
                            finishCallback.invoke()
                        }
                    },
                    {
                        //2.3. SmartLink 完成
                        KAsync.main {
                            finishCallback.invoke()
                        }
                    })
//                }
            }
        }

        fun startUDPDiscovery(
            onFoundCallback: DeviceFoundCallback,
            finishedCallback: DiscoveryFinishedCallback
        ) {
            KAsync.background {
                UdpClientManager.startLanDiscover({ mac, ip, name ->
                    KAsync.main {
                        onFoundCallback.invoke(mac, ip, name)
                    }
                }, { amount ->
                    KAsync.main {
                        finishedCallback.invoke(amount)
                    }
                })
            }
        }
    }
}