package com.sentray.kmmprotocolmodule

import io.ktor.client.*

//kotlin/native 多线程解析：https://kotlinlang.org/docs/multiplatform-mobile-concurrency-overview.html#rule-2-immutable-state-many-threads
//kotlin/native 多线程变量访问方式：https://kotlinlang.org/docs/multiplatform-mobile-concurrent-mutability.html

//https://github.com/JetBrains/kotlin-native/issues/2207
//expect fun <T> freeze(t: T): T

expect abstract class KMMContext
expect class KMMApplication

@Suppress("VARIABLE_IN_SINGLETON_WITHOUT_THREAD_LOCAL")
expect object KmmApplicationCache {
    internal var kmmApplication: KMMApplication?
    fun injectApplication(application: KMMApplication)
    internal fun getContext(): KMMContext?
}

expect fun httpClient(config: HttpClientConfig<*>.() -> Unit = {}): HttpClient
