package com.sentray.kmmprotocolmodule.network.webSocket

import com.sentray.kmmprotocolmodule.utilityToolKit.loggerKit.KMMLogger
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

@Suppress("VARIABLE_IN_SINGLETON_WITHOUT_THREAD_LOCAL")
internal object WebSocketClientManager {
    private const val port = 8010
    private const val decode = false

    private var webSocketClient: WebSocketClient? = null

    suspend fun startConnect(
        host: String,
        userID: Int,
        accessToken: String,
    ) {
        webSocketClient?.let {
            it.disconnectManually()
            it.startConnect()
            webSocketClient = null
        }

        webSocketClient = WebSocketClient(host, port, userID, accessToken, decode).also {
            it.startConnect()
        }
    }

    fun send(message: String) {
        KMMLogger.d("WebSocket 待发送 : $message")
        webSocketClient?.let {
            CoroutineScope(Dispatchers.Default).launch {
                it.sendData(message)
                KMMLogger.d("WebSocket 已发送 : $message")
            }
        }
    }

    fun isConnected(): Boolean {
        return webSocketClient?.isConnected() ?: run {
            false
        }
    }

    fun disconnect() {
        webSocketClient?.disconnectManually()
        webSocketClient = null
    }
}