package com.sentray.kmmprotocolmodule.sdk.parser.parserResult

import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.ProtocolContent
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.Cmd
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolVersion
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.FirmwareVersion
import kotlinx.serialization.Serializable

@Serializable
enum class ErrorCode(val raw: Int) {
    NoError(0),
    TimerReachMax(1),
    TimerNotExist(2),
    DeviceAmountReachMax(11);

    companion object {
        private val mapping = values().associateBy(ErrorCode::raw)
        fun fromRaw(raw: Int) = mapping[raw]
    }
}

@Serializable
class BaseInfo {
    var sn: String? = null
    var cmd: Cmd? = null
    var seq: Long? = null
    var fwVersion: FirmwareVersion? = null
    var errorCode: ErrorCode = ErrorCode.NoError
    var protocolVersion: ProtocolVersion

    internal constructor(baseContent: ProtocolContent.BaseContent) {
        sn = baseContent.sn
        cmd = baseContent.cmd
        seq = baseContent.seq
        fwVersion = baseContent.fwVersion
        protocolVersion = baseContent.protocolVersion

        baseContent.failure?.let { failure ->
            ErrorCode.fromRaw(failure)?.let {
                errorCode = it
            }
        }
    }

//    fun freezeSelf() {
//        freeze(this)
//    }
}