package com.sentray.kmmprotocolmodule.sdk.parser.parserResult

import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeSet
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.ProtocolContent
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.TimerParaV1
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.TimerParaV2
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.WeekMask
import kotlinx.serialization.Serializable

@Serializable
class TimerInfo {
    var installedTimerIndexList: List<Int>? = null

    //timer v1 para
    @Deprecated("timerV1 已弃用")
    var timerV1ParaList: List<TimerV1Para>? = null

    //timer v2 para
    var timerV2ParaList: List<TimerV2Para>? = null

    //del timer para
    var deletedTimerIndexList: List<Int>? = null
//    var installedUserActionIndexList: List<Int>? = null

    internal constructor(timerContent: ProtocolContent.TimerContent) {
        timerContent.timerInstalled?.let { timerInstalled ->
            val timerIndexList = mutableListOf<Int>()

            for (index in 0 until timerInstalled.count()) {
                if (timerInstalled[index]) {
                    timerIndexList.add(index)
                }
            }

            installedTimerIndexList = timerIndexList.toList()
        }

        timerContent.timerParaV1List?.let { timerParaV1List ->
            val timerV1List = mutableListOf<TimerV1Para>()
            for (index in 0 until timerParaV1List.count()) {
                val timerParaV1 = timerParaV1List[index]
                timerV1List.add(TimerV1Para(timerParaV1))
            }
            timerV1ParaList = timerV1List.toList()
        }

        timerContent.timerParaV2List?.let { timerParaV2List ->
            val timerV2List = mutableListOf<TimerV2Para>()
            for (index in 0 until timerParaV2List.count()) {
                val timerParaV2 = timerParaV2List[index]
                timerV2List.add(TimerV2Para(timerParaV2))
            }
            timerV2ParaList = timerV2List.toList()
        }

        timerContent.deletedTimerIndexList?.let {
            deletedTimerIndexList = it
        }

//        timerContent.installedUserActionBoolList?.let {
//            val installedIndexList = mutableListOf<Int>()
//            for (index in 0 until it.count()) {
//                if (it[index]) {
//                    installedIndexList.add(index)
//                }
//            }
//            installedUserActionIndexList = installedIndexList.toList()
//        }
    }

//    fun freezeSelf() {
//        freeze(this)
//    }
}

@Serializable
class TimerV1Para {
    var timerIndex: Int = 0
    var posix: Long = 0
    var weekMaskForUserTimeZone: WeekMask = WeekMask()
    var enable: Boolean = false
    var devType: DeviceTypeSet = DeviceTypeSet.Unknown
    var applianceActionList: List<TimerV1ApplianceAction> = listOf()

    internal constructor(timerParaV1: TimerParaV1) {
        timerIndex = timerParaV1.timerBasePara.timerIndex
        posix = timerParaV1.timerBasePara.posix
        weekMaskForUserTimeZone = timerParaV1.timerBasePara.getWeekMaskForUserTimeZone()
        enable = timerParaV1.timerBasePara.enable
        devType = timerParaV1.timerBasePara.devType

        val applianceActionListNew = mutableListOf<TimerV1ApplianceAction>()
        for (index in 0 until timerParaV1.rlyMask.count()) {
            if (timerParaV1.rlyMask[index]) {
                if (index < timerParaV1.actionMask.count()) {
                    val timerV1ApplianceAction =
                        TimerV1ApplianceAction(index, timerParaV1.actionMask[index])
                    applianceActionListNew.add(timerV1ApplianceAction)
                }
            }
        }
        applianceActionList = applianceActionListNew.toList()
    }
}

@Serializable
data class TimerV1ApplianceAction(
    var applianceIndex: Int,
    var action: Boolean,
)

@Serializable
class TimerV2Para {
    var timerIndex: Int = 0
    var posix: Long = 0
    var weekMaskForUserTimeZone: WeekMask = WeekMask()
    var enable: Boolean = false
    var bindUserActionIndexList: List<Int>? = null
    var bindDetectableApplianceStatusList: List<DetectableApplianceStatus>? = null

    internal constructor(timerParaV2: TimerParaV2) {
        timerIndex = timerParaV2.timerBasePara.timerIndex
        posix = timerParaV2.timerBasePara.posix
        weekMaskForUserTimeZone = timerParaV2.timerBasePara.getWeekMaskForUserTimeZone()
        enable = timerParaV2.timerBasePara.enable

        val bindUserActionIndexListNew = mutableListOf<Int>()
        for (index in 0 until timerParaV2.userActionMask.count()) {
            if (timerParaV2.userActionMask[index]) {
                bindUserActionIndexListNew.add(index)
            }
        }
        bindUserActionIndexList = bindUserActionIndexListNew.toList()

        val bindDetectableApplianceStatusListNew = mutableListOf<DetectableApplianceStatus>()
        for (index in 0 until timerParaV2.triggerMask.count()) {
            if (timerParaV2.triggerMask[index]) {
                if (index < timerParaV2.triggerStatus.count()) {
                    val detectableApplianceStatus =
                        DetectableApplianceStatus(index, timerParaV2.triggerStatus[index])
                    bindDetectableApplianceStatusListNew.add(detectableApplianceStatus)
                }
            }
        }
        bindDetectableApplianceStatusList = bindDetectableApplianceStatusListNew.toList()
    }
}