package com.sentray.kmmprotocolmodule.tcpProtocol.cache

import com.sentray.kmmprotocolmodule.sdk.parser.parserResult.ParserResult
import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeSet


/*
此 callback 针对控制及查询命令
 */

internal typealias CtrlQueryCmdResponseCallback = (sn: String, devTypeSet: DeviceTypeSet, applianceIndex: Int, parseResult: ParserResult) -> Unit

//控制及查询命令ack 仅需要通过 sn devType jackIndex cmdAck 即可判断（非100%准确，但影响不大），目前不可通过 seq 判断（中控回复的 seq 与 APP 不匹配）
//TODO: 待关注特殊设备处理：环境侦测仪、电量统计等
internal object CtrlQueryCmdResponseCallbackCache {
    private val callbackMap =
        mutableMapOf<String, CtrlQueryCmdResponseCallback>()

    fun insertCallback(
        sn: String,
        devTypeSet: DeviceTypeSet,
        applianceIndex: Int,
        callback: CtrlQueryCmdResponseCallback
    ) {
        val key = createKey(sn, devTypeSet, applianceIndex)
        callbackMap[key] = callback
    }

    fun invokeCallback(parseResult: ParserResult) {
        val sn = parseResult.baseInfo?.sn ?: return
        val updatedControllableApplianceInfoList =
            parseResult.controllableDeviceInfo?.updatedControllableApplianceInfoList ?: return

        updatedControllableApplianceInfoList.forEach {
            val key = createKey(sn, it.devType, it.applianceIndex)
            callbackMap[key]?.let { callback ->
                callback.invoke(sn, it.devType, it.applianceIndex, parseResult)
                callbackMap.remove(key)
            }
        }
    }

    private fun createKey(
        sn: String,
        devTypeSet: DeviceTypeSet,
        applianceIndex: Int
    ): String {
        return "$sn${devTypeSet.raw}$applianceIndex"
    }
}