package com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType

import kotlin.jvm.JvmStatic

class DeviceTypeClassify {
    companion object {
        @JvmStatic
        fun isGatewayDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.MomSon
        }

        @JvmStatic
        fun isWifiOnlyDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.EnvMonitor_W || deviceTypeSet == DeviceTypeSet.EnvMonitorPlus_W
        }

        @JvmStatic
        fun isEnvMonitorDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.EnvMonitor_W || deviceTypeSet == DeviceTypeSet.EnvMonitorPlus_W
        }

        @JvmStatic
        fun isControllableDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return !isInputDetectDevice(deviceTypeSet) &&
                    deviceTypeSet != DeviceTypeSet.SonAlarm &&
                    deviceTypeSet != DeviceTypeSet.SonCamera
        }

        @JvmStatic
        fun isDimmerDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonDimmer_4D_E_LMS ||
                    deviceTypeSet == DeviceTypeSet.SonDimmer_1D ||
                    isDimmer2D(deviceTypeSet) ||
                    isDimmer3D(deviceTypeSet) ||
                    deviceTypeSet == DeviceTypeSet.SonDimmerSW_1D ||
                    isDimmerSW2D(deviceTypeSet) ||
                    isDimmerSW3D(deviceTypeSet) ||
                    deviceTypeSet == DeviceTypeSet.SonDimmerPWM_1D ||
                    deviceTypeSet == DeviceTypeSet.SonDimmerPWM_2D ||
                    deviceTypeSet == DeviceTypeSet.SonDimmerPWM_3D
        }

        @JvmStatic
        fun isDimmer1D(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonDimmer_1D
        }

        @JvmStatic
        fun isDimmer2D(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonDimmer_2D ||
                    deviceTypeSet == DeviceTypeSet.SonDimmer_2D_1
        }

        @JvmStatic
        fun isDimmer3D(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonDimmer_3D ||
                    deviceTypeSet == DeviceTypeSet.SonDimmer_3D_1 ||
                    deviceTypeSet == DeviceTypeSet.SonDimmer_3D_2
        }

        @JvmStatic
        fun isDimmerSW1D(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonDimmerSW_1D
        }

        @JvmStatic
        fun isDimmerSW2D(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonDimmerSW_2D ||
                    deviceTypeSet == DeviceTypeSet.SonDimmerSW_2D_1
        }

        @JvmStatic
        fun isDimmerSW3D(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonDimmerSW_3D ||
                    deviceTypeSet == DeviceTypeSet.SonDimmerSW_3D_1 ||
                    deviceTypeSet == DeviceTypeSet.SonDimmerSW_3D_2
        }

        @JvmStatic
        fun isTouchSW1D(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonTouchSW_1D
        }

        @JvmStatic
        fun isTouchSW2D(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonTouchSW_2D ||
                    deviceTypeSet == DeviceTypeSet.SonTouchSW_2D_1
        }

        @JvmStatic
        fun isTouchSW3D(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonTouchSW_3D ||
                    deviceTypeSet == DeviceTypeSet.SonTouchSW_3D_1 ||
                    deviceTypeSet == DeviceTypeSet.SonTouchSW_3D_2
        }

        @JvmStatic
        fun isBoxSW1D(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonBoxSW_1D
        }

        @JvmStatic
        fun isBoxSW2D(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonBoxSW_2D ||
                    deviceTypeSet == DeviceTypeSet.SonBoxSW_2D_1
        }

        @JvmStatic
        fun isBoxSW3D(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonBoxSW_3D ||
                    deviceTypeSet == DeviceTypeSet.SonBoxSW_3D_1 ||
                    deviceTypeSet == DeviceTypeSet.SonBoxSW_3D_2
        }

        @JvmStatic
        fun isTwoSocketDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.MomSon ||
                    deviceTypeSet == DeviceTypeSet.SonPlug_1Dx2 ||
                    deviceTypeSet == DeviceTypeSet.SonPlug_2Dx2 ||
                    deviceTypeSet == DeviceTypeSet.SonPlug_3Dx2
        }

        @JvmStatic
        fun isWithResponseDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet != DeviceTypeSet.SonAlarm &&
                    deviceTypeSet != DeviceTypeSet.Son86_1S &&
                    deviceTypeSet != DeviceTypeSet.SonSW_1S &&
                    deviceTypeSet != DeviceTypeSet.SonSW_2S &&
                    deviceTypeSet != DeviceTypeSet.SonSW_3S &&
                    deviceTypeSet != DeviceTypeSet.Son86_1S_315_2262_SC &&
                    deviceTypeSet != DeviceTypeSet.SonSW_1S_433_2262 &&
                    deviceTypeSet != DeviceTypeSet.SonLight_1S_433_1527_SC &&
                    deviceTypeSet != DeviceTypeSet.SonPlug_1S_433_1527 &&
                    deviceTypeSet != DeviceTypeSet.SonLED_1S &&
                    deviceTypeSet != DeviceTypeSet.SonCamera &&
                    !isInputDetectDevice(deviceTypeSet)

        }

        @JvmStatic
        fun isNoResponseDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return !isWithResponseDevice(deviceTypeSet)
        }

        @JvmStatic
        fun isCurtainWithoutLocationDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonCurtain_1D ||
                    deviceTypeSet == DeviceTypeSet.SonCurtain_2D
        }

        @JvmStatic
        fun isCurtainWithLocationDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonCurtainLoc
        }

        @JvmStatic
        fun isTemperatureLampDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonTempLED
        }

        @JvmStatic
        fun isRGBLampDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonRGBLED
        }

        @JvmStatic
        fun isRGBWLampDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonRGBWLED
        }

        @JvmStatic
        fun isInputDetectDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.RemoteController ||
                    deviceTypeSet == DeviceTypeSet.SecurityController ||
                    deviceTypeSet == DeviceTypeSet.EntranceGuard ||
                    deviceTypeSet == DeviceTypeSet.InfraredWarning ||
                    deviceTypeSet == DeviceTypeSet.FuelGasWarning ||
                    isScenePanelDevice(deviceTypeSet)
        }

        @JvmStatic
        fun isScenePanelDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.Scenepanel_1D ||
                    deviceTypeSet == DeviceTypeSet.ScenePanel_2D ||
                    deviceTypeSet == DeviceTypeSet.ScenePanel_3D ||
                    deviceTypeSet == DeviceTypeSet.ScenePanel_6D
        }

        @JvmStatic
        fun isIRDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonIR
        }

        @JvmStatic
        fun isDimmerPowerStatisticsDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonDimmer_4D_E_LMS
        }

        @JvmStatic
        fun isSocketPowerStatisticsDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonOutlet_1D_E
        }

        @JvmStatic
        fun isPowerStatisticsDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return isDimmerPowerStatisticsDevice(deviceTypeSet) || isSocketPowerStatisticsDevice(
                deviceTypeSet
            )
        }

        @JvmStatic
        fun is4SocketDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonDimmer_4D_E_LMS ||
                    deviceTypeSet == DeviceTypeSet.SecurityController
        }

        @JvmStatic
        fun is3SocketDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.MomSon ||
                    deviceTypeSet == DeviceTypeSet.SonSW_3S ||
                    deviceTypeSet == DeviceTypeSet.SonSW_3D ||
                    deviceTypeSet == DeviceTypeSet.SonDimmerPWM_3D ||
                    deviceTypeSet == DeviceTypeSet.SonPlug_3D ||
                    deviceTypeSet == DeviceTypeSet.SonPlug_3Dx2 ||
                    isDimmer3D(deviceTypeSet) ||
                    isDimmerSW3D(deviceTypeSet) ||
                    isTouchSW3D(deviceTypeSet) ||
                    isBoxSW3D(deviceTypeSet)
        }

        @JvmStatic
        fun is2SocketDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonSW_2D ||
                    deviceTypeSet == DeviceTypeSet.SonSW_2S ||
                    deviceTypeSet == DeviceTypeSet.SonDimmerPWM_2D ||
                    deviceTypeSet == DeviceTypeSet.SonPlug_2D ||
                    deviceTypeSet == DeviceTypeSet.SonPlug_2Dx2 ||
                    deviceTypeSet == DeviceTypeSet.SonCurtain_2D ||
                    deviceTypeSet == DeviceTypeSet.ScenePanel_2D ||
                    isDimmer2D(deviceTypeSet) ||
                    isDimmerSW2D(deviceTypeSet) ||
                    isTouchSW2D(deviceTypeSet) ||
                    isBoxSW2D(deviceTypeSet)
        }

        @JvmStatic
        fun is1SocketDevice(deviceTypeSet: DeviceTypeSet): Boolean {
            return deviceTypeSet == DeviceTypeSet.SonAlarm ||
                    deviceTypeSet == DeviceTypeSet.Son86_1S ||
                    deviceTypeSet == DeviceTypeSet.SonSW_1D ||
                    deviceTypeSet == DeviceTypeSet.SonSW_1S ||
                    deviceTypeSet == DeviceTypeSet.Son86_1S_315_2262_SC ||
                    deviceTypeSet == DeviceTypeSet.SonSW_1S_433_2262 ||
                    deviceTypeSet == DeviceTypeSet.SonLight_1S_433_1527_SC ||
                    deviceTypeSet == DeviceTypeSet.SonPlug_1S_433_1527 ||
                    deviceTypeSet == DeviceTypeSet.SonLED_1S ||
                    isDimmer1D(deviceTypeSet) ||
                    isDimmerSW1D(deviceTypeSet) ||
                    isTouchSW1D(deviceTypeSet) ||
                    isBoxSW1D(deviceTypeSet) ||
                    deviceTypeSet == DeviceTypeSet.SonDimmerPWM_1D ||
                    deviceTypeSet == DeviceTypeSet.SonPlug_1D ||
                    deviceTypeSet == DeviceTypeSet.SonPlug_1Dx2 ||
                    deviceTypeSet == DeviceTypeSet.SonOutlet_1D ||
                    deviceTypeSet == DeviceTypeSet.SonIR ||
                    deviceTypeSet == DeviceTypeSet.SonLock ||
                    deviceTypeSet == DeviceTypeSet.SonCurtain_1D ||
                    deviceTypeSet == DeviceTypeSet.SonCurtainLoc ||
                    deviceTypeSet == DeviceTypeSet.SonTempLED ||
                    deviceTypeSet == DeviceTypeSet.SonRGBWLED ||
                    deviceTypeSet == DeviceTypeSet.SonRGBWLED ||
                    deviceTypeSet == DeviceTypeSet.SonCamera ||
                    deviceTypeSet == DeviceTypeSet.RemoteController ||
                    deviceTypeSet == DeviceTypeSet.SecurityController ||
                    deviceTypeSet == DeviceTypeSet.EntranceGuard ||
                    deviceTypeSet == DeviceTypeSet.InfraredWarning ||
                    deviceTypeSet == DeviceTypeSet.FuelGasWarning ||
                    deviceTypeSet == DeviceTypeSet.EnvMonitorPlus_W ||
                    deviceTypeSet == DeviceTypeSet.EnvMonitor_W ||
                    deviceTypeSet == DeviceTypeSet.SonOutlet_1D_E ||
                    deviceTypeSet == DeviceTypeSet.Scenepanel_1D
        }
    }
}