package com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType

import kotlinx.serialization.Serializable

@Serializable
enum class DeviceTypeSet(val raw: String) {
    Unknown("unknown"),
    MomSon("mom_son"),                    //主机（根据productionID再作区分）
    SonAlarm("sonAlarm"),    //警号
    Son86_1S("son86_1S"),    //单控单向86墙插
    SonSW_1D("sonSW_1D"),   //单控双向墙壁灯开关
    SonSW_1S("sonSW_1S"),   //单控单向墙壁灯开关
    SonSW_2D("sonSW_2D"),   //双控双向墙壁灯开关
    SonSW_2S("sonSW_2S"),   //双控单向墙壁灯开关
    SonSW_3D("sonSW_3D"),   //三控双向墙壁灯开关
    SonSW_3S("sonSW_3S"),   //三控单向墙壁灯开关
    Son86_1S_315_2262_SC("son86_1S_315_2262_SC"),      //son86_1S_315_2262_SC
    SonSW_1S_433_2262("sonSW_1S_433_2262"),        //sonSW_1S_433_2262
    SonLight_1S_433_1527_SC("sonLight_1S_433_1527_SC"),       //sonLight_1S_433_1527_SC
    SonPlug_1S_433_1527("sonPlug_1S_433_1527"),        //sonPlug_1S_433_1527
    SonLED_1S("sonLED_1S"),        //sonLED_1S
    SonDimmer_1D("sonDimmer_1D"),    //单路暗盒调光器
    SonDimmer_2D("sonDimmer_2D"),    //双路暗盒调光器
    SonDimmer_3D("sonDimmer_3D"),    //三路暗盒调光器
    SonDimmerSW_1D("sonDimmerSW_1D"),        //单路智能调光开关
    SonDimmerSW_2D("sonDimmerSW_2D"),        //双路智能调光开关
    SonDimmerSW_3D("sonDimmerSW_3D"),        //三路智能调光开关
    SonTouchSW_1D("sonTouchSW_1D"),        //单路智能触控开关
    SonTouchSW_2D("sonTouchSW_2D"),        //双路智能触控开关
    SonTouchSW_3D("sonTouchSW_3D"),        //三路智能触控开关
    SonBoxSW_1D("sonBoxSW_1D"),        //单路暗盒开关
    SonBoxSW_2D("sonBoxSW_2D"),        //双路暗盒开关
    SonBoxSW_3D("sonBoxSW_3D"),        //三路暗盒开关
    SonDimmerPWM_1D("sonDimmerPWM_1D"),        //单路PWM调光暗盒
    SonDimmerPWM_2D("sonDimmerPWM_2D"),        //双路PWM调光暗盒
    SonDimmerPWM_3D("sonDimmerPWM_3D"),        //三路PWM调光暗盒
    SonPlug_1D("sonPlug_1D"),        //单控智能插座
    SonPlug_2D("sonPlug_2D"),        //双控智能插座
    SonPlug_3D("sonPlug_3D"),        //三控智能插座
    SonPlug_1Dx2("sonPlug_1Dx2"),    //单控智能排插
    SonPlug_2Dx2("sonPlug_2Dx2"),    //双控智能排插
    SonPlug_3Dx2("sonPlug_3Dx2"),    //三控智能排插
    SonCurtain_1D("sonCurtain_1D"),   //单路智能窗帘
    SonCurtain_2D("sonCurtain_2D"),   //双路智能窗帘
    SonTempLED("sonTempLED"),       //智能色温灯
    SonRGBLED("sonRGBLED"),   //智能调色灯带
    SonRGBWLED("sonRGBWLED"),       //智能调色灯带（带亮度增强）
    SonOutlet_1D("sonOutlet_1D"),   //智能墙壁插座
    SonIR("sonIR"), //红外遥控器
    SonLock("sonLock"),      //智能门锁
    SonCamera("sonCamera"),   //智能摄像机
    SonCurtainLoc("sonCurtainLoc"),   //窗帘控制器
    SonDimmer_4D_E_LMS("sonDimmer_4D_E_LMS"),      //乐美尚电能统计调光器
    SonOutlet_1D_E("sonOutlet_1D_E"),      //电量统计86插座
    SonDimmer_2D_1("sonDimmer_2D_1"),      //双路暗盒调光器扩展
    SonDimmer_3D_1("sonDimmer_3D_1"),      //三路暗盒调光器扩展
    SonDimmer_3D_2("sonDimmer_3D_2"),      //三路暗盒调光器扩展
    SonDimmerSW_2D_1("sonDimmerSW_2D_1"),  //双路智能调光开关扩展
    SonDimmerSW_3D_1("sonDimmerSW_3D_1"),  //三路智能调光开关扩展
    SonDimmerSW_3D_2("sonDimmerSW_3D_2"),  //三路智能调光开关扩展
    SonTouchSW_2D_1("sonTouchSW_2D_1"),      //双路智能触控开关扩展
    SonTouchSW_3D_1("sonTouchSW_3D_1"),      //三路智能触控开关扩展
    SonTouchSW_3D_2("sonTouchSW_3D_2"),      //三路智能触控开关扩展
    SonBoxSW_2D_1("sonBoxSW_2D_1"),  //双路暗盒开关扩展
    SonBoxSW_3D_1("sonBoxSW_3D_1"),   //三路暗盒开关扩展
    SonBoxSW_3D_2("sonBoxSW_3D_2"),    //三路暗盒开关扩展
    RemoteController("remoteController"),   //主机遥控器
    SecurityController("securityController"),       //安防遥控器
    EntranceGuard("entranceGuard"),    //门磁
    InfraredWarning("infraredWarning"),       //红外侦测告警
    FuelGasWarning("fuelGasWarning"),       //燃气告警
    ScenePanel_2D("scenePanel_2D"),   //2键场景面板
    ScenePanel_6D("scenePanel_6D"),   //6键场景面板
    ScenePanel_3D("scenePanel_3D"),   //3键场景面板
    Scenepanel_1D("scenepanel_1D"),   //1键场景面板
    EnvMonitor_W("envMonitor_W"),   //环境侦测仪
    EnvMonitorPlus_W("envMonitorPlus_W");   //环境侦测仪 WiLink 版本

    companion object {
        private val mapping = values().associateBy(DeviceTypeSet::raw)
        fun fromRaw(raw: String) = mapping[raw]
    }
}