package com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition

internal enum class ProductionID(val raw: Int) {
    None(Int.MAX_VALUE),
    WiLinkMom(101),
    WILINK_MOM_BOX(109),
    SOMBOR_MOM_BOX(110),
    SHANFENG_MOM_BOX(111),
    NEUTRAL_MOM_BOX(113),
    WANWUSMART_MOM_BOX(114),
    Zigbee_MOM_SOCKET(191),
    Zigbee_MOM_BOX(192),
    ENV_MONITOR_W(301),
    ENV_MONITOR_PLUS_W(302),


    @Deprecated("废弃")
    VRUNIQUE_102_MOM_PCBA(102),

    @Deprecated("废弃")
    VRUNIQUE_103_MOM_DOORBELL(103),

    @Deprecated("废弃")
    KEEY_MOM_BOX(104),

    @Deprecated("废弃")
    YUSHENGHONG_MOM(105),

    @Deprecated("废弃")
    ORICO_WIFI_MOM_2_SOCKET(106),

    @Deprecated("废弃")
    ORICO_WIFI_MOM_1_SOCKET(107),

    @Deprecated("废弃")
    SIMART_MOM_BOX(108),

    @Deprecated("废弃")
    XIAMENHUATING_MOM_BOX(112);

    companion object {
        private val mapping = values().associateBy(ProductionID::raw)
        fun fromRaw(raw: Int) = mapping[raw]
    }
}