package com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator

import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeSet
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.*
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.ParaStructure
import com.sentray.kmmprotocolmodule.utilityToolKit.HexToolKit
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.*
import kotlin.jvm.JvmStatic

internal class ConfigCmdCreator {
    companion object {
        @JvmStatic
        fun modifyApplianceOnOffStatus(
            sn: String,
            deviceTypeSet: DeviceTypeSet,
            applianceIndex: Int,
            onOffStatus: OnOffStatus,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val jsonObject = buildJsonObject {
                put(ProtocolKey.Sn.raw, sn)
                put(ProtocolKey.Seq.raw, seq)
                put(ProtocolKey.FactoryID.raw, factoryID.raw)
                put(ProtocolKey.Cmd.raw, Cmd.Set.raw)
                putJsonObject(deviceTypeSet.raw) {
                    val maskString = HexToolKit.indexToHexString(applianceIndex)

                    if (deviceTypeSet == DeviceTypeSet.MomSon) {
                        if (applianceIndex < 3) {
                            val onOffStatusBoolList = when (onOffStatus) {
                                //"00"
                                OnOffStatus.Off -> HexToolKit.longToBoolList(0u)
                                //"01"
                                OnOffStatus.On -> HexToolKit.longToBoolList((1 shl (applianceIndex * 2)).toULong())
                                //"10"
                                OnOffStatus.Follow -> HexToolKit.longToBoolList((1 shl (applianceIndex * 2 + 1)).toULong())
                                //"11"
                                OnOffStatus.Reserve -> HexToolKit.longToBoolList(((1 shl (applianceIndex * 2)) or (1 shl (applianceIndex * 2 + 1))).toULong())
                            }
                            val onOffStatusHexString =
                                HexToolKit.boolListToHexString(onOffStatusBoolList)

                            put(ProtocolKey.OnOffStatus.raw, onOffStatusHexString)
                            put(ProtocolKey.OnOffRlyMask.raw, maskString)
                        }
                    } else {
                        val powerOnStatusList = listOf(onOffStatus.raw)

                        put(ProtocolKey.ConfMask.raw, maskString)
                        putJsonArray(ProtocolKey.PowerOnStatus.raw) {
                            powerOnStatusList.forEach { powerOnStatus ->
                                add(powerOnStatus)
                            }
                        }
                    }
                }
            }

            @OptIn(ExperimentalSerializationApi::class)
            val cmdRaw = Json.encodeToString(jsonObject)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }

        @JvmStatic
        fun setMinBrightPercent(
            sn: String,
            deviceTypeSet: DeviceTypeSet,
            applianceIndex: Int,
            minBrightPercent: Int,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val jsonObject = buildJsonObject {
                put(ProtocolKey.Sn.raw, sn)
                put(ProtocolKey.Seq.raw, seq)
                put(ProtocolKey.FactoryID.raw, factoryID.raw)
                put(ProtocolKey.Cmd.raw, Cmd.Set.raw)
                putJsonObject(deviceTypeSet.raw) {
                    val confMask = HexToolKit.indexToHexString(applianceIndex)
                    val minBrightPercentValid = when {
                        minBrightPercent < 0 -> 0
                        minBrightPercent > 100 -> 100
                        else -> minBrightPercent
                    }
                    val minBrightPercentList = listOf(minBrightPercentValid)

                    put(ProtocolKey.ConfMask.raw, confMask)
                    putJsonArray(ProtocolKey.MinBrightPercent.raw) {
                        minBrightPercentList.forEach { value ->
                            add(value)
                        }
                    }
                }
            }

            @OptIn(ExperimentalSerializationApi::class)
            val cmdRaw = Json.encodeToString(jsonObject)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }

        @JvmStatic
        fun setTurnOnBrightPercent(
            sn: String,
            deviceTypeSet: DeviceTypeSet,
            applianceIndex: Int,
            turnOnBrightPercent: Int,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val jsonObject = buildJsonObject {
                put(ProtocolKey.Sn.raw, sn)
                put(ProtocolKey.Seq.raw, seq)
                put(ProtocolKey.FactoryID.raw, factoryID.raw)
                put(ProtocolKey.Cmd.raw, Cmd.Set.raw)
                putJsonObject(deviceTypeSet.raw) {
                    val confMask = HexToolKit.indexToHexString(applianceIndex)
                    val turnOnBrightPercentValid = when {
                        turnOnBrightPercent < 0 -> 0
                        turnOnBrightPercent > 100 -> 100
                        else -> turnOnBrightPercent
                    }
                    val turnOnBrightPercentList = listOf(turnOnBrightPercentValid)

                    put(ProtocolKey.ConfMask.raw, confMask)
                    putJsonArray(ProtocolKey.TurnOnBrightPercent.raw) {
                        turnOnBrightPercentList.forEach { value ->
                            add(value)
                        }
                    }
                }
            }

            @OptIn(ExperimentalSerializationApi::class)
            val cmdRaw = Json.encodeToString(jsonObject)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }

        @JvmStatic
        fun setTempLedTurnOnPara(
            sn: String,
            deviceTypeSet: DeviceTypeSet,
            applianceIndex: Int,
            turnOnBrightPercent: Int,
            turnOnTemperaturePercent: Int,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val jsonObject = buildJsonObject {
                put(ProtocolKey.Sn.raw, sn)
                put(ProtocolKey.Seq.raw, seq)
                put(ProtocolKey.FactoryID.raw, factoryID.raw)
                put(ProtocolKey.Cmd.raw, Cmd.Set.raw)
                putJsonObject(deviceTypeSet.raw) {
                    val confMask = HexToolKit.indexToHexString(applianceIndex)
                    val turnOnBrightPercentValid = when {
                        turnOnBrightPercent < 0 -> 0
                        turnOnBrightPercent > 100 -> 100
                        else -> turnOnBrightPercent
                    }
                    val turnOnTemperaturePercentValid = when {
                        turnOnTemperaturePercent < 0 -> 0
                        turnOnTemperaturePercent > 100 -> 100
                        else -> turnOnTemperaturePercent
                    }
                    val para = ParaStructure()
                    para.setTemperatureLampBright(turnOnBrightPercentValid.toULong())
                    para.setTemperatureLampTemp(turnOnTemperaturePercentValid.toULong())

                    val turnOnParaList = listOf(para.getRawValue().toInt())

                    put(ProtocolKey.ConfMask.raw, confMask)
                    putJsonArray(ProtocolKey.TurnOnBrightPercent.raw) {
                        turnOnParaList.forEach { value ->
                            add(value)
                        }
                    }
                }
            }

            @OptIn(ExperimentalSerializationApi::class)
            val cmdRaw = Json.encodeToString(jsonObject)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }

        @JvmStatic
        fun setRGBWTurnOnColor(
            sn: String,
            deviceTypeSet: DeviceTypeSet,
            applianceIndex: Int,
            para: ParaStructure,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val jsonObject = buildJsonObject {
                put(ProtocolKey.Sn.raw, sn)
                put(ProtocolKey.Seq.raw, seq)
                put(ProtocolKey.FactoryID.raw, factoryID.raw)
                put(ProtocolKey.Cmd.raw, Cmd.Set.raw)
                putJsonObject(deviceTypeSet.raw) {
                    val confMask = HexToolKit.indexToHexString(applianceIndex)
                    val turnOnBrightPercentList = mutableListOf(
                        para.getColor(ParaStructure.RgbwType.Red).toInt(),
                        para.getColor(ParaStructure.RgbwType.Green).toInt(),
                        para.getColor(ParaStructure.RgbwType.Blue).toInt(),
                        para.getColor(ParaStructure.RgbwType.Bright).toInt(),
                    )
                    if (deviceTypeSet == DeviceTypeSet.SonRGBWLED) {
                        turnOnBrightPercentList.add(para.getColor(ParaStructure.RgbwType.W).toInt())
                    }

                    put(ProtocolKey.ConfMask.raw, confMask)
                    putJsonArray(ProtocolKey.TurnOnBrightPercent.raw) {
                        turnOnBrightPercentList.forEach { value ->
                            add(value)
                        }
                    }
                }
            }

            @OptIn(ExperimentalSerializationApi::class)
            val cmdRaw = Json.encodeToString(jsonObject)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }

        //缓开缓关亮度变化档位 ：1~15
        @JvmStatic
        fun setOnOffBrightAdjustSpeed(
            sn: String,
            deviceTypeSet: DeviceTypeSet,
            applianceIndex: Int,
            adjustSpeed: Int,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val jsonObject = buildJsonObject {
                put(ProtocolKey.Sn.raw, sn)
                put(ProtocolKey.Seq.raw, seq)
                put(ProtocolKey.FactoryID.raw, factoryID.raw)
                put(ProtocolKey.Cmd.raw, Cmd.Set.raw)
                putJsonObject(deviceTypeSet.raw) {
                    val confMask = HexToolKit.indexToHexString(applianceIndex)
                    val adjustSpeedValid = when {
                        adjustSpeed > 15 -> 15
                        adjustSpeed < 1 -> 1
                        else -> adjustSpeed
                    }
                    val valueList = listOf(adjustSpeedValid)

                    put(ProtocolKey.ConfMask.raw, confMask)
                    putJsonArray(ProtocolKey.OnOffBrightAdjSpeed.raw) {
                        valueList.forEach { value ->
                            add(value)
                        }
                    }
                }
            }

            @OptIn(ExperimentalSerializationApi::class)
            val cmdRaw = Json.encodeToString(jsonObject)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }
    }
}