package com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser.parserUtil

import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeSet
import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeUtil
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.ProtocolContent
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolKey
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.DevicePara
import com.sentray.kmmprotocolmodule.utilityToolKit.HexToolKit
import kotlinx.serialization.json.JsonObject
import kotlinx.serialization.json.jsonObject

internal fun ProtocolContent.parseOutputDeviceContent(jsonObject: JsonObject) {
    val outputDevContentNew = ProtocolContent.OutputDevContent().also { outputDevContent ->
        jsonObject.value<String>(ProtocolKey.OutputDeviceInstalled.raw)?.let { hexString ->
            outputDevContent.outputDeviceInstalled = HexToolKit.hexStringToBoolList(hexString)
        }

        //搜索协议包中所有设备类型，并获取对应的设备参数
        val deviceTypeStringList: MutableList<String> = mutableListOf()
        jsonObject.keys.forEach { deviceTypeString ->
            DeviceTypeUtil.findDeviceTypeNumber(deviceTypeString)?.let {
                deviceTypeStringList.add(deviceTypeString)
            }
        }

        if (deviceTypeStringList.isNotEmpty()) {
            outputDevContent.devParaMap = hashMapOf()
        }
        outputDevContent.devParaMap?.let { devParaMap ->
            deviceTypeStringList.forEach {
                DeviceTypeSet.fromRaw(it)?.let { deviceType ->
                    //解析 DevicePara
                    jsonObject[deviceType.raw]?.jsonObject?.let { deviceParaJsonObject ->
                        devParaMap[deviceType] = DevicePara().also { devicePara ->
                            devicePara.initialFromRaw(deviceParaJsonObject, deviceType)
                        }
                    }
                }
            }
        }
    }

    if (outputDevContentNew.isNotEmpty()) {
        this.outputDevContent = outputDevContentNew
    }
//    freeze(this.outputDevContent)
}