package com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser.parserUtil

import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.ProtocolContent
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.Cmd
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolKey
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.TimerParaV1
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.TimerParaV2
import com.sentray.kmmprotocolmodule.utilityToolKit.HexToolKit
import kotlinx.serialization.json.JsonObject

internal fun ProtocolContent.parseTimerContent(jsonObject: JsonObject) {
    val timerContentNew = ProtocolContent.TimerContent().also { timerContent ->
        //timerInstalled parse
        jsonObject.value<String>(ProtocolKey.TimerInstalled.raw)?.let {
            timerContent.timerInstalled = HexToolKit.hexStringToBoolList(it)
//            freeze(timerContent.timerInstalled)
        }

        //timer V1 parse
        //"timer":["0,5c7e33bd,0,0,1,1,1","1,5c7ce5da,4,1,1,1,1","2,5c788cc5,0,0,1,0,0"]
        //delTimerAck : {"sn":"36303132313034303541576A","seq":239606620,"factoryID":135808,"cmd":"delTimerAck","timer":[0]}
        try {
            jsonObject.value<List<String>>(ProtocolKey.Timer.raw)?.let { timerV1StringList ->
                val timerParaV1ListNew: MutableList<TimerParaV1> = mutableListOf()
                timerV1StringList.forEach {
                    timerParaV1ListNew.add(TimerParaV1().also { timerParaV1 ->
                        timerParaV1.initialFromRaw(it)
                    })
                }
                timerContent.timerParaV1List = timerParaV1ListNew.toList()
//                freeze(timerContent.timerParaV1List)
            }
        } catch (e: Exception) {
//            e.printStackTrace()
            try {
                jsonObject.value<List<Int>>(ProtocolKey.Timer.raw)?.let { delTimerIndexList ->
                    timerContent.deletedTimerIndexList = delTimerIndexList
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }


        //timer V2 parse
        try {
            jsonObject.value<String>(ProtocolKey.Cmd.raw)?.let { cmd ->
                when (cmd) {
                    Cmd.GetTimerAck.raw -> {
                        jsonObject.value<List<List<Long>>>(ProtocolKey.TimerPara.raw)?.let {
                            val timerParaV2ListNew: MutableList<TimerParaV2> = mutableListOf()
                            it.forEach { timerParaV2List ->
                                timerParaV2ListNew.add(TimerParaV2().also { timerParaV2 ->
                                    timerParaV2.initialFromRawList(timerParaV2List)
                                })
                            }

                            timerContent.timerParaV2List = timerParaV2ListNew.toList()
//                            freeze(timerContent.timerParaV2List)
                        }
                    }
                    Cmd.AddTimer2Ack.raw, Cmd.ModifyTimer2Ack.raw -> {
                        jsonObject.value<List<Long>>(ProtocolKey.TimerPara.raw)?.let {
                            val timerParaV2ListNew: MutableList<TimerParaV2> = mutableListOf()
                            timerParaV2ListNew.add(TimerParaV2().also { timerParaV2 ->
                                timerParaV2.initialFromRawList(it)
                            })

                            timerContent.timerParaV2List = timerParaV2ListNew.toList()
//                            freeze(timerContent.timerParaV2List)
                        }
                    }
                    Cmd.DelTimer2Ack.raw -> {
                        jsonObject.value<List<Int>>(ProtocolKey.TimerPara.raw)
                            ?.let { delTimerIndexList ->
                                timerContent.deletedTimerIndexList = delTimerIndexList
                            }
                    }
                    else -> {}
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    if (timerContentNew.isNotEmpty()) {
        this.timerContent = timerContentNew
    }

//    freeze(this.timerContent)
}