package com.sentray.kmmprotocolmodule.utilityToolKit.genericClasses

class MutableLinkList<E>(vararg items: E) {
    private val elements = items.toMutableList()

    fun addFirst(element: E) = elements.add(element)

    fun addLast(element: E) = elements.add(elements.size - 1, element)

    fun getFirst(): E? = elements.removeFirstOrNull()

    fun getLast(): E? = elements.removeLastOrNull()

    fun isEmpty() = elements.isEmpty()

    fun isNotEmpty() = elements.isNotEmpty()

    fun size() = elements.size

    override fun toString() = "MutableLinkList(${elements.joinToString()})"
}

internal fun <E> mutableLinkListOf(vararg elements: E) = MutableLinkList(*elements)