package com.sentray.kmmprotocolmodule.sdk.command

import com.sentray.kmmprotocolmodule.sdk.parser.parserResult.DefaultAction
import com.sentray.kmmprotocolmodule.sdk.parser.parserResult.DetectableApplianceInfo
import com.sentray.kmmprotocolmodule.sdk.parser.parserResult.DetectableApplianceStatus
import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeClassify
import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeSet
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ENetworkType
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolVersion
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.ParaStructure
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator.CommandData
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator.LinkageCmdCreator
import com.sentray.kmmprotocolmodule.utilityToolKit.HexToolKit
import kotlin.jvm.JvmStatic

//联动配置命令
class LinkageCmd {
   
    data class UserActionInfoNew(
        val devTypeSet: DeviceTypeSet,
        val applianceIndex: Int,
        val action: Boolean,
        val para: ParaStructure,
    )

    companion object {
        @JvmStatic
       
        fun addUserActionListCmd(
            sn: String,
            bindApplianceInfoList: List<UserActionInfoNew>,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): List<CommandData> {
            val bindUserActionListCmdDataList =
                mutableListOf<CommandData>()

            //将 bindApplianceInfoList 按照类型进行分类
            val bindApplianceInfoClassifyList = mutableListOf<List<UserActionInfoNew>>()

            //1. 获取所有设备类型
            val deviceTypeSet = mutableSetOf<DeviceTypeSet>()
            bindApplianceInfoList.forEach { bindApplianceInfo ->
                deviceTypeSet.add(bindApplianceInfo.devTypeSet)
            }

            //2. 根据每种设备类型，对 bindApplianceInfobList 进行分类
            val bindApplianceInfoListRaw = bindApplianceInfoList.toMutableList()
            deviceTypeSet.forEach { deviceTypeSetValid ->
                val bindApplianceInfoForOneDeviceTypeList = mutableListOf<UserActionInfoNew>()
                bindApplianceInfoListRaw.forEach { bindApplianceInfo ->
                    if (bindApplianceInfo.devTypeSet == deviceTypeSetValid) {
                        bindApplianceInfoForOneDeviceTypeList.add(bindApplianceInfo)
                    }
                }
                bindApplianceInfoClassifyList.add(bindApplianceInfoForOneDeviceTypeList)
                bindApplianceInfoListRaw.removeAll(bindApplianceInfoForOneDeviceTypeList)
            }

            //3. 根据每种设备类型，生成 addUserAction 命令
            bindApplianceInfoClassifyList.forEach { bindApplianceInfoListForOneDevice ->
                val firstObject = bindApplianceInfoListForOneDevice[0]
                val deviceType = firstObject.devTypeSet

                val isDeviceWithPara: (() -> Boolean) = {
                    DeviceTypeClassify.isDimmerDevice(deviceType) ||
                            DeviceTypeClassify.isTemperatureLampDevice(deviceType) ||
                            DeviceTypeClassify.isCurtainWithLocationDevice(deviceType) ||
                            DeviceTypeClassify.isCurtainWithoutLocationDevice(deviceType) ||
                            DeviceTypeClassify.isIRDevice(deviceType)
                }

                if (DeviceTypeClassify.isInputDetectDevice(deviceType)) {
                    //过滤输入类型
                } else if (DeviceTypeClassify.isRGBLampDevice(deviceType) ||
                    DeviceTypeClassify.isRGBWLampDevice(deviceType)
                ) {
                    //对于 RGB、RGBW 设备，一个设备需要使用一个 userAction
                    bindApplianceInfoListForOneDevice.forEach { bindApplianceInfo ->
                        val applianceMaskList =
                            HexToolKit.indexToBoolList(bindApplianceInfo.applianceIndex)
                        val applianceActionList = when (bindApplianceInfo.action) {
                            true -> applianceMaskList
                            false -> listOf(false)
                        }

                        val paraRawValueList = mutableListOf(
                            bindApplianceInfo.para.getColor(ParaStructure.RgbwType.Red)
                                .toLong(),
                            bindApplianceInfo.para.getColor(ParaStructure.RgbwType.Green)
                                .toLong(),
                            bindApplianceInfo.para.getColor(ParaStructure.RgbwType.Blue)
                                .toLong(),
                            bindApplianceInfo.para.getColor(ParaStructure.RgbwType.Bright)
                                .toLong(),
                        )

                        if (DeviceTypeClassify.isRGBWLampDevice(deviceType)) {
                            paraRawValueList.add(
                                bindApplianceInfo.para.getColor(ParaStructure.RgbwType.W)
                                    .toLong()
                            )
                        }

                        val commandData = LinkageCmdCreator.addAction(
                            sn,
                            deviceType,
                            applianceActionList,
                            applianceMaskList,
                            paraRawValueList,
                            applianceMaskList,
                            protocolVersion = protocolVersion,
                            networkType = networkType
                        )
                        bindUserActionListCmdDataList.add(commandData)
                    }
                } else {
                    val applianceActionList: List<Boolean>
                    val applianceMaskList: List<Boolean>
                    val paraRawValueList = mutableListOf<Long>()
                    val paraMaskList: List<Boolean>

                    val indexList = mutableListOf<Int>()
                    val actionIndexList = mutableListOf<Int>()
                    val paraMaskIndexList = mutableListOf<Int>()

                    bindApplianceInfoListForOneDevice.sortedBy { it.applianceIndex }.forEach {
                        indexList.add(it.applianceIndex)
                        if (it.action) {
                            actionIndexList.add(it.applianceIndex)
                        }

                        if (isDeviceWithPara()) {
                            paraRawValueList.add(it.para.getRawValue().toLong())
                        } else {
                            if (it.para.getRawValue() == ParaStructure.ParaAction.OnOff.raw.toULong()) {
                                paraMaskIndexList.add(it.applianceIndex)
                                paraRawValueList.add(it.para.getRawValue().toLong())
                            }
                        }
                    }

                    applianceActionList = HexToolKit.indexListToBoolList(actionIndexList)
                    applianceMaskList = HexToolKit.indexListToBoolList(indexList)

                    paraMaskList = when (isDeviceWithPara()) {
                        true -> applianceMaskList
                        false -> HexToolKit.indexListToBoolList(paraMaskIndexList)
                    }

                    val commandData = LinkageCmdCreator.addAction(
                        sn,
                        deviceType,
                        applianceActionList,
                        applianceMaskList,
                        paraRawValueList,
                        paraMaskList,
                        protocolVersion = protocolVersion,
                        networkType = networkType
                    )
                    bindUserActionListCmdDataList.add(commandData)
                }
            }

            return bindUserActionListCmdDataList
        }

        @JvmStatic
        fun bindUserActionListAndDetectableApplianceStatusListCmd(
            detectableApplianceInfo: DetectableApplianceInfo,
            userActionIndexList: List<Int>,
            detectableApplianceStatusList: List<DetectableApplianceStatus>,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData? {
            val userActionMaskList = HexToolKit.indexListToBoolList(userActionIndexList)
            val triggerStatusList: List<Boolean>
            val triggerMaskList: List<Boolean>

            val triggerIndexList = mutableListOf<Int>()
            val triggerStatusIndexList = mutableListOf<Int>()
            detectableApplianceStatusList.forEach { detectableApplianceStatus ->
                triggerIndexList.add(detectableApplianceStatus.applianceIndex)
                if (detectableApplianceStatus.status) {
                    triggerStatusIndexList.add(detectableApplianceStatus.applianceIndex)
                }
            }

            triggerStatusList = HexToolKit.indexListToBoolList(triggerStatusIndexList)
            triggerMaskList = HexToolKit.indexListToBoolList(triggerIndexList)

            val commandData: CommandData? =
                detectableApplianceInfo.applianceIndex?.let {
                    LinkageCmdCreator.setTriggerAction(
                        detectableApplianceInfo.sn,
                        it,
                        userActionMaskList,
                        triggerStatusList,
                        triggerMaskList,
                        protocolVersion = protocolVersion,
                        networkType = networkType
                    )
                } ?: run {
                    null
                }
            return commandData
        }

        @JvmStatic
        fun modifyDetectableDeviceStatus(
            detectableApplianceInfo: DetectableApplianceInfo,
            status: Boolean,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData? {
            val applianceIndex = detectableApplianceInfo.applianceIndex ?: return null

            val triggerMaskBoolList = HexToolKit.indexToBoolList(applianceIndex)
            val triggerStatusBoolList = when (status) {
                true -> HexToolKit.indexToBoolList(applianceIndex)
                false -> HexToolKit.longToBoolList(0UL)
            }

            val commandData = LinkageCmdCreator.setTriggerStatus(
                detectableApplianceInfo.sn,
                triggerStatusBoolList,
                triggerMaskBoolList,
                protocolVersion = protocolVersion,
                networkType = networkType
            )

            return commandData
        }

        @JvmStatic
        fun modifyDetectableDeviceTriggeredDefaultAction(
            detectableApplianceInfo: DetectableApplianceInfo,
            defaultActionList: List<DefaultAction>,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData? {
            val applianceIndex = detectableApplianceInfo.applianceIndex ?: return null

            val defaultActionRawList = defaultActionList.map { it.raw }
            val defaultActionMaskBoolList = HexToolKit.indexListToBoolList(defaultActionRawList)

            val commandData = LinkageCmdCreator.setTriggerDefaultAction(
                detectableApplianceInfo.sn,
                applianceIndex,
                defaultActionMaskBoolList,
                protocolVersion = protocolVersion,
                networkType = networkType
            )

            return commandData
        }

        @JvmStatic
        fun modifyDetectableDeviceTriggeredDelay(
            detectableApplianceInfo: DetectableApplianceInfo,
            delaySeconds: Int,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData? {
            val applianceIndex = detectableApplianceInfo.applianceIndex ?: return null

            val commandData = LinkageCmdCreator.setTriggerDelay(
                detectableApplianceInfo.sn,
                applianceIndex,
                delaySeconds,
                protocolVersion = protocolVersion,
                networkType = networkType
            )

            return commandData
        }

        @JvmStatic
        fun modifyDetectableDeviceEmergencyStatus(
            detectableApplianceInfo: DetectableApplianceInfo,
            emergencyStatus: Boolean,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData? {
            val applianceIndex = detectableApplianceInfo.applianceIndex ?: return null

            val triggerMaskBoolList = HexToolKit.indexToBoolList(applianceIndex)
            val emergencyTriggerBoolList = when (emergencyStatus) {
                true -> HexToolKit.indexToBoolList(applianceIndex)
                false -> HexToolKit.longToBoolList(0UL)
            }
            val commandData = LinkageCmdCreator.setEmergencyTrigger(
                detectableApplianceInfo.sn,
                emergencyTriggerBoolList,
                triggerMaskBoolList,
                protocolVersion = protocolVersion,
                networkType = networkType
            )

            return commandData
        }
    }
}