package com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent

import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeSet
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.Cmd
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.FactoryID
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProductionID
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolVersion
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.*
import kotlinx.serialization.Serializable

@Serializable
internal class ProtocolContent {
    @Serializable
    class BaseContent {
        var sn: String? = null
        var seq: Long? = null
        var cmd: Cmd? = null
        var serviceDomain: String? = null
        var protocolVersion: ProtocolVersion = ProtocolVersion.V1
        var factoryID: FactoryID? = null
        var productionID: ProductionID? = null
        var hardwareID: Int? = null
        var fwPath: String? = null
        var fwVersion: FirmwareVersion? = null
        var confVer: Int? = null
        var failure: Int? = null

        internal fun isNotEmpty(): Boolean {
            return sn != null ||
                    seq != null ||
                    cmd != null ||
                    serviceDomain != null ||
                    factoryID != null ||
                    productionID != null ||
                    hardwareID != null ||
                    fwPath != null ||
                    fwVersion != null ||
                    confVer != null ||
                    failure != null
        }
    }

    @Serializable
    class OutputDevContent {
        //output device installed bit
        var outputDeviceInstalled: List<Boolean>? = null

        var devParaMap: HashMap<DeviceTypeSet, DevicePara>? = null

        internal fun isNotEmpty(): Boolean {
            return outputDeviceInstalled != null || devParaMap != null
        }
    }

    @Serializable
    class TimerContent {
        //timer v1 para
        var timerParaV1List: List<TimerParaV1>? = null

        //timer v2 para
        var timerParaV2List: List<TimerParaV2>? = null

        //timer v1 & v2 share
        var timerInstalled: List<Boolean>? = null

        //del timer para
        //delTimerAck : {"sn":"36303132313034303541576A","seq":239606620,"factoryID":135808,"cmd":"delTimerAck","timer":[0]}
        //delTimer2Ack : {"sn":"F0FE6B96A486F0FE6B96A486","seq":1259652874,"factoryID":123456,"confVer":2024129763,"cmd":"delTimer2Ack","timerPara":[1],"actionInstalled":"000000000206031d"}
        var deletedTimerIndexList: List<Int>? = null

        internal fun isNotEmpty(): Boolean {
            return timerParaV1List != null ||
                    timerParaV2List != null ||
                    timerInstalled != null ||
                    deletedTimerIndexList != null
        }
    }

   
    @Serializable
    class InputDevContent {
        var inputDeviceIndex: Int? = null
        var inputDeviceInstalled: List<Boolean>? = null
        var triggerStatus: List<Boolean>? = null
        var noDisableTrigger: List<Boolean>? = null
        var triggerInstalled: List<Boolean>? = null
        var triggerParaList: List<TriggerPara>? = null

        //input device action para
        var actionInstalled: List<Boolean>? = null
        var userActionParaList: List<UserActionPara>? = null

        var ver: FirmwareVersion? = null

        internal fun isNotEmpty(): Boolean {
            return inputDeviceIndex != null ||
                    inputDeviceInstalled != null ||
                    triggerStatus != null ||
                    noDisableTrigger != null ||
                    triggerInstalled != null ||
                    triggerParaList != null ||
                    actionInstalled != null ||
                    userActionParaList != null ||
                    ver != null
        }
    }

    var baseContent: ProtocolContent.BaseContent? = null

    var timerContent: TimerContent? = null

    var outputDevContent: OutputDevContent? = null

   
    var inputDevContent: InputDevContent? = null

    //freeze 后，iOS 中可以使用任意线程访问该变量，但不能修改
//   
//    fun freezeSelf() {
//        freeze(baseContent)
//        freeze(timerContent)
//        freeze(outputDevContent)
//        freeze(inputDevContent)
//        freeze(this)
//    }

    //base para
//    var sn: String? = null
//    var seq: Long? = null
//    var cmd: Cmd? = null
//    var serviceDomain: String? = null
//    var protocolVersion: Int? = null
//    var factoryID: Int? = null
//    var productionID: Int? = null
//    var hardwareID: Int? = null
//    var fwPath: String? = null
//    var fwVersion: String? = null
//    var confVer: Int? = null
//    var failure: Int? = null

    //timer v1 para
//    val timer: List<TimerV1>? = null

    //timer v2 para
//    val timerPara: List<TimerV2>? = null

    //timer v1 & v2 share
//    val timerInstalled: List<Boolean>? = null

    //device type in string
//    val devType: DeviceTypeSet? = null
//    val devPara: DevicePara? = null

    //output device installed bit
//    val outputDeviceInstalled: List<Boolean>? = null

    //input device para
//    val inputDeviceInstalled: List<Boolean>? = null
//    val triggerStatus: List<Boolean>? = null
//    val noDisableTrigger: List<Boolean>? = null
//    val triggerInstalled: List<Boolean>? = null
//    val triggerParaList: List<TriggerPara>? = null

    //input device action para
//    val actionInstalled: List<Boolean>? = null
//    val userActionParaList: List<UserActionPara>? = null

    //error
//    val failure: Int? = null
}