package com.sentray.kmmprotocolmodule.dababase.model

import com.sentray.kmmprotocolmodule.sdk.parser.parserResult.ControllableApplianceInfo
import com.sentray.kmmprotocolmodule.sdk.parser.parserResult.DetectableApplianceInfo

class UpdatedApplianceInfo {
    enum class EUpdateType {
        Unchanged,
        Add,
        Modify,
        Delete,
    }

    data class UpdatedControllableApplianceInfo(
        val controllableApplianceInfo: ControllableApplianceInfo,
        val updateType: EUpdateType
    )

    data class UpdatedDetectableApplianceInfo(
        val detectableApplianceInfo: DetectableApplianceInfo,
        val updateType: EUpdateType
    )

    private val updatedControllableApplianceInfoMap: MutableMap<String, UpdatedControllableApplianceInfo> =
        mutableMapOf()
    private val updatedDetectableApplianceInfoMap: MutableMap<String, UpdatedDetectableApplianceInfo> = mutableMapOf()

    internal fun clear() {
        updatedControllableApplianceInfoMap.clear()
        updatedDetectableApplianceInfoMap.clear()
    }

    internal fun insertUpdatedControllableApplianceInfo(
        controllableApplianceInfo: ControllableApplianceInfo,
        updateType: EUpdateType
    ) {
        val key = controllableApplianceInfo.createKey()
        val updatedControllableApplianceInfo = UpdatedControllableApplianceInfo(controllableApplianceInfo, updateType)
        updatedControllableApplianceInfoMap[key] = updatedControllableApplianceInfo
    }

    internal fun insertUpdatedDetectableApplianceInfo(
        detectableApplianceInfo: DetectableApplianceInfo,
        updateType: EUpdateType
    ) {
        val key = detectableApplianceInfo.createKey()
        val updatedDetectableApplianceInfo = UpdatedDetectableApplianceInfo(detectableApplianceInfo, updateType)
        updatedDetectableApplianceInfoMap[key] = updatedDetectableApplianceInfo
    }
}