package com.sentray.kmmprotocolmodule.network.udp

import com.sentray.kmmprotocolmodule.utilityToolKit.loggerKit.KMMLogger
import io.ktor.network.selector.*
import io.ktor.network.sockets.*
import io.ktor.utils.io.core.*
import kotlinx.coroutines.*

@Deprecated("UDP Broadcast 模式下无法接收数据")
class UdpClient(hostName: String, port: Int) {
    private var udpSocket: ConnectedDatagramSocket? = null
    private var selectorManager: SelectorManager? = null
    private val socketAddress = InetSocketAddress(hostName, port)

    @OptIn(ExperimentalCoroutinesApi::class)
    suspend fun startConnect() {
        try {
            disconnect()
            if (udpSocket == null) {
                selectorManager = SelectorManager(Dispatchers.Unconfined)
                selectorManager?.let {
                    udpSocket = aSocket(it).udp().connect(
                        remoteAddress = socketAddress,
                        configure = { broadcast = true })
                }

                udpSocket?.let { udpSocketValid ->
                    KMMLogger.d("UDP Client Connect succeed, localAddress = ${udpSocketValid.localAddress}, remoteAddress = ${udpSocketValid.remoteAddress}")
                    CoroutineScope(Dispatchers.Unconfined).launch {
                        while (udpSocket != null) {
                            if (!udpSocketValid.incoming.isClosedForReceive) {
                                KMMLogger.d("UDP Client try to receive data")
                                val datagram = udpSocketValid.receive()
                                KMMLogger.d("try Receive result = ${datagram.address}")
                                delay(1000)
                                val rec = datagram.packet.readText()
                                KMMLogger.d("UDP Client receive data : $rec")

                            } else {
                                delay(1000)
                                KMMLogger.d("UDP Client read channel closed")
                            }
                            //TODO: 无法读取，readChannel closed!!
//                            if (!receiveChannel.isClosedForRead) {
//                                KMMLogger.d("UDP Client Ready : start receive data")
//                                receiveChannel.awaitContent()
//                                KMMLogger.d("UDP Client Ready : received data!!")
//                                if (receiveChannel.availableForRead == 0) break
//                                val byteArray = ByteArray(receiveChannel.availableForRead)
//                                receiveChannel.readAvailable(
//                                    byteArray,
//                                    0,
//                                    receiveChannel.availableForRead
//                                )
//                                val receiveMessage = byteArray.decodeToString()
//                                KMMLogger.d("UDP Client Receive : $receiveMessage")
//                                //TODO: UDP 广播数据处理
//                            } else {
//                                delay(1000)
//                                KMMLogger.d("UDP Client Failure : Read Channel closed")
//                            }
                        }
                        KMMLogger.e("UDP Client exit!!")
                    }
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    @OptIn(ExperimentalCoroutinesApi::class)
    suspend fun sendData(message: String) {
        udpSocket?.let {
            it.send(
                Datagram(
                    ByteReadPacket(message.toByteArray()),
                    socketAddress
                )
            )
            KMMLogger.d("UDP Client send data : $message : ${socketAddress.hostname} : ${socketAddress.port}")
        } ?: run {
            KMMLogger.d("UDP Client Not Connect")
        }
    }


    fun disconnect() {
        udpSocket?.close()
        udpSocket = null

        KMMLogger.d("UDP Client Disconnect")
    }
}