package com.sentray.kmmprotocolmodule.network.smartlink

import com.hiflying.smartlink.OnSmartLinkListener
import com.hiflying.smartlink.SmartLinkedModule
import com.hiflying.smartlink.v7.MulticastSmartLinker
import com.sentray.kmmprotocolmodule.KMMContext
import com.sentray.kmmprotocolmodule.KmmApplicationCache
import com.sentray.kmmprotocolmodule.utilityToolKit.asyncKit.KAsync
import com.sentray.kmmprotocolmodule.utilityToolKit.loggerKit.KMMLogger

internal actual class SmartLinkManager {
    actual companion object {
        actual fun startSmartLink(
            ssid: String,
            pwd: String,
            timeoutSeconds: Long,
            successCallback: SuccessCallback,
            failureCallback: FailureCallback,
            finishCallback: FinishCallback
        ) {
            KmmApplicationCache.getContext()?.let {
                startSmartLinkForAndroid(
                    it,
                    ssid,
                    pwd,
                    timeoutSeconds,
                    successCallback,
                    failureCallback,
                    finishCallback
                )
            } ?: run {
                failureCallback.invoke("Please call [KmmApplicationCache.injectApplication(application)] first!!")
            }
        }

        private fun startSmartLinkForAndroid(
            kmmContext: KMMContext,
            ssid: String,
            pwd: String,
            timeoutSeconds: Long,
            successCallback: SuccessCallback,
            failureCallback: FailureCallback,
            finishCallback: FinishCallback
        ) {
            val smartLinkV7 = MulticastSmartLinker.getInstance()
            smartLinkV7.setWaitMoreDevicePeriod(1)
            smartLinkV7.setTimeoutPeriod(timeoutSeconds.toInt() * 1000)
            smartLinkV7.setOnSmartLinkListener(object : OnSmartLinkListener {
                override fun onLinked(p0: SmartLinkedModule?) {
                    p0?.let {
                        KMMLogger.d("SmartLink 成功 : ${it.mac} : ${it.ip}")
                        KAsync.main {
                            successCallback.invoke(it.mac, it.ip)
                        }
                    }
                }

                override fun onCompleted() {
                    stopSmartLink()
                    KMMLogger.d("SmartLink 完成")
                    KAsync.main {
                        finishCallback.invoke()
                    }
                }

                override fun onTimeOut() {
                    stopSmartLink()
                    KMMLogger.d("SmartLink 超时")
                    KAsync.main {
                        failureCallback.invoke("SmartLink Timeout! Please try again!")
                    }
                }
            })

            smartLinkV7.start(kmmContext, pwd, ssid)
        }

        private fun stopSmartLink() {
            MulticastSmartLinker.getInstance().stop()
            MulticastSmartLinker.getInstance().closeDestroySmartConfigSocket()
        }
    }
}