package com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator

import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeClassify
import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeSet
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.*
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.*
import kotlin.jvm.JvmStatic

@OptIn(ExperimentalSerializationApi::class)
internal class AdditionsAndDeletionsCmdCreator {
    companion object {
        @Serializable
        data class DeviceScanPara(
            val sn: String,
            val seq: Int,
            val factoryID: Int,
            val cmd: String,
        )

        //开始搜索从设备
        @JvmStatic
        fun startDeviceScan(
            sn: String,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val para = DeviceScanPara(
                sn,
                seq,
                factoryID.raw,
                Cmd.RfScan.raw,
            )
            val cmdRaw = Json.encodeToString(para)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }

        //停止搜索从设备
        @JvmStatic
        fun stopDeviceScan(
            sn: String,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val para = DeviceScanPara(
                sn,
                seq,
                factoryID.raw,
                Cmd.RfCancel.raw,
            )
            val cmdRaw = Json.encodeToString(para)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }

        @JvmStatic
        fun deleteDevice(
            sn: String,
            deviceTypeSet: DeviceTypeSet,
            deviceIndex: Int,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val jsonObject = buildJsonObject {
                put(ProtocolKey.Sn.raw, sn)
                put(ProtocolKey.Seq.raw, seq)
                put(ProtocolKey.FactoryID.raw, factoryID.raw)
                if (DeviceTypeClassify.isInputDetectDevice(deviceTypeSet)) {
                    put(ProtocolKey.Cmd.raw, Cmd.DelInputDevice.raw)
                    put(ProtocolKey.InputDeviceIndex.raw, deviceIndex)
                } else {
                    put(ProtocolKey.Cmd.raw, Cmd.RfDel.raw)
                    putJsonArray(deviceTypeSet.raw) {
                        add(deviceIndex)
                    }
                }
            }

            val cmdRaw = Json.encodeToString(jsonObject)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }

        @Serializable
        data class AddRF433DevicePara(
            val sn: String,
            val seq: Int,
            val factoryID: Int,
            val cmd: String,
            val slaveType: String,
        )

        @JvmStatic
        fun addRF433Device(
            sn: String,
            deviceTypeSet: DeviceTypeSet,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val para = AddRF433DevicePara(
                sn,
                seq,
                factoryID.raw,
                Cmd.RfSend.raw,
                deviceTypeSet.raw
            )
            val cmdRaw = Json.encodeToString(para)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }
    }
}