/*
 * Decompiled with CFR 0.152.
 */
package cn.bluedog233.commandscript.command;

import cn.bluedog233.commandscript.Command;
import cn.bluedog233.commandscript.Context;
import cn.bluedog233.commandscript.Listener;
import cn.bluedog233.commandscript.common.Result;
import java.util.ArrayList;
import java.util.List;

public class CustomCommand
extends Command {
    private List<Command> commands = new ArrayList<Command>();
    private static List<Listener> listeners = new ArrayList<Listener>();
    private String shortName;

    public static void addListener(Listener listener) {
        listeners.add(listener);
    }

    public CustomCommand(String shortName) {
        this.shortName = shortName;
    }

    public void addCommand(Command command) {
        this.commands.add(command);
    }

    @Override
    public Result func(Context context) {
        return Result.success();
    }

    @Override
    public Result execute(Context context) {
        int index = 0;
        for (Command command : this.commands) {
            Result result = command.execute(context);
            context.putHistory(index, result);
        }
        for (Listener listener : listeners) {
            listener.handle(context, this);
        }
        return Result.success();
    }

    public String getShortName() {
        return this.shortName;
    }
}

