/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.test.assertion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.caijiang.common.test.assertion.BusinessResult;
import io.github.caijiang.common.test.assertion.ToBusinessResult;
import io.github.caijiang.common.test.assertion.rest.RestResourceCollection;
import io.github.caijiang.common.test.assertion.rest.RestResourceCollectionAssert;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.AbstractAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0000J\u0006\u0010\u0014\u001a\u00020\u0000J\u0006\u0010\u0015\u001a\u00020\u0000J\u0006\u0010\u0016\u001a\u00020\u0000J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\u0006\b\u0000\u0010\u001a\u0018\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u001bJ!\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001d\u00a2\u0006\u0002\u0010\u001eJ)\u0010\u001f\u001a\u0004\u0018\u0001H\u001a\"\u0004\b\u0000\u0010\u001a2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u0001H\u001a0!\u00a2\u0006\u0002\u0010\"J+\u0010#\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\u0018\u0010 \u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u0002H\u001a0!\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/github/caijiang/common/test/assertion/ResponseContentAssert;", "Lorg/assertj/core/api/AbstractAssert;", "Lorg/springframework/http/ResponseEntity;", "", "actual", "business", "Lio/github/caijiang/common/test/assertion/ToBusinessResult;", "(Lorg/springframework/http/ResponseEntity;Lio/github/caijiang/common/test/assertion/ToBusinessResult;)V", "businessResult", "Lio/github/caijiang/common/test/assertion/BusinessResult;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "asSpringRestCollection", "Lio/github/caijiang/common/test/assertion/rest/RestResourceCollectionAssert;", "isErrorCodeMatch", "code", "isFailedResponse", "isLegalResponse", "isSuccessResponse", "print", "readAsJson", "", "readData", "T", "()Ljava/lang/Object;", "javaClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "readFromData", "reader", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readFromEntity", "common-ext"})
public final class ResponseContentAssert
extends AbstractAssert<ResponseContentAssert, ResponseEntity<String>> {
    @NotNull
    private final ToBusinessResult business;
    private final Logger log;
    @NotNull
    private final ObjectMapper objectMapper;
    @Nullable
    private BusinessResult businessResult;

    public ResponseContentAssert(@NotNull ResponseEntity<String> actual, @NotNull ToBusinessResult business) {
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)business, (String)"business");
        super(actual, ResponseContentAssert.class);
        this.business = business;
        this.log = LoggerFactory.getLogger(ResponseContentAssert.class);
        this.objectMapper = new ObjectMapper();
    }

    @NotNull
    public final ResponseContentAssert isLegalResponse() {
        this.readAsJson();
        return this;
    }

    @NotNull
    public final ResponseContentAssert isFailedResponse() {
        this.isLegalResponse();
        if (this.businessResult != null) {
            BusinessResult businessResult = this.businessResult;
            Intrinsics.checkNotNull((Object)businessResult);
            if (businessResult.getSuccess()) {
                Object[] objectArray = new Object[1];
                BusinessResult businessResult2 = this.businessResult;
                objectArray[0] = businessResult2 != null ? businessResult2.getErrorMessage() : null;
                this.failWithMessage("\u54cd\u5e94\u5e94\u8be5\u4e0d\u662f200\uff0c\u4f46\u5b9e\u9645\u4e0a\u662f, \u76f8\u5173\u6d88\u606f:%s", objectArray);
            }
        }
        return this;
    }

    @NotNull
    public final ResponseContentAssert isSuccessResponse() {
        this.isLegalResponse();
        if (this.businessResult != null) {
            BusinessResult businessResult = this.businessResult;
            Intrinsics.checkNotNull((Object)businessResult);
            if (!businessResult.getSuccess()) {
                Object[] objectArray = new Object[2];
                BusinessResult businessResult2 = this.businessResult;
                objectArray[0] = businessResult2 != null ? businessResult2.getErrorCode() : null;
                BusinessResult businessResult3 = this.businessResult;
                objectArray[1] = businessResult3 != null ? businessResult3.getErrorMessage() : null;
                this.failWithMessage("\u54cd\u5e94\u4e0d\u662f200\uff0c\u800c\u662f%s, \u76f8\u5173\u6d88\u606f:%s", objectArray);
            }
        }
        return this;
    }

    @NotNull
    public final ResponseContentAssert isErrorCodeMatch(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.isLegalResponse();
        if (this.businessResult != null) {
            BusinessResult businessResult = this.businessResult;
            Intrinsics.checkNotNull((Object)businessResult);
            if (!Intrinsics.areEqual((Object)businessResult.getErrorCode(), (Object)code)) {
                StringBuilder stringBuilder = new StringBuilder().append("\u54cd\u5e94 Code \u671f\u671b: ").append(code).append(", \u5b9e\u9645: ");
                BusinessResult businessResult2 = this.businessResult;
                Intrinsics.checkNotNull((Object)businessResult2);
                this.failWithMessage(stringBuilder.append(businessResult2.getErrorCode()).toString(), new Object[0]);
            }
        }
        return this;
    }

    @NotNull
    public final ResponseContentAssert print() {
        block0: {
            this.isLegalResponse();
            BusinessResult businessResult = this.businessResult;
            if (businessResult == null) break block0;
            BusinessResult it = businessResult;
            boolean bl = false;
            System.out.println((Object)("success:" + it.getSuccess()));
            System.out.println((Object)("body:" + it.getBody()));
            System.out.println((Object)("errorCode:" + it.getErrorCode()));
            System.out.println((Object)("errorMessage:" + it.getErrorMessage()));
        }
        return this;
    }

    @NotNull
    public final RestResourceCollectionAssert asSpringRestCollection() {
        this.isSuccessResponse();
        if (this.businessResult != null) {
            BusinessResult businessResult = this.businessResult;
            Intrinsics.checkNotNull((Object)businessResult);
            JsonNode jsonNode = businessResult.getBody();
            Intrinsics.checkNotNull((Object)jsonNode);
            JsonNode jsonNode2 = jsonNode.get("_embedded");
            Intrinsics.checkNotNull((Object)jsonNode2, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            ObjectNode objectNode = (ObjectNode)jsonNode2;
            BusinessResult businessResult2 = this.businessResult;
            Intrinsics.checkNotNull((Object)businessResult2);
            JsonNode jsonNode3 = businessResult2.getBody();
            Intrinsics.checkNotNull((Object)jsonNode3);
            JsonNode jsonNode4 = jsonNode3.get("_links");
            Intrinsics.checkNotNull((Object)jsonNode4, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            ObjectNode objectNode2 = (ObjectNode)jsonNode4;
            BusinessResult businessResult3 = this.businessResult;
            Intrinsics.checkNotNull((Object)businessResult3);
            JsonNode jsonNode5 = businessResult3.getBody();
            return new RestResourceCollectionAssert(new RestResourceCollection(objectNode, objectNode2, (ObjectNode)(jsonNode5 != null ? jsonNode5.get("page") : null)));
        }
        return new RestResourceCollectionAssert(null);
    }

    @Nullable
    public final <T> T readData(@NotNull Class<T> javaClass) {
        Intrinsics.checkNotNullParameter(javaClass, (String)"javaClass");
        this.isSuccessResponse();
        if (this.businessResult != null) {
            ObjectReader reader = this.objectMapper.readerFor(javaClass);
            BusinessResult businessResult = this.businessResult;
            Intrinsics.checkNotNull((Object)businessResult);
            return (T)reader.readValue(businessResult.getBody());
        }
        return null;
    }

    public final /* synthetic */ <T> T readData() {
        boolean $i$f$readData = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)this.readData(Object.class);
    }

    @Nullable
    public final <T> T readFromData(@NotNull Function1<? super BusinessResult, ? extends T> reader) {
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        this.isSuccessResponse();
        if (this.businessResult == null) {
            return null;
        }
        BusinessResult businessResult = this.businessResult;
        Intrinsics.checkNotNull((Object)businessResult);
        return (T)reader.invoke((Object)businessResult);
    }

    public final <T> T readFromEntity(@NotNull Function1<? super ResponseEntity<String>, ? extends T> reader) {
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        Object object = this.actual;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"actual");
        return (T)reader.invoke(object);
    }

    private final void readAsJson() {
        if (this.businessResult != null) {
            return;
        }
        try {
            Object object = this.actual;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"actual");
            this.businessResult = this.business.call((ResponseEntity<String>)((ResponseEntity)object));
        }
        catch (Exception e) {
            this.log.warn("failed", (Throwable)e);
            Object[] objectArray = new Object[]{this.actual};
            this.failWithMessage("\u671f\u671b\u662f\u4e00\u4e2a\u5408\u6cd5\u7684json object\uff0c\u5b9e\u9645\u786e\u5b9e:%s", objectArray);
        }
    }
}

