/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.jdbc;

import io.github.caijiang.common.jdbc.JdbcUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000e0\rH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/caijiang/common/jdbc/JdbcUtils;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mysqlCollate", "", "template", "Lorg/springframework/jdbc/core/JdbcTemplate;", "collateName", "", "tables", "", "", "MysqlColumnDefine", "common-ext"})
@SourceDebugExtension(value={"SMAP\nJdbcUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcUtils.kt\nio/github/caijiang/common/jdbc/JdbcUtils\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n215#2:75\n216#2:89\n766#3:76\n857#3:77\n1747#3,3:78\n858#3:81\n766#3:82\n857#3,2:83\n1549#3:85\n1620#3,3:86\n*S KotlinDebug\n*F\n+ 1 JdbcUtils.kt\nio/github/caijiang/common/jdbc/JdbcUtils\n*L\n35#1:75\n35#1:89\n57#1:76\n57#1:77\n58#1:78,3\n57#1:81\n59#1:82\n59#1:83,2\n61#1:85\n61#1:86,3\n*E\n"})
public final class JdbcUtils {
    @NotNull
    public static final JdbcUtils INSTANCE = new JdbcUtils();
    private static final Logger log = LoggerFactory.getLogger(JdbcUtils.class);

    private JdbcUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void mysqlCollate(@NotNull JdbcTemplate template, @NotNull String collateName, @NotNull Map<String, ? extends Set<String>> tables) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)collateName, (String)"collateName");
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        Object object = template.execute(JdbcUtils::mysqlCollate$lambda$0);
        Intrinsics.checkNotNull((Object)object);
        if (((Boolean)object).booleanValue()) {
            Map<String, ? extends Set<String>> $this$forEach$iv = tables;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, ? extends Set<String>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Pair it;
                Iterable $this$filterTo$iv$iv;
                Map.Entry<String, ? extends Set<String>> element$iv;
                Map.Entry<String, ? extends Set<String>> entry = element$iv = iterator.next();
                boolean bl = false;
                String t = entry.getKey();
                Set<String> u = entry.getValue();
                List cs = template.query("show full columns from " + t, JdbcUtils::mysqlCollate$lambda$6$lambda$1);
                Intrinsics.checkNotNull((Object)cs);
                Iterable $this$filter$iv = cs;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl2;
                    block8: {
                        Pair p = (Pair)element$iv$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv = u;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                String it2 = (String)element$iv2;
                                boolean bl4 = false;
                                if (!StringsKt.equals((String)it2, (String)((String)p.getFirst()), (boolean)true)) continue;
                                bl2 = true;
                                break block8;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Pair)element$iv$iv;
                    boolean bl5 = false;
                    if (!(!StringsKt.equals((String)collateName, (String)((MysqlColumnDefine)it.getSecond()).getCollate(), (boolean)true))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl6 = false;
                    collection.add(MysqlColumnDefine.copy$default((MysqlColumnDefine)it.getSecond(), null, null, false, null, null, collateName, 31, null));
                }
                List toChange = (List)destination$iv$iv;
                if (!(!((Collection)toChange).isEmpty())) continue;
                String sql2 = "alter table " + t + ' ' + CollectionsKt.joinToString$default((Iterable)toChange, (CharSequence)",", null, null, (int)0, null, (Function1)mysqlCollate.2.sql.1.INSTANCE, (int)30, null);
                log.info("prepare to execute sql: " + sql2);
                template.update(sql2);
            }
        }
    }

    private static final Boolean mysqlCollate$lambda$0(Connection con) {
        return StringsKt.equals((String)con.getMetaData().getDatabaseProductName(), (String)"mysql", (boolean)true);
    }

    private static final Pair mysqlCollate$lambda$6$lambda$1(ResultSet rs, int n) {
        Object d = rs.getObject("Default");
        String name = rs.getString("Field");
        Intrinsics.checkNotNull((Object)name);
        String string = rs.getString("Type");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        Object object = d;
        return TuplesKt.to((Object)name, (Object)new MysqlColumnDefine(name, string, !StringsKt.equals((String)"no", (String)rs.getString("Null"), (boolean)false), object == null ? null : (object instanceof String ? "" + '\'' + d + '\'' : null), rs.getString("Comment"), rs.getString("Collation")));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JK\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\b\u0010\u001e\u001a\u00020\u0003H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001f"}, d2={"Lio/github/caijiang/common/jdbc/JdbcUtils$MysqlColumnDefine;", "", "name", "", "type", "nullable", "", "defaultToString", "comment", "collate", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCollate", "()Ljava/lang/String;", "getComment", "getDefaultToString", "getName", "getNullable", "()Z", "getType", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "common-ext"})
    private static final class MysqlColumnDefine {
        @NotNull
        private final String name;
        @NotNull
        private final String type;
        private final boolean nullable;
        @Nullable
        private final String defaultToString;
        @Nullable
        private final String comment;
        @Nullable
        private final String collate;

        public MysqlColumnDefine(@NotNull String name, @NotNull String type, boolean nullable, @Nullable String defaultToString, @Nullable String comment, @Nullable String collate) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.name = name;
            this.type = type;
            this.nullable = nullable;
            this.defaultToString = defaultToString;
            this.comment = comment;
            this.collate = collate;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final boolean getNullable() {
            return this.nullable;
        }

        @Nullable
        public final String getDefaultToString() {
            return this.defaultToString;
        }

        @Nullable
        public final String getComment() {
            return this.comment;
        }

        @Nullable
        public final String getCollate() {
            return this.collate;
        }

        @NotNull
        public String toString() {
            String ns = this.nullable ? "not null" : "null";
            String ds = this.defaultToString == null ? "" : "default " + this.defaultToString;
            String cs = this.comment == null ? "" : "comment '" + this.comment + '\'';
            String ca = this.collate == null ? "" : "COLLATE " + this.collate;
            return this.name + ' ' + this.type + ' ' + ns + ' ' + ds + ' ' + cs + ' ' + ca;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        public final boolean component3() {
            return this.nullable;
        }

        @Nullable
        public final String component4() {
            return this.defaultToString;
        }

        @Nullable
        public final String component5() {
            return this.comment;
        }

        @Nullable
        public final String component6() {
            return this.collate;
        }

        @NotNull
        public final MysqlColumnDefine copy(@NotNull String name, @NotNull String type, boolean nullable, @Nullable String defaultToString, @Nullable String comment, @Nullable String collate) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new MysqlColumnDefine(name, type, nullable, defaultToString, comment, collate);
        }

        public static /* synthetic */ MysqlColumnDefine copy$default(MysqlColumnDefine mysqlColumnDefine, String string, String string2, boolean bl, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = mysqlColumnDefine.name;
            }
            if ((n & 2) != 0) {
                string2 = mysqlColumnDefine.type;
            }
            if ((n & 4) != 0) {
                bl = mysqlColumnDefine.nullable;
            }
            if ((n & 8) != 0) {
                string3 = mysqlColumnDefine.defaultToString;
            }
            if ((n & 0x10) != 0) {
                string4 = mysqlColumnDefine.comment;
            }
            if ((n & 0x20) != 0) {
                string5 = mysqlColumnDefine.collate;
            }
            return mysqlColumnDefine.copy(string, string2, bl, string3, string4, string5);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + Boolean.hashCode(this.nullable);
            result = result * 31 + (this.defaultToString == null ? 0 : this.defaultToString.hashCode());
            result = result * 31 + (this.comment == null ? 0 : this.comment.hashCode());
            result = result * 31 + (this.collate == null ? 0 : this.collate.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MysqlColumnDefine)) {
                return false;
            }
            MysqlColumnDefine mysqlColumnDefine = (MysqlColumnDefine)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)mysqlColumnDefine.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)mysqlColumnDefine.type)) {
                return false;
            }
            if (this.nullable != mysqlColumnDefine.nullable) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.defaultToString, (Object)mysqlColumnDefine.defaultToString)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.comment, (Object)mysqlColumnDefine.comment)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.collate, (Object)mysqlColumnDefine.collate);
        }
    }
}

