/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.mysql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\rH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/caijiang/common/mysql/MysqlCharsetCorrect;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "charsetCorrect", "", "", "template", "Lorg/springframework/jdbc/core/JdbcTemplate;", "tableName", "columns", "", "charset", "collation", "mysqlTextCharsetCorrect", "", "target", "Lio/github/caijiang/common/mysql/MysqlCharsetCorrect$TextColumnCharset;", "FieldDefine", "TextColumnCharset", "common-ext"})
@SourceDebugExtension(value={"SMAP\nMysqlCharsetCorrect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlCharsetCorrect.kt\nio/github/caijiang/common/mysql/MysqlCharsetCorrect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,136:1\n1549#2:137\n1620#2,3:138\n1271#2,2:141\n1285#2,4:143\n1360#2:147\n1446#2,5:148\n766#2:155\n857#2:156\n1747#2,3:157\n858#2:160\n766#2:161\n857#2,2:162\n1549#2:164\n1620#2,3:165\n37#3,2:153\n*S KotlinDebug\n*F\n+ 1 MysqlCharsetCorrect.kt\nio/github/caijiang/common/mysql/MysqlCharsetCorrect\n*L\n31#1:137\n31#1:138,3\n32#1:141,2\n32#1:143,4\n54#1:147\n54#1:148,5\n111#1:155\n111#1:156\n112#1:157,3\n111#1:160\n114#1:161\n114#1:162,2\n117#1:164\n117#1:165,3\n69#1:153,2\n*E\n"})
public final class MysqlCharsetCorrect {
    @NotNull
    public static final MysqlCharsetCorrect INSTANCE = new MysqlCharsetCorrect();
    private static final Logger log = LoggerFactory.getLogger(MysqlCharsetCorrect.class);

    private MysqlCharsetCorrect() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void mysqlTextCharsetCorrect(@NotNull JdbcTemplate template, @NotNull Collection<TextColumnCharset> target) {
        void $this$flatMapTo$iv$iv;
        String it;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter(target, (String)"target");
        log.debug("\u51c6\u5907\u7ea0\u6b63 mysql \u6587\u672c\u5b57\u6bb5\u7684 charset...");
        Iterable $this$map$iv = target;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TextColumnCharset textColumnCharset = (TextColumnCharset)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((TextColumnCharset)((Object)it)).getCharset());
        }
        Iterable $this$associateWith$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (String)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            String sql2 = "SHOW CHARACTER SET like ?";
            Object[] objectArray = new Object[]{it};
            String string = (String)template.query(sql2, arg_0 -> MysqlCharsetCorrect.mysqlTextCharsetCorrect$lambda$2$lambda$1(sql2, it, arg_0), objectArray);
            object.put(t, string);
        }
        Map collations = result$iv;
        String[] $this$flatMap$iv = (String[])target;
        boolean $i$f$flatMap = false;
        $this$associateWithTo$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TextColumnCharset it2 = (TextColumnCharset)element$iv$iv;
            boolean bl = false;
            String string = it2.getTableName();
            Collection<String> collection = it2.getColumns();
            String string2 = it2.getCharset();
            Object v = collations.get(it2.getCharset());
            Intrinsics.checkNotNull(v);
            Iterable list$iv$iv = INSTANCE.charsetCorrect(template, string, collection, string2, (String)v);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List sql3 = (List)destination$iv$iv2;
        log.debug("\u9700\u8981\u6267\u884c{}\u6761 sql", (Object)sql3.size());
        if (!((Collection)sql3).isEmpty()) {
            log.info("\u51c6\u5907\u6279\u91cf\u6267\u884c{}", (Object)sql3.size());
            try {
                Collection $this$toTypedArray$iv = sql3;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$flatMap$iv = thisCollection$iv.toArray(new String[0]);
                template.batchUpdate(Arrays.copyOf($this$flatMap$iv, $this$flatMap$iv.length));
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u5b57\u7b26\u96c6\u5f02\u5e38", (Throwable)e);
                log.info("\u53ef\u4ee5\u8003\u8651\u624b\u52a8\u6267\u884c\u4ee5\u4e0b\u811a\u672c:");
                log.info("###########################");
                for (String s : sql3) {
                    log.info(s);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> charsetCorrect(JdbcTemplate template, String tableName, Collection<String> columns, String charset, String collation) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FieldDefine it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable;
        try {
            iterable = template.query("show full fields from " + tableName, MysqlCharsetCorrect::charsetCorrect$lambda$4);
        }
        catch (DataAccessException e) {
            log.info("\u5904\u7406" + tableName + "\u65f6\uff0c\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u6211\u4eec\u5ffd\u7565\u4e86\u8fd9\u4e2a\u9519\u8bef\u3002", (Throwable)e);
            return CollectionsKt.emptyList();
        }
        List fieldDefines = iterable;
        Intrinsics.checkNotNull((Object)fieldDefines);
        iterable = fieldDefines;
        boolean $i$f$filter = false;
        void var9_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block12: {
                it = (FieldDefine)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = columns;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String x = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.equals((String)x, (String)it.getField(), (boolean)true)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FieldDefine)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.equals((String)collation, (String)it.getCollation(), (boolean)true))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FieldDefine)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            StringBuilder builder = new StringBuilder("alter table `");
            builder.append(tableName);
            builder.append("` modify `").append(it.getField()).append("` ").append(it.getType()).append(" charset ").append(charset);
            if (it.getDefaultValue() != null) {
                builder.append(" default '").append(it.getDefaultValue()).append("'");
            }
            if (it.getNullable()) {
                builder.append(" null");
            } else {
                builder.append(" not null");
            }
            if (StringUtils.hasLength((String)it.getComment())) {
                builder.append(" comment '").append(it.getComment()).append("'");
            }
            collection.add(builder.toString());
        }
        return (List)destination$iv$iv;
    }

    private static final String mysqlTextCharsetCorrect$lambda$2$lambda$1(String $sql, String $it, ResultSet rs) {
        Intrinsics.checkNotNullParameter((Object)$sql, (String)"$sql");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        if (rs.next()) {
            for (int index = 1; index <= rs.getMetaData().getColumnCount(); ++index) {
                String v1 = rs.getMetaData().getColumnName(index);
                String v2 = rs.getMetaData().getColumnLabel(index);
                if ((v1 == null || !StringsKt.contains$default((CharSequence)v1, (CharSequence)"collation", (boolean)false, (int)2, null)) && (v2 == null || !StringsKt.contains$default((CharSequence)v2, (CharSequence)"collation", (boolean)false, (int)2, null))) continue;
                return rs.getString(index);
            }
            throw new IllegalStateException("database has no collation field from " + $sql);
        }
        throw new IllegalStateException("database has no charset like " + $it);
    }

    private static final FieldDefine charsetCorrect$lambda$4(ResultSet rs, int n) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        String string = rs.getString("Field");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string2 = rs.getString("Type");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return new FieldDefine(string, string2, rs.getString("Collation"), rs.getBoolean("Null"), rs.getString("Default"), rs.getString("Comment"));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JK\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001f"}, d2={"Lio/github/caijiang/common/mysql/MysqlCharsetCorrect$FieldDefine;", "", "field", "", "type", "collation", "nullable", "", "defaultValue", "comment", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "getCollation", "()Ljava/lang/String;", "getComment", "getDefaultValue", "getField", "getNullable", "()Z", "getType", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "common-ext"})
    private static final class FieldDefine {
        @NotNull
        private final String field;
        @NotNull
        private final String type;
        @Nullable
        private final String collation;
        private final boolean nullable;
        @Nullable
        private final String defaultValue;
        @Nullable
        private final String comment;

        public FieldDefine(@NotNull String field, @NotNull String type, @Nullable String collation, boolean nullable, @Nullable String defaultValue, @Nullable String comment) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.field = field;
            this.type = type;
            this.collation = collation;
            this.nullable = nullable;
            this.defaultValue = defaultValue;
            this.comment = comment;
        }

        @NotNull
        public final String getField() {
            return this.field;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @Nullable
        public final String getCollation() {
            return this.collation;
        }

        public final boolean getNullable() {
            return this.nullable;
        }

        @Nullable
        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @Nullable
        public final String getComment() {
            return this.comment;
        }

        @NotNull
        public final String component1() {
            return this.field;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @Nullable
        public final String component3() {
            return this.collation;
        }

        public final boolean component4() {
            return this.nullable;
        }

        @Nullable
        public final String component5() {
            return this.defaultValue;
        }

        @Nullable
        public final String component6() {
            return this.comment;
        }

        @NotNull
        public final FieldDefine copy(@NotNull String field, @NotNull String type, @Nullable String collation, boolean nullable, @Nullable String defaultValue, @Nullable String comment) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new FieldDefine(field, type, collation, nullable, defaultValue, comment);
        }

        public static /* synthetic */ FieldDefine copy$default(FieldDefine fieldDefine, String string, String string2, String string3, boolean bl, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = fieldDefine.field;
            }
            if ((n & 2) != 0) {
                string2 = fieldDefine.type;
            }
            if ((n & 4) != 0) {
                string3 = fieldDefine.collation;
            }
            if ((n & 8) != 0) {
                bl = fieldDefine.nullable;
            }
            if ((n & 0x10) != 0) {
                string4 = fieldDefine.defaultValue;
            }
            if ((n & 0x20) != 0) {
                string5 = fieldDefine.comment;
            }
            return fieldDefine.copy(string, string2, string3, bl, string4, string5);
        }

        @NotNull
        public String toString() {
            return "FieldDefine(field=" + this.field + ", type=" + this.type + ", collation=" + this.collation + ", nullable=" + this.nullable + ", defaultValue=" + this.defaultValue + ", comment=" + this.comment + ')';
        }

        public int hashCode() {
            int result = this.field.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + (this.collation == null ? 0 : this.collation.hashCode());
            result = result * 31 + Boolean.hashCode(this.nullable);
            result = result * 31 + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
            result = result * 31 + (this.comment == null ? 0 : this.comment.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FieldDefine)) {
                return false;
            }
            FieldDefine fieldDefine = (FieldDefine)other;
            if (!Intrinsics.areEqual((Object)this.field, (Object)fieldDefine.field)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)fieldDefine.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.collation, (Object)fieldDefine.collation)) {
                return false;
            }
            if (this.nullable != fieldDefine.nullable) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.defaultValue, (Object)fieldDefine.defaultValue)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.comment, (Object)fieldDefine.comment);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J-\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lio/github/caijiang/common/mysql/MysqlCharsetCorrect$TextColumnCharset;", "", "tableName", "", "columns", "", "charset", "(Ljava/lang/String;Ljava/util/Collection;Ljava/lang/String;)V", "getCharset", "()Ljava/lang/String;", "getColumns", "()Ljava/util/Collection;", "getTableName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "common-ext"})
    public static final class TextColumnCharset {
        @NotNull
        private final String tableName;
        @NotNull
        private final Collection<String> columns;
        @NotNull
        private final String charset;

        public TextColumnCharset(@NotNull String tableName, @NotNull Collection<String> columns, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            this.tableName = tableName;
            this.columns = columns;
            this.charset = charset;
        }

        @NotNull
        public final String getTableName() {
            return this.tableName;
        }

        @NotNull
        public final Collection<String> getColumns() {
            return this.columns;
        }

        @NotNull
        public final String getCharset() {
            return this.charset;
        }

        @NotNull
        public final String component1() {
            return this.tableName;
        }

        @NotNull
        public final Collection<String> component2() {
            return this.columns;
        }

        @NotNull
        public final String component3() {
            return this.charset;
        }

        @NotNull
        public final TextColumnCharset copy(@NotNull String tableName, @NotNull Collection<String> columns, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return new TextColumnCharset(tableName, columns, charset);
        }

        public static /* synthetic */ TextColumnCharset copy$default(TextColumnCharset textColumnCharset, String string, Collection collection, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = textColumnCharset.tableName;
            }
            if ((n & 2) != 0) {
                collection = textColumnCharset.columns;
            }
            if ((n & 4) != 0) {
                string2 = textColumnCharset.charset;
            }
            return textColumnCharset.copy(string, collection, string2);
        }

        @NotNull
        public String toString() {
            return "TextColumnCharset(tableName=" + this.tableName + ", columns=" + this.columns + ", charset=" + this.charset + ')';
        }

        public int hashCode() {
            int result = this.tableName.hashCode();
            result = result * 31 + ((Object)this.columns).hashCode();
            result = result * 31 + this.charset.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextColumnCharset)) {
                return false;
            }
            TextColumnCharset textColumnCharset = (TextColumnCharset)other;
            if (!Intrinsics.areEqual((Object)this.tableName, (Object)textColumnCharset.tableName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.columns, textColumnCharset.columns)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.charset, (Object)textColumnCharset.charset);
        }
    }
}

