/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.wechat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.caijiang.common.http.SimpleHttpResponse;
import io.github.caijiang.common.http.SimpleHttpUtils;
import io.github.caijiang.common.wechat.AppIdAndSecret;
import io.github.caijiang.common.wechat.TokenCacheService;
import io.github.caijiang.common.wechat.WechatHelper;
import io.github.caijiang.common.wechat.data.ExpiredToken;
import io.github.caijiang.common.wechat.data.JavascriptSignature;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/github/caijiang/common/wechat/WechatHelper;", "", "tokenCacheService", "Lio/github/caijiang/common/wechat/TokenCacheService;", "(Lio/github/caijiang/common/wechat/TokenCacheService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "cacheServiceSafe", "", "javascriptSignature", "Lio/github/caijiang/common/wechat/data/JavascriptSignature;", "account", "Lio/github/caijiang/common/wechat/AppIdAndSecret;", "url", "", "queryJavascriptApiTicket", "Lio/github/caijiang/common/wechat/data/ExpiredToken;", "queryStableAccessToken", "readWechatResponse", "Lcom/fasterxml/jackson/databind/JsonNode;", "response", "Lio/github/caijiang/common/http/SimpleHttpResponse;", "common-ext"})
@SourceDebugExtension(value={"SMAP\nWechatHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WechatHelper.kt\nio/github/caijiang/common/wechat/WechatHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1045#2:139\n*S KotlinDebug\n*F\n+ 1 WechatHelper.kt\nio/github/caijiang/common/wechat/WechatHelper\n*L\n103#1:139\n*E\n"})
public final class WechatHelper {
    @Nullable
    private final TokenCacheService tokenCacheService;
    private final Logger log;
    @NotNull
    private final ObjectMapper objectMapper;

    public WechatHelper(@Nullable TokenCacheService tokenCacheService) {
        this.tokenCacheService = tokenCacheService;
        this.log = LoggerFactory.getLogger(WechatHelper.class);
        this.objectMapper = new ObjectMapper();
    }

    @NotNull
    public final ExpiredToken queryStableAccessToken(@NotNull AppIdAndSecret account) {
        ExpiredToken newToken;
        block1: {
            ExpiredToken token;
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            this.cacheServiceSafe();
            TokenCacheService tokenCacheService = this.tokenCacheService;
            ExpiredToken expiredToken = token = tokenCacheService != null ? tokenCacheService.accessTokenCache(account.getAppId()) : null;
            if (token != null) {
                return token;
            }
            Instant requestInstant = Instant.now();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"grant_type", (Object)"client_credential"), TuplesKt.to((Object)"appid", (Object)account.getAppId()), TuplesKt.to((Object)"secret", (Object)account.getSecret()), TuplesKt.to((Object)"force_refresh", (Object)false)};
            SimpleHttpResponse response = SimpleHttpUtils.httpAccess("https://api.weixin.qq.com/cgi-bin/stable_token", "POST", MapsKt.mapOf((Pair)TuplesKt.to((Object)"content-type", (Object)"application/json; encoding=utf-8")), this.objectMapper.writeValueAsBytes((Object)MapsKt.mapOf((Pair[])pairArray)));
            JsonNode root = this.readWechatResponse(response);
            String string = root.get("access_token").textValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textValue(...)");
            Instant instant = requestInstant.plusSeconds(root.get("expires_in").asLong());
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plusSeconds(...)");
            newToken = new ExpiredToken(string, instant);
            TokenCacheService tokenCacheService2 = this.tokenCacheService;
            if (tokenCacheService2 == null) break block1;
            tokenCacheService2.updateAccessToken(account.getAppId(), newToken);
        }
        return newToken;
    }

    private final ExpiredToken queryJavascriptApiTicket(AppIdAndSecret account) {
        ExpiredToken jt;
        block1: {
            ExpiredToken tokenn;
            this.cacheServiceSafe();
            TokenCacheService tokenCacheService = this.tokenCacheService;
            ExpiredToken expiredToken = tokenn = tokenCacheService != null ? tokenCacheService.javascriptApiTicketCache(account.getAppId()) : null;
            if (tokenn != null) {
                return tokenn;
            }
            ExpiredToken access = this.queryStableAccessToken(account);
            Instant requestInstant = Instant.now();
            SimpleHttpResponse response = SimpleHttpUtils.httpAccess$default("https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=" + access.getToken() + "&type=jsapi", null, null, null, 14, null);
            JsonNode root = this.readWechatResponse(response);
            String string = root.get("ticket").textValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textValue(...)");
            Instant instant = requestInstant.plusSeconds(root.get("expires_in").asLong());
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plusSeconds(...)");
            jt = new ExpiredToken(string, instant);
            TokenCacheService tokenCacheService2 = this.tokenCacheService;
            if (tokenCacheService2 == null) break block1;
            tokenCacheService2.updateJavascriptApiTicket(account.getAppId(), jt);
        }
        return jt;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JavascriptSignature javascriptSignature(@NotNull AppIdAndSecret account, @NotNull String url) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.cacheServiceSafe();
        ExpiredToken jt = this.queryJavascriptApiTicket(account);
        String noncestr = RandomStringUtils.randomAlphabetic((int)12);
        long timestamp = System.currentTimeMillis() / (long)1000;
        Object object = new Pair[]{TuplesKt.to((Object)"noncestr", (Object)noncestr), TuplesKt.to((Object)"jsapi_ticket", (Object)jt.getToken()), TuplesKt.to((Object)"timestamp", (Object)String.valueOf(timestamp)), TuplesKt.to((Object)"url", (Object)url)};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$sortedBy = false;
        String str12 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getFirst()))));
            }
        }), (CharSequence)"&", null, null, (int)0, null, (Function1)javascriptSignature.str1.2.INSTANCE, (int)30, null);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        String string = str12;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] result = messageDigest.digest(byArray);
        this.log.debug("ticket:{}", (Object)jt.getToken());
        this.log.debug("str1:{}", (Object)str12);
        String string2 = account.getAppId();
        Intrinsics.checkNotNull((Object)noncestr);
        String string3 = Hex.encodeHexString((byte[])result, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encodeHexString(...)");
        return new JavascriptSignature(string2, timestamp, noncestr, string3);
    }

    private final void cacheServiceSafe() {
        if (this.tokenCacheService == null) {
            this.log.warn("\u6309\u7167\u5fae\u4fe1\u5f00\u53d1\u6307\u5f15\uff0c\u5f00\u53d1\u8005\u6709\u4e49\u52a1\u7f13\u5b58\u83b7\u53d6\u5230\u7684 token.");
        }
    }

    private final JsonNode readWechatResponse(SimpleHttpResponse response) {
        if (response.getStatus() != 200) {
            throw new IllegalStateException("wechat response " + response.getStatus());
        }
        JsonNode root = this.objectMapper.readTree(response.getBody());
        JsonNode errcode = root.get("errcode");
        if (errcode != null && !errcode.isNull()) {
            if (errcode.isNumber() && errcode.intValue() == 0) {
                Intrinsics.checkNotNull((Object)root);
                return root;
            }
            throw new IllegalStateException("wechat response " + root);
        }
        Intrinsics.checkNotNull((Object)root);
        return root;
    }
}

