/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.aliyun;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.sdk.service.alb20200616.AsyncClient;
import com.aliyun.sdk.service.alb20200616.DefaultAsyncClientBuilder;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import darabonba.core.client.ClientOverrideConfiguration;
import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.aliyun.ResourceLocator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\b\u00a8\u0006\u0013"}, d2={"Lio/github/caijiang/common/aliyun/Helper;", "", "()V", "commonDefaultAcsClientFrom", "Lcom/aliyuncs/DefaultAcsClient;", "locator", "Lio/github/caijiang/common/aliyun/ResourceLocator;", "commonEssRequest", "Lcom/aliyuncs/CommonRequest;", "commonProfileFrom", "Lcom/aliyuncs/profile/IClientProfile;", "createClientForProduct", "Lcom/aliyun/sdk/service/alb20200616/AsyncClient;", "productCode", "", "credentialsProvider", "Lcom/aliyun/auth/credentials/provider/ICredentialProvider;", "executeCommonRequest", "request", "common-ext"})
@SourceDebugExtension(value={"SMAP\nHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Helper.kt\nio/github/caijiang/common/aliyun/Helper\n+ 2 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n*L\n1#1,79:1\n16#2:80\n16#2:81\n*S KotlinDebug\n*F\n+ 1 Helper.kt\nio/github/caijiang/common/aliyun/Helper\n*L\n71#1:80\n74#1:81\n*E\n"})
public final class Helper {
    @NotNull
    public static final Helper INSTANCE = new Helper();

    private Helper() {
    }

    private final IClientProfile commonProfileFrom(ResourceLocator locator) {
        DefaultProfile defaultProfile = DefaultProfile.getProfile((String)locator.getRegion(), (String)locator.getAccessKeyId(), (String)locator.getAccessKeySecret());
        Intrinsics.checkNotNullExpressionValue((Object)defaultProfile, (String)"getProfile(...)");
        return (IClientProfile)defaultProfile;
    }

    @NotNull
    public final DefaultAcsClient commonDefaultAcsClientFrom(@NotNull ResourceLocator locator) {
        Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
        return new DefaultAcsClient(this.commonProfileFrom(locator));
    }

    private final ICredentialProvider credentialsProvider(ResourceLocator locator) {
        StaticCredentialProvider staticCredentialProvider = StaticCredentialProvider.create((Credential)Credential.builder().accessKeyId(locator.getAccessKeyId()).accessKeySecret(locator.getAccessKeySecret()).build());
        Intrinsics.checkNotNullExpressionValue((Object)staticCredentialProvider, (String)"create(...)");
        return (ICredentialProvider)staticCredentialProvider;
    }

    @NotNull
    public final CommonRequest commonEssRequest() {
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain("ess.aliyuncs.com");
        request.setSysVersion("2014-08-28");
        return request;
    }

    @NotNull
    public final AsyncClient createClientForProduct(@NotNull String productCode, @NotNull ResourceLocator locator) {
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
        boolean vpc = Intrinsics.areEqual((Object)"1", (Object)System.getenv("VPC"));
        String ep = productCode + (vpc ? "-vpc" : "") + '.' + locator.getRegion() + ".aliyuncs.com";
        Object object = ((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)AsyncClient.builder().region(locator.getRegion())).credentialsProvider(this.credentialsProvider(locator))).overrideConfiguration(ClientOverrideConfiguration.create().setEndpointOverride(ep))).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (AsyncClient)object;
    }

    @Nullable
    public final String executeCommonRequest(@NotNull ResourceLocator locator, @NotNull CommonRequest request) {
        Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        DefaultAcsClient client = this.commonDefaultAcsClientFrom(locator);
        CommonResponse response2 = client.getCommonResponse(request);
        Slf4j.Companion companion = Slf4j.Companion;
        Helper $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(Helper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Object this_$iv = new Object[]{request.getSysAction(), request.getSysQueryParameters(), response2.getData()};
        logger.debug("Executed common request: {}:{}:{} ", this_$iv);
        if (!response2.getHttpResponse().isSuccess()) {
            this_$iv = Slf4j.Companion;
            $this$log$iv = this;
            $i$f$getLog = false;
            Logger logger2 = LoggerFactory.getLogger(Helper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
            logger2.debug("response.data:{}", (Object)response2.getData());
            throw new IllegalStateException("Error response code " + response2.getHttpStatus() + ':' + response2.getHttpResponse().getReasonPhrase());
        }
        return response2.getData();
    }
}

