/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.nacos;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.nacos.JsonNodeAsServiceNode;
import io.github.caijiang.common.nacos.OpenApiHelper;
import io.github.caijiang.common.nacos.ResourceLocator;
import io.github.caijiang.common.orchestration.IngressEntrance;
import io.github.caijiang.common.orchestration.Service;
import io.github.caijiang.common.orchestration.ServiceNode;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0003R\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/caijiang/common/nacos/NacosService;", "Lio/github/caijiang/common/orchestration/IngressEntrance;", "serviceName", "", "locator", "Lio/github/caijiang/common/nacos/ResourceLocator;", "waitAfterSuspend", "Ljava/time/Duration;", "(Ljava/lang/String;Lio/github/caijiang/common/nacos/ResourceLocator;Ljava/time/Duration;)V", "ingressName", "getIngressName", "()Ljava/lang/String;", "checkWorkStatus", "", "node", "Lio/github/caijiang/common/orchestration/ServiceNode;", "discoverNodes", "", "service", "Lio/github/caijiang/common/orchestration/Service;", "jsonNodeAsServiceNodes", "Lio/github/caijiang/common/nacos/JsonNodeAsServiceNode;", "resumedNode", "", "serviceNode", "suspendNode", "suspendNodeByIP", "ip", "common-ext"})
@SourceDebugExtension(value={"SMAP\nNacosService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NacosService.kt\nio/github/caijiang/common/nacos/NacosService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n*L\n1#1,71:1\n288#2,2:72\n1549#2:77\n1620#2,3:78\n766#2:81\n857#2,2:82\n1747#2,3:84\n1549#2:87\n1620#2,3:88\n16#3:74\n16#3:75\n16#3:76\n*S KotlinDebug\n*F\n+ 1 NacosService.kt\nio/github/caijiang/common/nacos/NacosService\n*L\n34#1:72,2\n48#1:77\n48#1:78,3\n56#1:81\n56#1:82,2\n60#1:84,3\n66#1:87\n66#1:88,3\n46#1:74\n47#1:75\n48#1:76\n*E\n"})
public final class NacosService
implements IngressEntrance {
    @NotNull
    private final String serviceName;
    @NotNull
    private final ResourceLocator locator;
    @Nullable
    private final Duration waitAfterSuspend;

    public NacosService(@NotNull String serviceName, @NotNull ResourceLocator locator, @Nullable Duration waitAfterSuspend) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
        this.serviceName = serviceName;
        this.locator = locator;
        this.waitAfterSuspend = waitAfterSuspend;
    }

    public /* synthetic */ NacosService(String string, ResourceLocator resourceLocator, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            duration = null;
        }
        this(string, resourceLocator, duration);
    }

    @Override
    @NotNull
    public String getIngressName() {
        return "nacos";
    }

    @Override
    public void suspendNode(@NotNull ServiceNode serviceNode) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)serviceNode, (String)"serviceNode");
            OpenApiHelper.INSTANCE.changeInstance(this.locator, this.serviceName, serviceNode.getIp(), serviceNode.getPort(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"enabled", (Object)false)));
            Duration duration = this.waitAfterSuspend;
            if (duration == null) break block0;
            Duration it = duration;
            boolean bl = false;
            Thread.sleep(it.toMillis());
        }
    }

    public final void suspendNodeByIP(@NotNull String ip) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            List<JsonNodeAsServiceNode> list2 = this.jsonNodeAsServiceNodes();
            if (list2 == null) {
                throw new IllegalStateException("\u65e0\u6cd5\u901a\u8fc7 listInstances \u83b7\u53d6\u5f53\u524d\u5b9e\u4f8b\u5217\u8868\u3002\u505c\u6b62\u6d41\u91cf:" + ip + " \u5931\u8d25");
            }
            List<JsonNodeAsServiceNode> list3 = list2;
            Iterable $this$firstOrNull$iv = list3;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JsonNodeAsServiceNode it = (JsonNodeAsServiceNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getIp(), (Object)ip)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        JsonNodeAsServiceNode jsonNodeAsServiceNode = v1;
        if (jsonNodeAsServiceNode == null) {
            throw new IllegalStateException("\u65e0\u6cd5\u5728 listInstances \u7ed3\u679c\u4e2d\u83b7\u53d6\u7b26\u5408\u8981\u6c42\u7684\u5b9e\u4f8b\u3002\u505c\u6b62\u6d41\u91cf:" + ip + " \u5931\u8d25");
        }
        JsonNodeAsServiceNode target = jsonNodeAsServiceNode;
        this.suspendNode(target);
    }

    @Override
    public void resumedNode(@NotNull ServiceNode serviceNode) {
        Intrinsics.checkNotNullParameter((Object)serviceNode, (String)"serviceNode");
        OpenApiHelper.INSTANCE.changeInstance(this.locator, this.serviceName, serviceNode.getIp(), serviceNode.getPort(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"enabled", (Object)true)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean checkWorkStatus(@NotNull ServiceNode node) {
        boolean bl;
        Iterable destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List<JsonNodeAsServiceNode> list2 = this.jsonNodeAsServiceNodes();
        Slf4j.Companion companion = Slf4j.Companion;
        NacosService $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(NacosService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        if (logger.isTraceEnabled()) {
            List list3;
            Object this_$iv = Slf4j.Companion;
            $this$log$iv = this;
            $i$f$getLog = false;
            Logger logger2 = LoggerFactory.getLogger(NacosService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
            logger2.trace("checkWorkStatus:{}:{}", (Object)node.getIp(), (Object)node.getPort());
            this_$iv = Slf4j.Companion;
            $this$log$iv = this;
            $i$f$getLog = false;
            Logger logger3 = LoggerFactory.getLogger(NacosService.class);
            Logger logger4 = logger3;
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getLogger(...)");
            String string = "fact list:{}";
            List<JsonNodeAsServiceNode> list4 = list2;
            if (list4 != null) {
                Iterable<Map> iterable;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                this_$iv = list4;
                String string2 = string;
                Logger logger5 = logger4;
                boolean $i$f$map = false;
                void $i$f$getLog2 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Iterator item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonNodeAsServiceNode jsonNodeAsServiceNode = (JsonNodeAsServiceNode)((Object)item$iv$iv);
                    iterable = destination$iv$iv;
                    boolean bl2 = false;
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ip", (Object)it.getIp()), TuplesKt.to((Object)"port", (Object)it.getPort()), TuplesKt.to((Object)"work", (Object)it.work())};
                    iterable.add(MapsKt.mapOf((Pair[])pairArray));
                }
                iterable = (List)destination$iv$iv;
                logger4 = logger5;
                string = string2;
                list3 = iterable;
            } else {
                list3 = null;
            }
            logger4.trace(string, list3);
        }
        List<JsonNodeAsServiceNode> list5 = list2;
        if (list5 != null) {
            boolean bl3;
            block10: {
                void $this$any$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = list5;
                boolean $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    JsonNodeAsServiceNode it = (JsonNodeAsServiceNode)element$iv$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getIp(), (Object)node.getIp())) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        JsonNodeAsServiceNode it = (JsonNodeAsServiceNode)element$iv;
                        boolean bl5 = false;
                        if (!it.work()) continue;
                        bl3 = true;
                        break block10;
                    }
                    bl3 = false;
                }
            }
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsonNodeAsServiceNode> jsonNodeAsServiceNodes() {
        List list2;
        ArrayNode arrayNode = OpenApiHelper.INSTANCE.listInstances(this.locator, this.serviceName);
        if (arrayNode != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)arrayNode;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonNode jsonNode = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(new JsonNodeAsServiceNode((JsonNode)it, null, 0, 0.0, false, false, false, false, 254, null));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    @Override
    @NotNull
    public List<ServiceNode> discoverNodes(@NotNull Service service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        return CollectionsKt.emptyList();
    }
}

