/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.nacos;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.http.SimpleHttpResponse;
import io.github.caijiang.common.http.SimpleHttpUtils;
import io.github.caijiang.common.nacos.NacosApiVersion;
import io.github.caijiang.common.nacos.OpenApiHelper;
import io.github.caijiang.common.nacos.OpenApiHelperKt;
import io.github.caijiang.common.nacos.ResourceLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0018\b\u0002\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u000fJ\u0016\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ<\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0018\b\u0002\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\u000fH\u0002J^\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\b\b\u0000\u0010\u0019*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2#\u0010\u001a\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u001e0\u001b2\u0016\b\u0002\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u0002H\u0019\u0018\u00010\u001bH\u0002\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/github/caijiang/common/nacos/OpenApiHelper;", "", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "changeInstance", "", "locator", "Lio/github/caijiang/common/nacos/ResourceLocator;", "serviceName", "", "ip", "port", "", "otherData", "", "describeService", "fetchAccessToken", "listInstances", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "urlFor", "uri", "accessToken", "otherParameter", "work", "T", "request", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lio/github/caijiang/common/http/SimpleHttpResponse;", "business", "Lcom/fasterxml/jackson/databind/JsonNode;", "(Lio/github/caijiang/common/nacos/ResourceLocator;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "common-ext"})
@SourceDebugExtension(value={"SMAP\nOpenApiHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenApiHelper.kt\nio/github/caijiang/common/nacos/OpenApiHelper\n+ 2 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n16#2:213\n16#2:214\n766#3:215\n857#3,2:216\n*S KotlinDebug\n*F\n+ 1 OpenApiHelper.kt\nio/github/caijiang/common/nacos/OpenApiHelper\n*L\n26#1:213\n42#1:214\n130#1:215\n130#1:216,2\n*E\n"})
public final class OpenApiHelper {
    @NotNull
    public static final OpenApiHelper INSTANCE = new OpenApiHelper();
    @NotNull
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private OpenApiHelper() {
    }

    private final <T> T work(ResourceLocator locator, Function1<? super String, SimpleHttpResponse> request, Function1<? super JsonNode, ? extends T> business) {
        String accessToken = this.fetchAccessToken(locator);
        SimpleHttpResponse response2 = (SimpleHttpResponse)request.invoke((Object)accessToken);
        Slf4j.Companion companion = Slf4j.Companion;
        Object $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(OpenApiHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("response : {}", (Object)response2);
        if (response2.getStatus() != 200) {
            StringBuilder stringBuilder = new StringBuilder().append("bad status: ").append(response2.getStatus()).append(':');
            byte[] byArray = response2.getBody();
            if (byArray == null) {
                byArray = new byte[]{};
            }
            byte[] this_$iv = byArray;
            throw new IllegalArgumentException(stringBuilder.append(new String(this_$iv, Charsets.UTF_8)).toString());
        }
        if (locator.getApi() == NacosApiVersion.V1x) {
            if (business == null) {
                return null;
            }
            JsonNode jsonNode = objectMapper.readTree(response2.getBody());
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
            return (T)business.invoke((Object)jsonNode);
        }
        JsonNode root = objectMapper.readTree(response2.getBody());
        if (root.isNull() || !root.isObject()) {
            StringBuilder stringBuilder = new StringBuilder().append("bad response: ");
            byte[] byArray = response2.getBody();
            if (byArray == null) {
                byArray = new byte[]{};
            }
            $this$log$iv = byArray;
            throw new IllegalArgumentException(stringBuilder.append(new String((byte[])$this$log$iv, Charsets.UTF_8)).toString());
        }
        $this$log$iv = Slf4j.Companion;
        OpenApiHelper $this$log$iv2 = this;
        boolean $i$f$getLog22 = false;
        Logger logger2 = LoggerFactory.getLogger(OpenApiHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        logger2.debug("response json: {}", (Object)root);
        JsonNode code = root.get("code");
        JsonNode message = root.get("message");
        if (code.isNull() || !code.isInt()) {
            StringBuilder stringBuilder = new StringBuilder().append("bad code: ");
            byte[] byArray = response2.getBody();
            if (byArray == null) {
                byArray = new byte[]{};
            }
            byte[] $i$f$getLog22 = byArray;
            throw new IllegalArgumentException(stringBuilder.append(new String($i$f$getLog22, Charsets.UTF_8)).toString());
        }
        if (code.intValue() != 0) {
            String string;
            JsonNode jsonNode = message;
            if (jsonNode != null) {
                JsonNode it = jsonNode;
                boolean bl = false;
                string = it.isNull() ? "" : (it.isTextual() ? it.textValue() : "");
            } else {
                string = null;
            }
            String msg = string;
            throw new IllegalArgumentException(code.intValue() + ": " + msg);
        }
        if (business == null) {
            return null;
        }
        JsonNode jsonNode = root.get("data");
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"get(...)");
        return (T)business.invoke((Object)jsonNode);
    }

    static /* synthetic */ Object work$default(OpenApiHelper openApiHelper, ResourceLocator resourceLocator, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 4) != 0) {
            function12 = null;
        }
        return openApiHelper.work(resourceLocator, (Function1<? super String, SimpleHttpResponse>)function1, function12);
    }

    public final void changeInstance(@NotNull ResourceLocator locator, @NotNull String serviceName, @NotNull String ip, int port, @Nullable Map<String, ? extends Object> otherData) {
        Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        String uri = locator.getApi() == NacosApiVersion.V1x ? "/nacos/v1/ns/instance" : "/nacos/v2/ns/instance";
        OpenApiHelper.work$default(this, locator, (Function1)new Function1<String, SimpleHttpResponse>(locator, uri, otherData, ip, serviceName, port){
            final /* synthetic */ ResourceLocator $locator;
            final /* synthetic */ String $uri;
            final /* synthetic */ Map<String, Object> $otherData;
            final /* synthetic */ String $ip;
            final /* synthetic */ String $serviceName;
            final /* synthetic */ int $port;
            {
                this.$locator = $locator;
                this.$uri = $uri;
                this.$otherData = $otherData;
                this.$ip = $ip;
                this.$serviceName = $serviceName;
                this.$port = $port;
                super(1);
            }

            @NotNull
            public final SimpleHttpResponse invoke(@Nullable String s) {
                return SimpleHttpUtils.httpAccess$default(OpenApiHelper.urlFor$default(OpenApiHelper.INSTANCE, this.$locator, this.$uri, s, null, 8, null), "PUT", null, (Function1)new Function1<SimpleHttpUtils.EntityBuilder, Unit>(this.$otherData, this.$ip, this.$serviceName, this.$port, this.$locator){
                    final /* synthetic */ Map<String, Object> $otherData;
                    final /* synthetic */ String $ip;
                    final /* synthetic */ String $serviceName;
                    final /* synthetic */ int $port;
                    final /* synthetic */ ResourceLocator $locator;
                    {
                        this.$otherData = $otherData;
                        this.$ip = $ip;
                        this.$serviceName = $serviceName;
                        this.$port = $port;
                        this.$locator = $locator;
                        super(1);
                    }

                    public final void invoke(@NotNull SimpleHttpUtils.EntityBuilder it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.setContentType("application/x-www-form-urlencoded");
                        Map map = this.$otherData;
                        if (map == null) {
                            map = MapsKt.emptyMap();
                        }
                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ip", (Object)this.$ip), TuplesKt.to((Object)"serviceName", (Object)this.$serviceName), TuplesKt.to((Object)"port", (Object)this.$port), TuplesKt.to((Object)"groupName", (Object)this.$locator.getGroupName()), TuplesKt.to((Object)"clusterName", (Object)this.$locator.getClusterName()), TuplesKt.to((Object)"namespaceId", (Object)this.$locator.getNamespaceId())};
                        Map allData = MapsKt.plus((Map)map, (Map)MapsKt.mapOf((Pair[])pairArray));
                        OpenApiHelperKt.access$setParametersFromMap(it, allData);
                    }
                }, 4, null);
            }
        }, null, 4, null);
    }

    public static /* synthetic */ void changeInstance$default(OpenApiHelper openApiHelper, ResourceLocator resourceLocator, String string, String string2, int n, Map map, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            map = null;
        }
        openApiHelper.changeInstance(resourceLocator, string, string2, n, map);
    }

    @Nullable
    public final ArrayNode listInstances(@NotNull ResourceLocator locator, @NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        String uri = locator.getApi() == NacosApiVersion.V1x ? "/nacos/v1/ns/instance/list" : "/nacos/v2/ns/instance/list";
        return (ArrayNode)this.work(locator, (Function1<? super String, SimpleHttpResponse>)((Function1)new Function1<String, SimpleHttpResponse>(locator, uri, serviceName){
            final /* synthetic */ ResourceLocator $locator;
            final /* synthetic */ String $uri;
            final /* synthetic */ String $serviceName;
            {
                this.$locator = $locator;
                this.$uri = $uri;
                this.$serviceName = $serviceName;
                super(1);
            }

            @NotNull
            public final SimpleHttpResponse invoke(@Nullable String it) {
                return SimpleHttpUtils.httpAccess$default(OpenApiHelper.access$urlFor(OpenApiHelper.INSTANCE, this.$locator, this.$uri, it, MapsKt.mapOf((Pair)TuplesKt.to((Object)"serviceName", (Object)this.$serviceName))), null, null, null, 14, null);
            }
        }), listInstances.2.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final String urlFor(ResourceLocator locator, String uri, String accessToken, Map<String, String> otherParameter) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String url = "http://" + locator.getServerAddr() + uri;
        Map map = otherParameter;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map all = MapsKt.plus((Map)MapsKt.plus((Map)MapsKt.plus((Map)MapsKt.plus((Map)map, (Pair)TuplesKt.to((Object)"accessToken", (Object)accessToken)), (Pair)TuplesKt.to((Object)"namespaceId", (Object)locator.getNamespaceId())), (Pair)TuplesKt.to((Object)"groupName", (Object)locator.getGroupName())), (Pair)TuplesKt.to((Object)"clusterName", (Object)locator.getClusterName()));
        Iterable iterable = all.entrySet();
        boolean $i$f$filter = false;
        void var10_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(it.getValue() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String ps2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, (Function1)urlFor.ps.2.INSTANCE, (int)30, null);
        if (((CharSequence)ps2).length() == 0) {
            return url;
        }
        return url + '?' + ps2;
    }

    static /* synthetic */ String urlFor$default(OpenApiHelper openApiHelper, ResourceLocator resourceLocator, String string, String string2, Map map, int n, Object object) {
        if ((n & 8) != 0) {
            map = null;
        }
        return openApiHelper.urlFor(resourceLocator, string, string2, map);
    }

    private final String fetchAccessToken(ResourceLocator locator) {
        String tokenInPreferences;
        block12: {
            String prefix;
            Preferences preferences;
            block11: {
                boolean tokeInValid;
                if (locator.getAccessToken() != null) {
                    return locator.getAccessToken();
                }
                if (locator.getAuth() == null) {
                    return null;
                }
                preferences = Preferences.userNodeForPackage(OpenApiHelper.class);
                prefix = locator.getServerAddr() + '_' + locator.getAuth().getUsername();
                tokenInPreferences = preferences.get(prefix + "_token", "");
                boolean bl = tokeInValid = System.currentTimeMillis() > preferences.getLong(prefix + "_dead", 0L);
                if (tokeInValid) break block11;
                Intrinsics.checkNotNull((Object)tokenInPreferences);
                if (!(((CharSequence)((Object)StringsKt.trim((CharSequence)tokenInPreferences)).toString()).length() == 0)) break block12;
            }
            long requestTime = System.currentTimeMillis();
            SimpleHttpResponse response2 = SimpleHttpUtils.httpAccess("http://" + locator.getServerAddr() + "/nacos/v1/auth/login", "POST", MapsKt.emptyMap(), (Function1<? super SimpleHttpUtils.EntityBuilder, Unit>)((Function1)new Function1<SimpleHttpUtils.EntityBuilder, Unit>(locator){
                final /* synthetic */ ResourceLocator $locator;
                {
                    this.$locator = $locator;
                    super(1);
                }

                public final void invoke(@NotNull SimpleHttpUtils.EntityBuilder it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.setContentType("application/x-www-form-urlencoded");
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"username", (Object)this.$locator.getAuth().getUsername()), TuplesKt.to((Object)"password", (Object)this.$locator.getAuth().getPassword())};
                    it.setParameters(pairArray);
                }
            }));
            if (response2.getStatus() != 200) {
                StringBuilder stringBuilder = new StringBuilder().append("login failed: ");
                byte[] byArray = response2.getBody();
                if (byArray == null) {
                    byArray = new byte[]{};
                }
                byte[] byArray2 = byArray;
                throw new IllegalArgumentException(stringBuilder.append(new String(byArray2, Charsets.UTF_8)).toString());
            }
            JsonNode root = objectMapper.readTree(response2.getBody());
            if (root.isNull() || !root.isObject()) {
                StringBuilder stringBuilder = new StringBuilder().append("bad response: ");
                byte[] byArray = response2.getBody();
                if (byArray == null) {
                    byArray = new byte[]{};
                }
                byte[] byArray3 = byArray;
                throw new IllegalArgumentException(stringBuilder.append(new String(byArray3, Charsets.UTF_8)).toString());
            }
            JsonNode accessToken = root.get("accessToken");
            if (accessToken.isNull() || !accessToken.isTextual()) {
                throw new IllegalArgumentException("bad accessToken: " + accessToken);
            }
            JsonNode tokenTtl = root.get("tokenTtl");
            if (!tokenTtl.isNull() && tokenTtl.isInt()) {
                preferences.putLong(prefix + "_dead", requestTime + (long)(tokenTtl.asInt() * 1000) - (long)1000);
                preferences.put(prefix + "_token", accessToken.asText());
                preferences.flush();
            }
            return accessToken.asText();
        }
        return tokenInPreferences;
    }

    public final void describeService(@NotNull ResourceLocator locator, @NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        String uri = locator.getApi() == NacosApiVersion.V1x ? "/nacos/v1/ns/service" : "/nacos/v2/ns/service";
        this.work(locator, (Function1<? super String, SimpleHttpResponse>)((Function1)new Function1<String, SimpleHttpResponse>(locator, uri, serviceName){
            final /* synthetic */ ResourceLocator $locator;
            final /* synthetic */ String $uri;
            final /* synthetic */ String $serviceName;
            {
                this.$locator = $locator;
                this.$uri = $uri;
                this.$serviceName = $serviceName;
                super(1);
            }

            @NotNull
            public final SimpleHttpResponse invoke(@Nullable String it) {
                return SimpleHttpUtils.httpAccess$default(OpenApiHelper.access$urlFor(OpenApiHelper.INSTANCE, this.$locator, this.$uri, it, MapsKt.mapOf((Pair)TuplesKt.to((Object)"serviceName", (Object)this.$serviceName))), null, null, null, 14, null);
            }
        }), describeService.2.INSTANCE);
    }

    public static final /* synthetic */ String access$urlFor(OpenApiHelper $this, ResourceLocator locator, String uri, String accessToken, Map otherParameter) {
        return $this.urlFor(locator, uri, accessToken, otherParameter);
    }
}

