/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.orchestration;

import io.github.caijiang.common.orchestration.HealthCheck;
import io.github.caijiang.common.orchestration.ServiceNode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/github/caijiang/common/orchestration/HttpHealthCheck;", "Lio/github/caijiang/common/orchestration/HealthCheck;", "uri", "", "code3xxHealthy", "", "code2xxHealthy", "(Ljava/lang/String;ZZ)V", "checkHealth", "stdOutput", "exitCode", "", "toHealthCheckCommand", "node", "Lio/github/caijiang/common/orchestration/ServiceNode;", "common-ext"})
public final class HttpHealthCheck
implements HealthCheck {
    @NotNull
    private final String uri;
    private final boolean code3xxHealthy;
    private final boolean code2xxHealthy;

    public HttpHealthCheck(@NotNull String uri, boolean code3xxHealthy, boolean code2xxHealthy) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.uri = uri;
        this.code3xxHealthy = code3xxHealthy;
        this.code2xxHealthy = code2xxHealthy;
    }

    public /* synthetic */ HttpHealthCheck(String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        this(string, bl, bl2);
    }

    @Override
    @NotNull
    public String toHealthCheckCommand(@NotNull ServiceNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return "curl -o /dev/null -s -w \"%{http_code}\\n\" http://" + node.getIp() + ':' + node.getPort() + this.uri;
    }

    @Override
    public boolean checkHealth(@Nullable String stdOutput, int exitCode) {
        if (exitCode != 0) {
            return false;
        }
        if (stdOutput == null) {
            return false;
        }
        if (this.code2xxHealthy && StringsKt.startsWith$default((String)stdOutput, (String)"2", (boolean)false, (int)2, null)) {
            return true;
        }
        return this.code3xxHealthy && StringsKt.startsWith$default((String)stdOutput, (String)"3", (boolean)false, (int)2, null);
    }
}

