/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.orchestration;

import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.orchestration.Deployment;
import io.github.caijiang.common.orchestration.HealthCheck;
import io.github.caijiang.common.orchestration.IngressEntrance;
import io.github.caijiang.common.orchestration.Service;
import io.github.caijiang.common.orchestration.ServiceDeployer;
import io.github.caijiang.common.orchestration.ServiceNode;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.session.Session;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Slf4j
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u008c\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012O\b\u0002\u0010\u0007\u001aI\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\b\u0012\u001a\b\u0002\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\u0013\u00a2\u0006\u0002\u0010\u0015J.\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 J \u0010!\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\"\u001a\u00020\u0011H\u0004JI\u0010#\u001a\u0004\u0018\u0001H$\"\u0004\b\u0000\u0010$2\u0006\u0010%\u001a\u00020\u00062\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H$0'2\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010-J\u0018\u0010.\u001a\u00020 2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RU\u0010\u0007\u001aI\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lio/github/caijiang/common/orchestration/ServiceDeployer;", "", "keyPair", "", "Ljava/security/KeyPair;", "proxyJump", "", "sshPrepareWork", "Lkotlin/Function3;", "Lorg/apache/sshd/client/session/ClientSession;", "Lkotlin/ParameterName;", "name", "session", "Lio/github/caijiang/common/orchestration/ServiceNode;", "node", "Lio/github/caijiang/common/orchestration/Service;", "service", "", "clientSessionFetcher", "Lkotlin/Function2;", "Lorg/apache/sshd/client/SshClient;", "(Ljava/util/Set;Ljava/lang/String;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function2;)V", "executorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "deploy", "entrances", "", "Lio/github/caijiang/common/orchestration/IngressEntrance;", "deployment", "Lio/github/caijiang/common/orchestration/Deployment;", "restart", "", "environmentCheck", "finalize", "runIn", "T", "taskName", "func", "Lkotlin/Function0;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "allowTimeout", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;JLjava/util/concurrent/TimeUnit;Z)Ljava/lang/Object;", "targetAlreadyDeploy", "common-ext"})
@SourceDebugExtension(value={"SMAP\nServiceDeployer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceDeployer.kt\nio/github/caijiang/common/orchestration/ServiceDeployer\n+ 2 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n16#2:295\n16#2:310\n16#2:311\n16#2:314\n16#2:315\n16#2:317\n16#2:318\n16#2:319\n16#2:320\n16#2:323\n16#2:324\n16#2:325\n16#2:326\n16#2:329\n16#2:332\n16#2:333\n1360#3:296\n1446#3,5:297\n1655#3,8:302\n1855#3,2:312\n1855#3,2:321\n1855#3,2:327\n1855#3,2:330\n1#4:316\n*S KotlinDebug\n*F\n+ 1 ServiceDeployer.kt\nio/github/caijiang/common/orchestration/ServiceDeployer\n*L\n73#1:295\n78#1:310\n81#1:311\n91#1:314\n93#1:315\n96#1:317\n99#1:318\n101#1:319\n107#1:320\n123#1:323\n141#1:324\n161#1:325\n186#1:326\n203#1:329\n228#1:332\n287#1:333\n75#1:296\n75#1:297,5\n76#1:302,8\n89#1:312,2\n108#1:321,2\n187#1:327,2\n204#1:330,2\n*E\n"})
public final class ServiceDeployer {
    @NotNull
    private final Set<KeyPair> keyPair;
    @Nullable
    private final String proxyJump;
    @Nullable
    private final Function3<ClientSession, ServiceNode, Service, Unit> sshPrepareWork;
    @NotNull
    private final Function2<SshClient, ServiceNode, ClientSession> clientSessionFetcher;
    private final ExecutorService executorService;

    public ServiceDeployer(@NotNull Set<KeyPair> keyPair, @Nullable String proxyJump, @Nullable Function3<? super ClientSession, ? super ServiceNode, ? super Service, Unit> sshPrepareWork, @NotNull Function2<? super SshClient, ? super ServiceNode, ? extends ClientSession> clientSessionFetcher) {
        Intrinsics.checkNotNullParameter(keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter(clientSessionFetcher, (String)"clientSessionFetcher");
        this.keyPair = keyPair;
        this.proxyJump = proxyJump;
        this.sshPrepareWork = sshPrepareWork;
        this.clientSessionFetcher = clientSessionFetcher;
        this.executorService = Executors.newCachedThreadPool();
    }

    public /* synthetic */ ServiceDeployer(Set set, final String string, Function3 function3, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            function3 = null;
        }
        if ((n & 8) != 0) {
            function2 = (Function2)new Function2<SshClient, ServiceNode, ClientSession>(){

                public final ClientSession invoke(@NotNull SshClient sshClient, @NotNull ServiceNode node) {
                    Intrinsics.checkNotNullParameter((Object)sshClient, (String)"sshClient");
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    SshClient sshClient2 = sshClient;
                    String string2 = string;
                    SshClient it = sshClient2;
                    boolean bl = false;
                    Session session = ((ConnectFuture)(string2 != null ? it.connect(new HostConfigEntry("", node.getIp(), 22, "root", string2)) : it.connect("root", node.getIp(), 22)).verify(10000L)).getSession();
                    Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getSession(...)");
                    return (ClientSession)session;
                }
            };
        }
        this(set, string, (Function3<? super ClientSession, ? super ServiceNode, ? super Service, Unit>)function3, (Function2<? super SshClient, ? super ServiceNode, ? extends ClientSession>)function2);
    }

    protected final void finalize() {
        this.executorService.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void deploy(@NotNull Service service, @NotNull Collection<? extends IngressEntrance> entrances, @NotNull Deployment deployment, boolean restart) {
        Slf4j.Companion $this$distinctBy$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter(entrances, (String)"entrances");
        Intrinsics.checkNotNullParameter((Object)deployment, (String)"deployment");
        Slf4j.Companion companion = Slf4j.Companion;
        ServiceDeployer $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.info("start deploy service:{}", (Object)service.getId());
        Iterable $this$flatMap$iv = entrances;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IngressEntrance it = (IngressEntrance)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.discoverNodes(service);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        Iterator $i$f$flatMapTo22 = $this$distinctBy$iv.iterator();
        while ($i$f$flatMapTo22.hasNext()) {
            Object e$iv = $i$f$flatMapTo22.next();
            ServiceNode it = (ServiceNode)e$iv;
            boolean bl = false;
            String key$iv = it.getIp();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List nodes = list$iv;
        $this$distinctBy$iv = Slf4j.Companion;
        ServiceDeployer $this$log$iv2 = this;
        boolean $i$f$getLog22 = false;
        Logger logger2 = LoggerFactory.getLogger(ServiceDeployer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        logger2.info("\u6709 " + nodes.size() + "  \u4e2a\u8282\u70b9\u9700\u8981\u5904\u7406");
        for (ServiceNode node : nodes) {
            Slf4j.Companion $i$f$getLog22 = Slf4j.Companion;
            ServiceDeployer $this$log$iv3 = this;
            boolean $i$f$getLog3 = false;
            Logger logger3 = LoggerFactory.getLogger(ServiceDeployer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getLogger(...)");
            logger3.info("\u5f00\u59cb\u5904\u7406:{}", (Object)node.getIp());
            Closeable this_$iv = (Closeable)SshClient.setUpDefaultClient();
            Throwable throwable = null;
            try {
                SshClient sshClient = (SshClient)this_$iv;
                boolean bl = false;
                sshClient.setServerKeyVerifier((ServerKeyVerifier)AcceptAllServerKeyVerifier.INSTANCE);
                sshClient.start();
                Intrinsics.checkNotNull((Object)sshClient);
                Closeable closeable = (Closeable)this.clientSessionFetcher.invoke((Object)sshClient, (Object)node);
                Throwable throwable2 = null;
                try {
                    ClientSession session = (ClientSession)closeable;
                    boolean bl2 = false;
                    Object $this$forEach$iv = this.keyPair;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        KeyPair it = (KeyPair)element$iv;
                        boolean bl3 = false;
                        session.addPublicKeyIdentity(it);
                    }
                    session.auth().verify(10000L);
                    $this$forEach$iv = Slf4j.Companion;
                    Object $this$log$iv4 = this;
                    boolean $i$f$getLog4 = false;
                    Logger logger4 = LoggerFactory.getLogger(ServiceDeployer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getLogger(...)");
                    logger4.debug("ssh login successful");
                    Slf4j.Companion this_$iv2 = Slf4j.Companion;
                    $this$log$iv4 = this;
                    $i$f$getLog4 = false;
                    Logger logger5 = LoggerFactory.getLogger(ServiceDeployer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger5, (String)"getLogger(...)");
                    logger5.debug("prepare ssh");
                    if (this.sshPrepareWork != null) {
                        Function3<ClientSession, ServiceNode, Service, Unit> it;
                        boolean bl4 = false;
                        it.invoke((Object)session, (Object)node, (Object)service);
                    }
                    this_$iv2 = Slf4j.Companion;
                    $this$log$iv4 = this;
                    $i$f$getLog = false;
                    Logger logger6 = LoggerFactory.getLogger(ServiceDeployer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger6, (String)"getLogger(...)");
                    logger6.info("\u5f00\u59cb\u4f9d\u8d56\u73af\u5883\u68c0\u67e5\uff0c\u5305\u62ec\u6743\u9650\uff0c\u57fa\u7840\u8bbe\u65bd\u7b49...");
                    this.environmentCheck(session, node, service);
                    this_$iv2 = Slf4j.Companion;
                    $this$log$iv4 = this;
                    $i$f$getLog = false;
                    Logger logger7 = LoggerFactory.getLogger(ServiceDeployer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger7, (String)"getLogger(...)");
                    logger7.debug("\u68c0\u67e5\u662f\u5426\u9700\u8981\u90e8\u7f72");
                    if (!restart && this.targetAlreadyDeploy(session, deployment)) {
                        this_$iv2 = Slf4j.Companion;
                        $this$log$iv4 = this;
                        $i$f$getLog = false;
                        Logger logger8 = LoggerFactory.getLogger(ServiceDeployer.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger8, (String)"getLogger(...)");
                        logger8.info("node:{} already deployed (\u5982\u679c\u9700\u8981\u91cd\u65b0\u90e8\u7f72\u53ef\u901a\u8fc7 restart \u6307\u4ee4)", (Object)node.getIp());
                    } else {
                        Object element$iv;
                        Object $this$forEach$iv2;
                        boolean il = node.getIngressLess();
                        if (!il) {
                            $this$log$iv4 = Slf4j.Companion;
                            ServiceDeployer $this$log$iv5 = this;
                            boolean $i$f$getLog232 = false;
                            Logger logger9 = LoggerFactory.getLogger(ServiceDeployer.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger9, (String)"getLogger(...)");
                            logger9.info("\u505c\u6b62\u6d41\u91cf\u8fdb\u5165{}...", (Object)node.getIp());
                            $this$forEach$iv2 = entrances;
                            boolean $i$f$forEach2 = false;
                            Iterator $i$f$getLog232 = $this$forEach$iv2.iterator();
                            while ($i$f$getLog232.hasNext()) {
                                element$iv = $i$f$getLog232.next();
                                IngressEntrance it = (IngressEntrance)element$iv;
                                boolean bl5 = false;
                                ServiceDeployer.runIn$default(this, "\u505c\u6b62" + it.getIngressName() + "\u6d41\u91cf\u8fdb\u5165" + node.getIp(), (Function0)new Function0<Unit>(this, it, node){
                                    final /* synthetic */ ServiceDeployer this$0;
                                    final /* synthetic */ IngressEntrance $it;
                                    final /* synthetic */ ServiceNode $node;
                                    {
                                        this.this$0 = $receiver;
                                        this.$it = $it;
                                        this.$node = $node;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        while (true) {
                                            Object $this$log$iv;
                                            try {
                                                Slf4j.Companion companion = Slf4j.Companion;
                                                $this$log$iv = this.this$0;
                                                boolean $i$f$getLog = false;
                                                Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                                                logger.trace("\u6267\u884c\u505c\u6b62{}\u6d41\u91cf\u8fdb\u5165{}", (Object)this.$it.getIngressName(), (Object)this.$node.getIp());
                                                this.$it.suspendNode(this.$node);
                                            }
                                            catch (Exception e) {
                                                $this$log$iv = Slf4j.Companion;
                                                ServiceDeployer $this$log$iv2 = this.this$0;
                                                boolean $i$f$getLog = false;
                                                Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                                                logger.trace("\u5c1d\u8bd5\u505c\u6b62\u6d41\u91cf\u65f6", (Throwable)e);
                                                Thread.sleep(3000L);
                                                continue;
                                            }
                                            break;
                                        }
                                    }
                                }, 3L, TimeUnit.MINUTES, false, 16, null);
                            }
                            $this$forEach$iv2 = Slf4j.Companion;
                            $this$log$iv = this;
                            boolean $i$f$getLog5 = false;
                            Logger logger10 = LoggerFactory.getLogger(ServiceDeployer.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger10, (String)"getLogger(...)");
                            logger10.debug("\u68c0\u67e5\u6d41\u91cf\u662f\u5426\u5df2\u7ecf\u8d70\u5b8c");
                            ServiceDeployer.runIn$default(this, "\u68c0\u67e5\u6d41\u91cf\u662f\u5426\u8d70\u5b8c", (Function0)new Function0<Unit>(node, this, session){
                                final /* synthetic */ ServiceNode $node;
                                final /* synthetic */ ServiceDeployer this$0;
                                final /* synthetic */ ClientSession $session;
                                {
                                    this.$node = $node;
                                    this.this$0 = $receiver;
                                    this.$session = $session;
                                    super(0);
                                }

                                public final void invoke() {
                                    while (true) {
                                        Slf4j.Companion this_$iv;
                                        boolean $i$f$getLog;
                                        ServiceDeployer $this$log$iv;
                                        try {
                                            String cmd = "ss -an |grep \"" + this.$node.getIp() + ':' + this.$node.getPort() + "\"|grep ESTAB";
                                            Slf4j.Companion companion = Slf4j.Companion;
                                            $this$log$iv = this.this$0;
                                            $i$f$getLog = false;
                                            Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                                            logger.trace("preparing to execute:{}", (Object)cmd);
                                            this.$session.executeRemoteCommand(cmd);
                                            this_$iv = Slf4j.Companion;
                                            $this$log$iv = this.this$0;
                                            $i$f$getLog = false;
                                            Logger logger2 = LoggerFactory.getLogger(ServiceDeployer.class);
                                            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
                                            logger2.trace("{}  \u53ef\u6210\u529f\u6267\u884c", (Object)cmd);
                                            Thread.sleep(5000L);
                                        }
                                        catch (RemoteException e) {
                                            this_$iv = Slf4j.Companion;
                                            $this$log$iv = this.this$0;
                                            $i$f$getLog = false;
                                            Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                                            logger.trace("\u68c0\u67e5\u6d41\u91cf", (Throwable)e);
                                            return;
                                        }
                                    }
                                }
                            }, 3L, TimeUnit.MINUTES, false, 16, null);
                        }
                        Slf4j.Companion this_$iv3 = Slf4j.Companion;
                        ServiceDeployer $this$log$iv6 = this;
                        boolean $i$f$getLog6 = false;
                        Logger logger11 = LoggerFactory.getLogger(ServiceDeployer.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger11, (String)"getLogger(...)");
                        logger11.info("\u6267\u884c\u90e8\u7f72\u6307\u4ee4...");
                        this.runIn("\u6267\u884c\u90e8\u7f72", (Function0)new Function0<String>(service, node, deployment, this, session){
                            final /* synthetic */ Service $service;
                            final /* synthetic */ ServiceNode $node;
                            final /* synthetic */ Deployment $deployment;
                            final /* synthetic */ ServiceDeployer this$0;
                            final /* synthetic */ ClientSession $session;
                            {
                                this.$service = $service;
                                this.$node = $node;
                                this.$deployment = $deployment;
                                this.this$0 = $receiver;
                                this.$session = $session;
                                super(0);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Nullable
                            public final String invoke() {
                                Map<String, String> map;
                                block6: {
                                    block5: {
                                        void $this$filterTo$iv$iv;
                                        void $this$filter$iv;
                                        map = this.$service.getEnvironment();
                                        if (map == null) break block5;
                                        Map<String, String> stringStringMap = map;
                                        boolean bl = false;
                                        Iterable iterable = stringStringMap.entrySet();
                                        boolean $i$f$filter = false;
                                        void var9_6 = $this$filter$iv;
                                        Collection destination$iv$iv = new ArrayList<E>();
                                        boolean $i$f$filterTo = false;
                                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                                            Map.Entry it = (Map.Entry)element$iv$iv;
                                            boolean bl2 = false;
                                            boolean bl3 = ((CharSequence)it.getKey()).length() > 0 && ((CharSequence)it.getValue()).length() > 0;
                                            if (!bl3) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, (Function1)deploy.1.1.withEnv.1.2.INSTANCE, (int)30, null);
                                        map = string;
                                        if (string != null) break block6;
                                    }
                                    map = "";
                                }
                                Map<String, String> withEnv2 = map;
                                StringBuilder stringBuilder = new StringBuilder().append(this.$service.getDeployCommand()).append(' ').append(this.$service.getId()).append(' ').append(this.$node.getIp()).append(' ').append(this.$node.getPort()).append(' ').append(this.$deployment.getImageUrl()).append(' ').append(this.$deployment.getImageTag()).append(' ');
                                String string = this.$service.getType();
                                if (string == null) {
                                    string = "\"\"";
                                }
                                String cmd = stringBuilder.append(string).append((String)((Object)withEnv2)).toString();
                                Slf4j.Companion companion = Slf4j.Companion;
                                ServiceDeployer $this$log$iv = this.this$0;
                                boolean $i$f$getLog = false;
                                Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                                logger.trace("preparing to execute:{}", (Object)cmd);
                                return this.$session.executeRemoteCommand(cmd, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM, StandardCharsets.US_ASCII);
                            }
                        }, 5L, TimeUnit.MINUTES, true);
                        this_$iv3 = Slf4j.Companion;
                        $this$log$iv6 = this;
                        $i$f$getLog6 = false;
                        Logger logger12 = LoggerFactory.getLogger(ServiceDeployer.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger12, (String)"getLogger(...)");
                        logger12.info("\u6267\u884c\u5065\u5eb7\u68c0\u67e5...");
                        ServiceDeployer.runIn$default(this, "\u5065\u5eb7\u68c0\u67e5", (Function0)new Function0<Unit>(service, node, this, session){
                            final /* synthetic */ Service $service;
                            final /* synthetic */ ServiceNode $node;
                            final /* synthetic */ ServiceDeployer this$0;
                            final /* synthetic */ ClientSession $session;
                            {
                                this.$service = $service;
                                this.$node = $node;
                                this.this$0 = $receiver;
                                this.$session = $session;
                                super(0);
                            }

                            public final void invoke() {
                                HealthCheck hc = this.$service.getHealthCheck();
                                String cmd = hc.toHealthCheckCommand(this.$node);
                                while (true) {
                                    Slf4j.Companion companion = Slf4j.Companion;
                                    Object $this$log$iv = this.this$0;
                                    boolean $i$f$getLog = false;
                                    Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                                    logger.trace("preparing to execute:{}", (Object)cmd);
                                    try {
                                        String data = this.$session.executeRemoteCommand(cmd);
                                        if (hc.checkHealth(data, 0)) break;
                                        Thread.sleep(3000L);
                                    }
                                    catch (RemoteException e) {
                                        $this$log$iv = Slf4j.Companion;
                                        ServiceDeployer $this$log$iv2 = this.this$0;
                                        boolean $i$f$getLog2 = false;
                                        Logger logger2 = LoggerFactory.getLogger(ServiceDeployer.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
                                        logger2.trace("health check failed: {}", (Object)e.getMessage());
                                        if (hc.checkHealth(null, 1)) break;
                                        Thread.sleep(3000L);
                                    }
                                }
                            }
                        }, 6L, TimeUnit.MINUTES, false, 16, null);
                        if (!il) {
                            this_$iv3 = Slf4j.Companion;
                            $this$log$iv6 = this;
                            $i$f$getLog6 = false;
                            Logger logger13 = LoggerFactory.getLogger(ServiceDeployer.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger13, (String)"getLogger(...)");
                            logger13.info("\u6062\u590d\u6d41\u91cf\u8fdb\u5165{}...", (Object)node.getIp());
                            $this$forEach$iv2 = entrances;
                            boolean $i$f$forEach3 = false;
                            Iterator $i$f$getLog7 = $this$forEach$iv2.iterator();
                            while ($i$f$getLog7.hasNext()) {
                                element$iv = $i$f$getLog7.next();
                                IngressEntrance it = (IngressEntrance)element$iv;
                                boolean bl6 = false;
                                ServiceDeployer.runIn$default(this, "\u6062\u590d" + it.getIngressName() + "\u6d41\u91cf\u8fdb\u5165" + node.getIp(), (Function0)new Function0<Unit>(this, it, node){
                                    final /* synthetic */ ServiceDeployer this$0;
                                    final /* synthetic */ IngressEntrance $it;
                                    final /* synthetic */ ServiceNode $node;
                                    {
                                        this.this$0 = $receiver;
                                        this.$it = $it;
                                        this.$node = $node;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        while (true) {
                                            Object $this$log$iv;
                                            try {
                                                Slf4j.Companion companion = Slf4j.Companion;
                                                $this$log$iv = this.this$0;
                                                boolean $i$f$getLog = false;
                                                Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                                                logger.trace("\u6267\u884c\u6062\u590d{}\u6d41\u91cf\u8fdb\u5165{}", (Object)this.$it.getIngressName(), (Object)this.$node.getIp());
                                                this.$it.resumedNode(this.$node);
                                            }
                                            catch (Exception e) {
                                                $this$log$iv = Slf4j.Companion;
                                                ServiceDeployer $this$log$iv2 = this.this$0;
                                                boolean $i$f$getLog = false;
                                                Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                                                logger.trace("\u5c1d\u8bd5\u6062\u590d\u6d41\u91cf\u65f6", (Throwable)e);
                                                Thread.sleep(3000L);
                                                continue;
                                            }
                                            break;
                                        }
                                    }
                                }, 3L, TimeUnit.MINUTES, false, 16, null);
                            }
                            $this$forEach$iv2 = Slf4j.Companion;
                            $this$log$iv = this;
                            boolean $i$f$getLog32 = false;
                            Logger logger14 = LoggerFactory.getLogger(ServiceDeployer.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger14, (String)"getLogger(...)");
                            logger14.info("\u68c0\u67e5\u6d41\u91cf\u662f\u5426\u8fdb\u5165{}...", (Object)node.getIp());
                            $this$forEach$iv2 = entrances;
                            $i$f$forEach = false;
                            Iterator iterator2 = $this$forEach$iv2.iterator();
                            while (iterator2.hasNext()) {
                                element$iv = iterator2.next();
                                IngressEntrance it = (IngressEntrance)element$iv;
                                boolean bl7 = false;
                                ServiceDeployer.runIn$default(this, "\u68c0\u67e5" + it.getIngressName() + "\u6d41\u91cf\u662f\u5426\u53ef\u4ee5\u6b63\u5e38\u8fdb\u5165" + node.getIp() + ':' + node.getPort() + '\u4e86', (Function0)new Function0<Unit>(this, it, node){
                                    final /* synthetic */ ServiceDeployer this$0;
                                    final /* synthetic */ IngressEntrance $it;
                                    final /* synthetic */ ServiceNode $node;
                                    {
                                        this.this$0 = $receiver;
                                        this.$it = $it;
                                        this.$node = $node;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        while (true) {
                                            Object[] objectArray = Slf4j.Companion;
                                            ServiceDeployer $this$log$iv = this.this$0;
                                            boolean $i$f$getLog = false;
                                            Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                                            objectArray = new Object[]{this.$it.getIngressName(), this.$node.getIp(), this.$node.getPort()};
                                            logger.trace("\u6267\u884c\u68c0\u67e5{}\u6d41\u91cf\u662f\u5426\u53ef\u4ee5\u6b63\u5e38\u8fdb\u5165{}:{}", objectArray);
                                            if (this.$it.checkWorkStatus(this.$node)) break;
                                            Thread.sleep(3000L);
                                        }
                                    }
                                }, 6L, TimeUnit.MINUTES, false, 16, null);
                            }
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)this_$iv, (Throwable)throwable);
            }
        }
        Slf4j.Companion this_$iv = Slf4j.Companion;
        $this$log$iv2 = this;
        boolean $i$f$getLog8 = false;
        Logger logger15 = LoggerFactory.getLogger(ServiceDeployer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger15, (String)"getLogger(...)");
        logger15.info("service:{} \u5df2\u5b8c\u6210\u90e8\u7f72", (Object)service.getId());
    }

    public static /* synthetic */ void deploy$default(ServiceDeployer serviceDeployer, Service service, Collection collection, Deployment deployment, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        serviceDeployer.deploy(service, collection, deployment, bl);
    }

    private final void environmentCheck(ClientSession session, ServiceNode node, Service service) {
        ServiceDeployer.runIn$default(this, "\u4f9d\u8d56\u73af\u5883\u68c0\u67e5", (Function0)new Function0<Unit>(session, this, node, service){
            final /* synthetic */ ClientSession $session;
            final /* synthetic */ ServiceDeployer this$0;
            final /* synthetic */ ServiceNode $node;
            final /* synthetic */ Service $service;
            {
                this.$session = $session;
                this.this$0 = $receiver;
                this.$node = $node;
                this.$service = $service;
                super(0);
            }

            public final void invoke() {
                Slf4j.Companion this_$iv;
                boolean $i$f$getLog;
                ServiceDeployer $this$log$iv;
                try {
                    String docker = this.$session.executeRemoteCommand("docker -v");
                    Slf4j.Companion companion = Slf4j.Companion;
                    $this$log$iv = this.this$0;
                    $i$f$getLog = false;
                    Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                    logger.debug("host:{}, docker: {}", (Object)this.$node.getIp(), (Object)docker);
                }
                catch (Exception e) {
                    throw new IllegalStateException("host:" + this.$node.getIp() + " \u7f3a\u5c11 docker,\u6216\u8005\u7f3a\u5c11\u6267\u884c\u7684\u6743\u9650");
                }
                try {
                    String curl = this.$session.executeRemoteCommand("curl --version");
                    this_$iv = Slf4j.Companion;
                    $this$log$iv = this.this$0;
                    $i$f$getLog = false;
                    Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                    logger.debug("host:{}, curl: {}", (Object)this.$node.getIp(), (Object)curl);
                }
                catch (Exception e) {
                    throw new IllegalStateException("host:" + this.$node.getIp() + " \u7f3a\u5c11 curl");
                }
                try {
                    String ss = this.$session.executeRemoteCommand("ss -v");
                    this_$iv = Slf4j.Companion;
                    $this$log$iv = this.this$0;
                    $i$f$getLog = false;
                    Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                    logger.debug("host:{}, ss: {}", (Object)this.$node.getIp(), (Object)ss);
                }
                catch (Exception e) {
                    throw new IllegalStateException("host:" + this.$node.getIp() + " \u7f3a\u5c11 ss");
                }
                try {
                    String dc = this.$session.executeRemoteCommand("command -v " + this.$service.getDeployCommand());
                    this_$iv = Slf4j.Companion;
                    $this$log$iv = this.this$0;
                    $i$f$getLog = false;
                    Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                    logger.debug("host:{}, command: {}", (Object)this.$node.getIp(), (Object)dc);
                }
                catch (Exception e) {
                    throw new IllegalStateException("host:" + this.$node.getIp() + " \u7f3a\u5c11\u53ef\u6267\u884c\u7684" + this.$service.getDeployCommand());
                }
            }
        }, 10L, null, false, 24, null);
    }

    private final boolean targetAlreadyDeploy(ClientSession session, Deployment deployment) {
        try {
            session.executeRemoteCommand("docker ps|grep " + deployment.getImageUrl() + ':' + deployment.getImageTag());
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final <T> T runIn(String taskName, Function0<? extends T> func, long timeout, TimeUnit unit, boolean allowTimeout) {
        Future<Object> future = this.executorService.submit(() -> ServiceDeployer.runIn$lambda$9(func));
        try {
            return (T)future.get(timeout, unit);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            Intrinsics.checkNotNull((Object)throwable);
            throw throwable;
        }
        catch (TimeoutException e) {
            if (allowTimeout) {
                Slf4j.Companion companion = Slf4j.Companion;
                ServiceDeployer $this$log$iv = this;
                boolean $i$f$getLog = false;
                Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                logger.info("\u6267\u884c{}\u65f6\u8d85\u65f6,\u4f46\u6709\u53ef\u80fd\u662f\u6b63\u5e38\u60c5\u51b5", (Object)taskName);
                return null;
            }
            future.cancel(true);
            throw new IllegalStateException("\u6267\u884c" + taskName + "\u65f6\u8d85\u65f6", e);
        }
    }

    static /* synthetic */ Object runIn$default(ServiceDeployer serviceDeployer, String string, Function0 function0, long l, TimeUnit timeUnit, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return serviceDeployer.runIn(string, function0, l, timeUnit, bl);
    }

    private static final Object runIn$lambda$9(Function0 $func) {
        Intrinsics.checkNotNullParameter((Object)$func, (String)"$func");
        return $func.invoke();
    }
}

