/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.security;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\rH\u0007\u00a8\u0006\u001a"}, d2={"Lio/github/caijiang/common/security/RSAUtils;", "", "()V", "extraPublicKey", "Ljava/security/PublicKey;", "privateKey", "Ljava/security/interfaces/RSAPrivateKey;", "generatePrivateKey", "Ljava/security/KeyPair;", "keySize", "", "readKeyPairFromPKCS8", "key", "", "readPrivateKeyFromPKCS8", "readPublicKey", "Ljava/security/interfaces/RSAPublicKey;", "readPublicKeyPem", "signatureAsBase64", "Ljava/security/PrivateKey;", "payload", "", "verify", "", "publicKey", "signatureBase64", "common-ext"})
public final class RSAUtils {
    @NotNull
    public static final RSAUtils INSTANCE = new RSAUtils();

    private RSAUtils() {
    }

    @JvmStatic
    @NotNull
    public static final KeyPair generatePrivateKey(int keySize) throws InvalidParameterException {
        KeyPairGenerator keyPairGenerator;
        KeyPairGenerator $this$generatePrivateKey_u24lambda_u240 = keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        boolean bl = false;
        $this$generatePrivateKey_u24lambda_u240.initialize(keySize);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"generateKeyPair(...)");
        return keyPair;
    }

    public static /* synthetic */ KeyPair generatePrivateKey$default(int n, int n2, Object object) throws InvalidParameterException {
        if ((n2 & 1) != 0) {
            n = 2048;
        }
        return RSAUtils.generatePrivateKey(n);
    }

    @JvmStatic
    @NotNull
    public static final RSAPrivateKey readPrivateKeyFromPKCS8(@NotNull String key) throws InvalidKeySpecException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = StringsKt.replace$default((String)key, (String)"-----BEGIN PRIVATE KEY-----", (String)"", (boolean)false, (int)4, null);
        String string2 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator(...)");
        String pem = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)string2, (String)"", (boolean)false, (int)4, null), (String)"-----END PRIVATE KEY-----", (String)"", (boolean)false, (int)4, null);
        byte[] byArray = Base64.getDecoder().decode(pem);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] encoded = byArray;
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPrivateKey");
        return (RSAPrivateKey)privateKey;
    }

    @JvmStatic
    @NotNull
    public static final KeyPair readKeyPairFromPKCS8(@NotNull String key) throws InvalidKeySpecException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        RSAPrivateKey privateKey = RSAUtils.readPrivateKeyFromPKCS8(key);
        return new KeyPair(INSTANCE.extraPublicKey(privateKey), privateKey);
    }

    @JvmStatic
    @NotNull
    public static final String signatureAsBase64(@NotNull PrivateKey key, @NotNull byte[] payload) throws InvalidKeySpecException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(key);
        signature.update(payload);
        byte[] result = signature.sign();
        String string = Base64.getEncoder().encodeToString(result);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    @JvmStatic
    public static final boolean verify(@NotNull PublicKey publicKey, @NotNull byte[] payload, @NotNull String signatureBase64) throws InvalidKeyException, SignatureException {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)signatureBase64, (String)"signatureBase64");
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initVerify(publicKey);
        signature.update(payload);
        return signature.verify(Base64.getDecoder().decode(signatureBase64));
    }

    private final PublicKey extraPublicKey(RSAPrivateKey privateKey) {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        BigInteger bigInteger = privateKey.getModulus();
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPrivateCrtKey");
        PublicKey publicKey = keyFactory.generatePublic(new RSAPublicKeySpec(bigInteger, ((RSAPrivateCrtKey)privateKey).getPublicExponent()));
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"generatePublic(...)");
        return publicKey;
    }

    @JvmStatic
    @NotNull
    public static final String readPublicKeyPem(@NotNull RSAPrivateKey privateKey) throws InvalidKeySpecException {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        PublicKey pk = INSTANCE.extraPublicKey(privateKey);
        String string = Base64.getEncoder().encodeToString(pk.getEncoded());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final RSAPublicKey readPublicKey(@NotNull String key) throws InvalidKeySpecException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = StringsKt.replace$default((String)key, (String)"-----BEGIN PUBLIC KEY-----", (String)"", (boolean)false, (int)4, null);
        String string2 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator(...)");
        String pem = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)string2, (String)"", (boolean)false, (int)4, null), (String)"-----END PUBLIC KEY-----", (String)"", (boolean)false, (int)4, null);
        byte[] encoded = Base64.getDecoder().decode(pem);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encoded);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = factory.generatePublic(publicKeySpec);
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        return (RSAPublicKey)publicKey;
    }
}

