/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.wechat.support;

import io.github.caijiang.common.wechat.TokenCacheService;
import io.github.caijiang.common.wechat.data.ExpiredToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Instant;
import java.util.prefs.Preferences;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/github/caijiang/common/wechat/support/SingleJvmCacheService;", "Lio/github/caijiang/common/wechat/TokenCacheService;", "()V", "store", "Ljava/util/prefs/Preferences;", "kotlin.jvm.PlatformType", "accessTokenCache", "Lio/github/caijiang/common/wechat/data/ExpiredToken;", "appId", "", "javascriptApiTicketCache", "query", "type", "updateAccessToken", "", "token", "updateJavascriptApiTicket", "updateNew", "common-ext"})
public final class SingleJvmCacheService
implements TokenCacheService {
    private final Preferences store = Preferences.userNodeForPackage(SingleJvmCacheService.class);

    @Override
    @Nullable
    public ExpiredToken accessTokenCache(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        return this.query("AccessToken", appId);
    }

    @Override
    public void updateAccessToken(@NotNull String appId, @NotNull ExpiredToken token) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.updateNew("AccessToken", appId, token);
    }

    @Override
    @Nullable
    public ExpiredToken javascriptApiTicketCache(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        return this.query("JAPI", appId);
    }

    @Override
    public void updateJavascriptApiTicket(@NotNull String appId, @NotNull ExpiredToken token) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.updateNew("JAPI", appId, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExpiredToken query(String type, String appId) {
        ExpiredToken expiredToken;
        byte[] byArray = this.store.getByteArray("x-" + type + '-' + appId, null);
        if (byArray == null) {
            return null;
        }
        byte[] str = byArray;
        Closeable closeable = new ObjectInputStream(new ByteArrayInputStream(str));
        Throwable throwable = null;
        try {
            ExpiredToken expiredToken2;
            ObjectInputStream stream = (ObjectInputStream)closeable;
            boolean bl = false;
            Object object = stream.readObject();
            ExpiredToken expiredToken3 = object instanceof ExpiredToken ? (ExpiredToken)object : null;
            if (expiredToken3 != null) {
                ExpiredToken it = expiredToken3;
                boolean bl2 = false;
                expiredToken2 = Instant.now().isBefore(it.getExpireTime()) ? it : null;
            } else {
                expiredToken2 = null;
            }
            expiredToken = expiredToken2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return expiredToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateNew(String type, String appId, ExpiredToken token) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        Closeable closeable = new ObjectOutputStream(buf);
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)closeable;
            boolean bl = false;
            it.writeObject(token);
            it.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.store.putByteArray("x-" + type + '-' + appId, buf.toByteArray());
    }
}

