/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.orchestration;

import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.logging.LoggingApi;
import io.github.caijiang.common.logging.SKt;
import io.github.caijiang.common.orchestration.Deployment;
import io.github.caijiang.common.orchestration.HealthCheck;
import io.github.caijiang.common.orchestration.IngressEntrance;
import io.github.caijiang.common.orchestration.NodeDeployStage;
import io.github.caijiang.common.orchestration.Service;
import io.github.caijiang.common.orchestration.ServiceDeployer;
import io.github.caijiang.common.orchestration.ServiceNode;
import io.github.caijiang.common.orchestration.exception.NodeRelatedIllegalStateException;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.security.KeyPair;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.session.Session;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.logging.LogLevel;

@Slf4j
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0098\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012O\b\u0002\u0010\u0007\u001aI\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\b\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\u001a\b\u0002\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\u0015\u00a2\u0006\u0002\u0010\u0017J\u00d6\u0001\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"2d\b\u0002\u0010#\u001a^\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b('\u0012\u0015\u0012\u0013\u0018\u00010(\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\u00110$2\u001a\b\u0002\u0010*\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0,\u0012\u0004\u0012\u00020\u00110+2\u001a\b\u0002\u0010-\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u00110\u00152\b\b\u0002\u0010/\u001a\u000200J(\u00101\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\"H\u0002J\b\u00103\u001a\u00020\u0011H\u0004JY\u00104\u001a\u0004\u0018\u0001H5\"\u0004\b\u0000\u001052\u0006\u00106\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2\u0006\u00102\u001a\u00020\"2\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H5082\u0006\u00109\u001a\u00020:2\b\b\u0002\u0010;\u001a\u00020<2\b\b\u0002\u0010=\u001a\u000200H\u0002\u00a2\u0006\u0002\u0010>J\u0018\u0010?\u001a\u0002002\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0002R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000RU\u0010\u0007\u001aI\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lio/github/caijiang/common/orchestration/ServiceDeployer;", "", "keyPair", "", "Ljava/security/KeyPair;", "proxyJump", "", "sshPrepareWork", "Lkotlin/Function3;", "Lorg/apache/sshd/client/session/ClientSession;", "Lkotlin/ParameterName;", "name", "session", "Lio/github/caijiang/common/orchestration/ServiceNode;", "node", "Lio/github/caijiang/common/orchestration/Service;", "service", "", "sleepAfterSuspend", "Ljava/time/Duration;", "clientSessionFetcher", "Lkotlin/Function2;", "Lorg/apache/sshd/client/SshClient;", "(Ljava/util/Set;Ljava/lang/String;Lkotlin/jvm/functions/Function3;Ljava/time/Duration;Lkotlin/jvm/functions/Function2;)V", "executorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "deploy", "entrances", "", "Lio/github/caijiang/common/orchestration/IngressEntrance;", "deployment", "Lio/github/caijiang/common/orchestration/Deployment;", "logForService", "Lio/github/caijiang/common/logging/LoggingApi;", "logForNode", "Lkotlin/Function4;", "Lorg/springframework/boot/logging/LogLevel;", "level", "message", "", "throwable", "nodesAware", "Lkotlin/Function1;", "", "nodeStageChanger", "Lio/github/caijiang/common/orchestration/NodeDeployStage;", "restart", "", "environmentCheck", "loggingApi", "finalize", "runInNode", "T", "taskName", "func", "Lkotlin/Function0;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "allowTimeout", "(Ljava/lang/String;Lio/github/caijiang/common/orchestration/ServiceNode;Lio/github/caijiang/common/logging/LoggingApi;Lkotlin/jvm/functions/Function0;JLjava/util/concurrent/TimeUnit;Z)Ljava/lang/Object;", "targetAlreadyDeploy", "common-ext"})
@SourceDebugExtension(value={"SMAP\nServiceDeployer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceDeployer.kt\nio/github/caijiang/common/orchestration/ServiceDeployer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n*L\n1#1,405:1\n1271#2,2:406\n1285#2,4:408\n1655#2,8:412\n1855#2,2:420\n1855#2,2:423\n1855#2,2:425\n1855#2,2:427\n1#3:422\n16#4:429\n*S KotlinDebug\n*F\n+ 1 ServiceDeployer.kt\nio/github/caijiang/common/orchestration/ServiceDeployer\n*L\n100#1:406,2\n100#1:408,4\n103#1:412,8\n127#1:420,2\n152#1:423,2\n262#1:425,2\n298#1:427,2\n77#1:429\n*E\n"})
public final class ServiceDeployer {
    @NotNull
    private final Set<KeyPair> keyPair;
    @Nullable
    private final String proxyJump;
    @Nullable
    private final Function3<ClientSession, ServiceNode, Service, Unit> sshPrepareWork;
    @Nullable
    private final Duration sleepAfterSuspend;
    @NotNull
    private final Function2<SshClient, ServiceNode, ClientSession> clientSessionFetcher;
    private final ExecutorService executorService;

    public ServiceDeployer(@NotNull Set<KeyPair> keyPair, @Nullable String proxyJump, @Nullable Function3<? super ClientSession, ? super ServiceNode, ? super Service, Unit> sshPrepareWork, @Nullable Duration sleepAfterSuspend, @NotNull Function2<? super SshClient, ? super ServiceNode, ? extends ClientSession> clientSessionFetcher) {
        Intrinsics.checkNotNullParameter(keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter(clientSessionFetcher, (String)"clientSessionFetcher");
        this.keyPair = keyPair;
        this.proxyJump = proxyJump;
        this.sshPrepareWork = sshPrepareWork;
        this.sleepAfterSuspend = sleepAfterSuspend;
        this.clientSessionFetcher = clientSessionFetcher;
        this.executorService = Executors.newCachedThreadPool();
    }

    public /* synthetic */ ServiceDeployer(Set set, final String string, Function3 function3, Duration duration, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            function3 = null;
        }
        if ((n & 8) != 0) {
            duration = null;
        }
        if ((n & 0x10) != 0) {
            function2 = (Function2)new Function2<SshClient, ServiceNode, ClientSession>(){

                public final ClientSession invoke(@NotNull SshClient sshClient, @NotNull ServiceNode node) {
                    Intrinsics.checkNotNullParameter((Object)sshClient, (String)"sshClient");
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    SshClient sshClient2 = sshClient;
                    String string2 = string;
                    SshClient it = sshClient2;
                    boolean bl = false;
                    Session session = ((ConnectFuture)(string2 != null ? it.connect(new HostConfigEntry("", node.getIp(), 22, "root", string2)) : it.connect("root", node.getIp(), 22)).verify(10000L)).getSession();
                    Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getSession(...)");
                    return (ClientSession)session;
                }
            };
        }
        this(set, string, (Function3<? super ClientSession, ? super ServiceNode, ? super Service, Unit>)function3, duration, (Function2<? super SshClient, ? super ServiceNode, ? extends ClientSession>)function2);
    }

    protected final void finalize() {
        this.executorService.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void deploy(@NotNull Service service, @NotNull Collection<? extends IngressEntrance> entrances, @NotNull Deployment deployment, @NotNull LoggingApi logForService, @NotNull Function4<? super ServiceNode, ? super LogLevel, ? super String, ? super Throwable, Unit> logForNode, @NotNull Function1<? super List<? extends ServiceNode>, Unit> nodesAware, @NotNull Function2<? super ServiceNode, ? super NodeDeployStage, Unit> nodeStageChanger, boolean restart) {
        void $this$distinctBy$iv;
        ServiceNode it;
        IngressEntrance ingressEntrance;
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter(entrances, (String)"entrances");
        Intrinsics.checkNotNullParameter((Object)deployment, (String)"deployment");
        Intrinsics.checkNotNullParameter((Object)logForService, (String)"logForService");
        Intrinsics.checkNotNullParameter(logForNode, (String)"logForNode");
        Intrinsics.checkNotNullParameter(nodesAware, (String)"nodesAware");
        Intrinsics.checkNotNullParameter(nodeStageChanger, (String)"nodeStageChanger");
        logForService.logMessage(LogLevel.INFO, "\u5f00\u59cb\u90e8\u7f72\u670d\u52a1:" + service.getId(), null);
        Iterable $this$associateWith$iv = entrances;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            ingressEntrance = (IngressEntrance)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            List<ServiceNode> list2 = it.discoverNodes(service);
            map.put(t, list2);
        }
        Map allNodes = result$iv;
        Iterable $i$f$associateWith22 = CollectionsKt.flatten((Iterable)allNodes.values());
        boolean $i$f$distinctBy = false;
        HashSet<Pair> set$iv = new HashSet<Pair>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            it = (ServiceNode)e$iv;
            boolean bl = false;
            Pair key$iv = TuplesKt.to((Object)it.getIp(), (Object)it.getPort());
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List nodes = list$iv;
        nodesAware.invoke((Object)nodes);
        logForService.logMessage(LogLevel.INFO, "" + '\u6709' + nodes.size() + " \u4e2a\u8282\u70b9\u9700\u8981\u5904\u7406", null);
        Function2 findMatchNode2 = (Function2)new Function2<IngressEntrance, ServiceNode, ServiceNode>((Map<IngressEntrance, ? extends List<? extends ServiceNode>>)allNodes){
            final /* synthetic */ Map<IngressEntrance, List<ServiceNode>> $allNodes;
            {
                this.$allNodes = $allNodes;
                super(2);
            }

            @Nullable
            public final ServiceNode invoke(@NotNull IngressEntrance entrance, @NotNull ServiceNode input) {
                ServiceNode serviceNode;
                Intrinsics.checkNotNullParameter((Object)entrance, (String)"entrance");
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                List<ServiceNode> list2 = this.$allNodes.get(entrance);
                if (list2 != null) {
                    Object v1;
                    block3: {
                        Iterable iterable = list2;
                        for (T t : iterable) {
                            ServiceNode it = (ServiceNode)t;
                            boolean bl = false;
                            if (!(Intrinsics.areEqual((Object)it.getIp(), (Object)input.getIp()) && it.getPort() == input.getPort())) continue;
                            v1 = t;
                            break block3;
                        }
                        v1 = null;
                    }
                    serviceNode = v1;
                } else {
                    serviceNode = null;
                }
                return serviceNode;
            }
        };
        for (ServiceNode node : nodes) {
            LoggingApi logForThisNode2 = new LoggingApi(logForNode, node){
                final /* synthetic */ Function4<ServiceNode, LogLevel, String, Throwable, Unit> $logForNode;
                final /* synthetic */ ServiceNode $node;
                {
                    this.$logForNode = $logForNode;
                    this.$node = $node;
                }

                public void logMessage(@NotNull LogLevel level, @NotNull String message, @Nullable Throwable throwable) {
                    Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    this.$logForNode.invoke((Object)this.$node, (Object)level, (Object)message, (Object)throwable);
                }
            };
            nodeStageChanger.invoke((Object)node, (Object)NodeDeployStage.Prepare);
            logForThisNode2.logMessage(LogLevel.INFO, "\u5f00\u59cb\u90e8\u7f72\u4f5c\u4e1a", null);
            Closeable closeable = (Closeable)SshClient.setUpDefaultClient();
            Throwable throwable = null;
            try {
                SshClient sshClient = (SshClient)closeable;
                boolean bl = false;
                sshClient.setServerKeyVerifier((ServerKeyVerifier)AcceptAllServerKeyVerifier.INSTANCE);
                sshClient.start();
                Intrinsics.checkNotNull((Object)sshClient);
                Closeable closeable2 = (Closeable)this.clientSessionFetcher.invoke((Object)sshClient, (Object)node);
                Throwable throwable2 = null;
                try {
                    ClientSession session = (ClientSession)closeable2;
                    boolean bl2 = false;
                    Iterable $this$forEach$iv = this.keyPair;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        KeyPair it2 = (KeyPair)element$iv;
                        boolean bl3 = false;
                        session.addPublicKeyIdentity(it2);
                    }
                    session.auth().verify(10000L);
                    logForThisNode2.logMessage(LogLevel.DEBUG, "\u6210\u529f\u767b\u5f55 SSH,\u51c6\u5907\u6267\u884c\u9884\u5236\u811a\u672c\u4ee5\u53ca\u81ea\u5b9a\u4e49\u811a\u672c", null);
                    if (this.sshPrepareWork != null) {
                        Function3<ClientSession, ServiceNode, Service, Unit> it3;
                        boolean bl4 = false;
                        it3.invoke((Object)session, (Object)node, (Object)service);
                    }
                    logForThisNode2.logMessage(LogLevel.INFO, "\u5f00\u59cb\u4f9d\u8d56\u73af\u5883\u68c0\u67e5\uff0c\u5305\u62ec\u6743\u9650\uff0c\u57fa\u7840\u8bbe\u65bd\u7b49...", null);
                    this.environmentCheck(session, node, service, logForThisNode2);
                    logForThisNode2.logMessage(LogLevel.DEBUG, "\u68c0\u67e5\u662f\u5426\u9700\u8981\u90e8\u7f72", null);
                    if (!restart && this.targetAlreadyDeploy(session, deployment)) {
                        logForThisNode2.logMessage(LogLevel.INFO, "node:" + node.getIp() + " already deployed (\u5982\u679c\u9700\u8981\u91cd\u65b0\u90e8\u7f72\u53ef\u901a\u8fc7 restart \u6307\u4ee4)", null);
                    } else {
                        ServiceNode it4;
                        boolean il = node.getIngressLess();
                        nodeStageChanger.invoke((Object)node, (Object)NodeDeployStage.SuspendIngress);
                        if (!il) {
                            logForThisNode2.logMessage(LogLevel.INFO, "\u505c\u6b62\u6d41\u91cf\u8fdb\u5165\u2026\u2026", null);
                            Iterable $this$forEach$iv2 = entrances;
                            boolean $i$f$forEach2 = false;
                            for (Object element$iv : $this$forEach$iv2) {
                                IngressEntrance entrance = (IngressEntrance)element$iv;
                                boolean bl5 = false;
                                if ((ServiceNode)findMatchNode2.invoke((Object)entrance, (Object)node) == null) continue;
                                boolean bl6 = false;
                                ServiceDeployer.runInNode$default(this, "\u505c\u6b62" + entrance.getIngressName() + "\u6d41\u91cf\u8fdb\u5165", it4, logForThisNode2, (Function0)new Function0<Unit>(logForThisNode2, entrance, it4){
                                    final /* synthetic */ deploy.logForThisNode.1 $logForThisNode;
                                    final /* synthetic */ IngressEntrance $entrance;
                                    final /* synthetic */ ServiceNode $it;
                                    {
                                        this.$logForThisNode = $logForThisNode;
                                        this.$entrance = $entrance;
                                        this.$it = $it;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        while (true) {
                                            try {
                                                this.$logForThisNode.logMessage(LogLevel.TRACE, "\u6267\u884c\u505c\u6b62" + this.$entrance.getIngressName() + "\u6d41\u91cf\u8fdb\u5165", null);
                                                this.$entrance.suspendNode(this.$it, this.$logForThisNode);
                                            }
                                            catch (Exception e) {
                                                this.$logForThisNode.logMessage(LogLevel.TRACE, "\u5c1d\u8bd5\u505c\u6b62\u6d41\u91cf\u65f6", e);
                                                Thread.sleep(3000L);
                                                continue;
                                            }
                                            break;
                                        }
                                    }
                                }, 3L, TimeUnit.MINUTES, false, 64, null);
                            }
                            nodeStageChanger.invoke((Object)node, (Object)NodeDeployStage.CheckIngress);
                            logForThisNode2.logMessage(LogLevel.DEBUG, "\u68c0\u67e5\u6d41\u91cf\u662f\u5426\u5df2\u7ecf\u8d70\u5b8c", null);
                            ServiceDeployer.runInNode$default(this, "\u68c0\u67e5\u6d41\u91cf\u662f\u5426\u8d70\u5b8c", node, logForThisNode2, (Function0)new Function0<Unit>(this, node, logForThisNode2, session){
                                final /* synthetic */ ServiceDeployer this$0;
                                final /* synthetic */ ServiceNode $node;
                                final /* synthetic */ deploy.logForThisNode.1 $logForThisNode;
                                final /* synthetic */ ClientSession $session;
                                {
                                    this.this$0 = $receiver;
                                    this.$node = $node;
                                    this.$logForThisNode = $logForThisNode;
                                    this.$session = $session;
                                    super(0);
                                }

                                public final void invoke() {
                                    Duration duration = ServiceDeployer.access$getSleepAfterSuspend$p(this.this$0);
                                    if (duration != null) {
                                        Duration duration2 = duration;
                                        deploy.logForThisNode.1 var3_2 = this.$logForThisNode;
                                        Duration it = duration2;
                                        boolean bl = false;
                                        var3_2.logMessage(LogLevel.INFO, "\u68c0\u67e5\u5177\u4f53\u6d41\u91cf\u524d\uff0c\u5148\u7b49\u4e0a:" + it, null);
                                        Thread.sleep(it.toMillis());
                                    }
                                    while (true) {
                                        try {
                                            String cmd = "ss -an |grep \"" + this.$node.getIp() + ':' + this.$node.getPort() + "\"|grep ESTAB";
                                            this.$logForThisNode.logMessage(LogLevel.TRACE, "\u51c6\u5907\u6267\u884c:" + cmd, null);
                                            this.$session.executeRemoteCommand(cmd);
                                            this.$logForThisNode.logMessage(LogLevel.TRACE, cmd + " \u6210\u529f\u6267\u884c", null);
                                            Thread.sleep(5000L);
                                        }
                                        catch (RemoteException e) {
                                            this.$logForThisNode.logMessage(LogLevel.TRACE, "\u68c0\u67e5\u6d41\u91cf", e);
                                            return;
                                        }
                                    }
                                }
                            }, 4L, TimeUnit.MINUTES, false, 64, null);
                        }
                        nodeStageChanger.invoke((Object)node, (Object)NodeDeployStage.Execute);
                        logForThisNode2.logMessage(LogLevel.INFO, "\u6267\u884c\u90e8\u7f72\u6307\u4ee4...", null);
                        this.runInNode("\u6267\u884c\u90e8\u7f72", node, logForThisNode2, (Function0)new Function0<String>(service, node, deployment, logForThisNode2, session){
                            final /* synthetic */ Service $service;
                            final /* synthetic */ ServiceNode $node;
                            final /* synthetic */ Deployment $deployment;
                            final /* synthetic */ deploy.logForThisNode.1 $logForThisNode;
                            final /* synthetic */ ClientSession $session;
                            {
                                this.$service = $service;
                                this.$node = $node;
                                this.$deployment = $deployment;
                                this.$logForThisNode = $logForThisNode;
                                this.$session = $session;
                                super(0);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Nullable
                            public final String invoke() {
                                Map<String, String> map;
                                block6: {
                                    block5: {
                                        void $this$filterTo$iv$iv;
                                        void $this$filter$iv;
                                        map = this.$service.getEnvironment();
                                        if (map == null) break block5;
                                        Map<String, String> stringStringMap = map;
                                        boolean bl = false;
                                        Iterable iterable = stringStringMap.entrySet();
                                        boolean $i$f$filter = false;
                                        void var7_5 = $this$filter$iv;
                                        Collection destination$iv$iv = new ArrayList<E>();
                                        boolean $i$f$filterTo = false;
                                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                                            Map.Entry it = (Map.Entry)element$iv$iv;
                                            boolean bl2 = false;
                                            boolean bl3 = ((CharSequence)it.getKey()).length() > 0 && ((CharSequence)it.getValue()).length() > 0;
                                            if (!bl3) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, (Function1)deploy.4.1.withEnv.1.2.INSTANCE, (int)30, null);
                                        map = string;
                                        if (string != null) break block6;
                                    }
                                    map = "";
                                }
                                Map<String, String> withEnv2 = map;
                                StringBuilder stringBuilder = new StringBuilder().append(this.$service.getDeployCommand()).append(' ').append(this.$service.getId()).append(' ').append(this.$node.getIp()).append(' ').append(this.$node.getPort()).append(' ').append(this.$deployment.getImageUrl()).append(' ').append(this.$deployment.getImageTag()).append(' ');
                                String string = this.$service.getType();
                                if (string == null) {
                                    string = "\"\"";
                                }
                                String cmd = stringBuilder.append(string).append((String)((Object)withEnv2)).toString();
                                this.$logForThisNode.logMessage(LogLevel.TRACE, "\u51c6\u5907\u6267\u884c:" + cmd, null);
                                return this.$session.executeRemoteCommand(cmd, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM, StandardCharsets.US_ASCII);
                            }
                        }, 5L, TimeUnit.MINUTES, true);
                        nodeStageChanger.invoke((Object)node, (Object)NodeDeployStage.HealthCheck);
                        logForThisNode2.logMessage(LogLevel.INFO, "\u6267\u884c\u5065\u5eb7\u68c0\u67e5...", null);
                        ServiceDeployer.runInNode$default(this, "\u5065\u5eb7\u68c0\u67e5", node, logForThisNode2, (Function0)new Function0<Unit>(service, node, logForThisNode2, session){
                            final /* synthetic */ Service $service;
                            final /* synthetic */ ServiceNode $node;
                            final /* synthetic */ deploy.logForThisNode.1 $logForThisNode;
                            final /* synthetic */ ClientSession $session;
                            {
                                this.$service = $service;
                                this.$node = $node;
                                this.$logForThisNode = $logForThisNode;
                                this.$session = $session;
                                super(0);
                            }

                            public final void invoke() {
                                HealthCheck hc = this.$service.getHealthCheck();
                                String cmd = hc.toHealthCheckCommand(this.$node);
                                while (true) {
                                    this.$logForThisNode.logMessage(LogLevel.TRACE, "\u51c6\u5907\u6267\u884c:" + cmd, null);
                                    try {
                                        String data = this.$session.executeRemoteCommand(cmd);
                                        if (hc.checkHealth(data, 0)) break;
                                        Thread.sleep(3000L);
                                    }
                                    catch (RemoteException e) {
                                        this.$logForThisNode.logMessage(LogLevel.TRACE, "\u5065\u5eb7\u68c0\u67e5\u9519\u8bef:" + e.getMessage(), null);
                                        if (hc.checkHealth(null, 1)) break;
                                        Thread.sleep(3000L);
                                    }
                                }
                            }
                        }, 6L, TimeUnit.MINUTES, false, 64, null);
                        if (!il) {
                            nodeStageChanger.invoke((Object)node, (Object)NodeDeployStage.ResumeIngress);
                            logForThisNode2.logMessage(LogLevel.INFO, "\u6062\u590d\u6d41\u91cf\u8fdb\u5165...", null);
                            Iterable $this$forEach$iv3 = entrances;
                            boolean $i$f$forEach3 = false;
                            for (Object element$iv : $this$forEach$iv3) {
                                IngressEntrance entrance = (IngressEntrance)element$iv;
                                boolean bl7 = false;
                                if ((ServiceNode)findMatchNode2.invoke((Object)entrance, (Object)node) == null) continue;
                                boolean bl8 = false;
                                ServiceDeployer.runInNode$default(this, "\u6062\u590d" + entrance.getIngressName() + "\u6d41\u91cf\u8fdb\u5165", it4, logForThisNode2, (Function0)new Function0<Unit>(logForThisNode2, entrance, it4){
                                    final /* synthetic */ deploy.logForThisNode.1 $logForThisNode;
                                    final /* synthetic */ IngressEntrance $entrance;
                                    final /* synthetic */ ServiceNode $it;
                                    {
                                        this.$logForThisNode = $logForThisNode;
                                        this.$entrance = $entrance;
                                        this.$it = $it;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        while (true) {
                                            try {
                                                this.$logForThisNode.logMessage(LogLevel.TRACE, "\u6267\u884c\u6062\u590d" + this.$entrance.getIngressName() + "\u6d41\u91cf\u8fdb\u5165", null);
                                                this.$entrance.resumedNode(this.$it, this.$logForThisNode);
                                            }
                                            catch (Exception e) {
                                                this.$logForThisNode.logMessage(LogLevel.TRACE, "\u5c1d\u8bd5\u6062\u590d\u6d41\u91cf\u65f6", e);
                                                Thread.sleep(3000L);
                                                continue;
                                            }
                                            break;
                                        }
                                    }
                                }, 3L, TimeUnit.MINUTES, false, 64, null);
                            }
                            nodeStageChanger.invoke((Object)node, (Object)NodeDeployStage.Post);
                            logForThisNode2.logMessage(LogLevel.INFO, "\u68c0\u67e5\u6d41\u91cf\u662f\u5426\u8fdb\u5165...", null);
                            $this$forEach$iv3 = entrances;
                            $i$f$forEach3 = false;
                            for (Object element$iv : $this$forEach$iv3) {
                                IngressEntrance entrance = (IngressEntrance)element$iv;
                                boolean bl9 = false;
                                if ((ServiceNode)findMatchNode2.invoke((Object)entrance, (Object)node) == null) continue;
                                boolean bl10 = false;
                                ServiceDeployer.runInNode$default(this, "\u68c0\u67e5" + entrance.getIngressName() + "\u6d41\u91cf\u662f\u5426\u53ef\u4ee5\u6b63\u5e38\u8fdb\u5165\u4e86", it4, logForThisNode2, (Function0)new Function0<Unit>(logForThisNode2, entrance, it4){
                                    final /* synthetic */ deploy.logForThisNode.1 $logForThisNode;
                                    final /* synthetic */ IngressEntrance $entrance;
                                    final /* synthetic */ ServiceNode $it;
                                    {
                                        this.$logForThisNode = $logForThisNode;
                                        this.$entrance = $entrance;
                                        this.$it = $it;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        while (true) {
                                            this.$logForThisNode.logMessage(LogLevel.TRACE, "\u6267\u884c\u68c0\u67e5" + this.$entrance.getIngressName() + "\u6d41\u91cf\u662f\u5426\u53ef\u4ee5\u6b63\u5e38\u8fdb\u5165", null);
                                            if (this.$entrance.checkWorkStatus(this.$it, this.$logForThisNode)) break;
                                            Thread.sleep(3000L);
                                        }
                                    }
                                }, 6L, TimeUnit.MINUTES, false, 64, null);
                            }
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                ingressEntrance = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            nodeStageChanger.invoke((Object)node, (Object)NodeDeployStage.Done);
        }
        logForService.logMessage(LogLevel.INFO, service.getId() + "\u5df2\u5b8c\u6210\u90e8\u7f72", null);
    }

    public static /* synthetic */ void deploy$default(ServiceDeployer serviceDeployer, Service service, Collection collection, Deployment deployment, LoggingApi loggingApi, Function4 function4, Function1 function1, Function2 function2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            Slf4j.Companion companion = Slf4j.Companion;
            ServiceDeployer $this$log$iv = serviceDeployer;
            boolean $i$f$getLog = false;
            Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            loggingApi = SKt.toLoggingApi(logger);
        }
        if ((n & 0x10) != 0) {
            function4 = (Function4)new Function4<ServiceNode, LogLevel, String, Throwable, Unit>(loggingApi){
                final /* synthetic */ LoggingApi $logForService;
                {
                    this.$logForService = $logForService;
                    super(4);
                }

                public final void invoke(@NotNull ServiceNode node, @NotNull LogLevel level, @NotNull String message, @Nullable Throwable t) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    this.$logForService.logMessage(level, node.getIp() + ':' + node.getPort() + ' ' + message, t);
                }
            };
        }
        if ((n & 0x20) != 0) {
            function1 = (Function1)new Function1<List<? extends ServiceNode>, Unit>(serviceDeployer){
                final /* synthetic */ ServiceDeployer this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull List<? extends ServiceNode> nodes) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                    Slf4j.Companion companion = Slf4j.Companion;
                    ServiceDeployer $this$log$iv = this.this$0;
                    boolean $i$f$getLog22 = false;
                    Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                    Iterable this_$iv = nodes;
                    String string = "\u5373\u5c06\u90e8\u7f72\u5230:{}";
                    Logger logger2 = logger;
                    boolean $i$f$map = false;
                    void $i$f$getLog22 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ServiceNode serviceNode = (ServiceNode)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getIp() + ':' + it.getPort());
                    }
                    collection = (List)destination$iv$iv;
                    logger2.info(string, (Object)collection);
                }
            };
        }
        if ((n & 0x40) != 0) {
            function2 = (Function2)new Function2<ServiceNode, NodeDeployStage, Unit>(serviceDeployer){
                final /* synthetic */ ServiceDeployer this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull ServiceNode node, @NotNull NodeDeployStage stage) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
                    Slf4j.Companion companion = Slf4j.Companion;
                    ServiceDeployer $this$log$iv = this.this$0;
                    boolean $i$f$getLog = false;
                    Logger logger = LoggerFactory.getLogger(ServiceDeployer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                    logger.info(node.getIp() + ':' + node.getPort() + "\u5df2\u7ecf\u5230\u4e86:{}", (Object)((Object)stage));
                }
            };
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        serviceDeployer.deploy(service, collection, deployment, loggingApi, (Function4<? super ServiceNode, ? super LogLevel, ? super String, ? super Throwable, Unit>)function4, (Function1<? super List<? extends ServiceNode>, Unit>)function1, (Function2<? super ServiceNode, ? super NodeDeployStage, Unit>)function2, bl);
    }

    private final void environmentCheck(ClientSession session, ServiceNode node, Service service, LoggingApi loggingApi) {
        ServiceDeployer.runInNode$default(this, "\u4f9d\u8d56\u73af\u5883\u68c0\u67e5", node, loggingApi, (Function0)new Function0<Unit>(session, loggingApi, node, service){
            final /* synthetic */ ClientSession $session;
            final /* synthetic */ LoggingApi $loggingApi;
            final /* synthetic */ ServiceNode $node;
            final /* synthetic */ Service $service;
            {
                this.$session = $session;
                this.$loggingApi = $loggingApi;
                this.$node = $node;
                this.$service = $service;
                super(0);
            }

            public final void invoke() {
                try {
                    String docker = this.$session.executeRemoteCommand("docker -v");
                    this.$loggingApi.logMessage(LogLevel.DEBUG, "docker:" + docker, null);
                }
                catch (Exception e) {
                    throw new NodeRelatedIllegalStateException(this.$node, "\u7f3a\u5c11 docker,\u6216\u8005\u7f3a\u5c11\u6267\u884c\u7684\u6743\u9650", null, 4, null);
                }
                try {
                    String curl = this.$session.executeRemoteCommand("curl --version");
                    this.$loggingApi.logMessage(LogLevel.DEBUG, "curl:" + curl, null);
                }
                catch (Exception e) {
                    throw new NodeRelatedIllegalStateException(this.$node, "\u7f3a\u5c11 curl", null, 4, null);
                }
                try {
                    String ss = this.$session.executeRemoteCommand("ss -v");
                    this.$loggingApi.logMessage(LogLevel.DEBUG, "ss " + ss, null);
                }
                catch (Exception e) {
                    throw new NodeRelatedIllegalStateException(this.$node, "\u7f3a\u5c11 ss", null, 4, null);
                }
                try {
                    String dc = this.$session.executeRemoteCommand("command -v " + this.$service.getDeployCommand());
                    this.$loggingApi.logMessage(LogLevel.DEBUG, "command " + dc, null);
                }
                catch (Exception e) {
                    throw new NodeRelatedIllegalStateException(this.$node, "\u7f3a\u5c11\u53ef\u6267\u884c\u7684" + this.$service.getDeployCommand(), null, 4, null);
                }
            }
        }, 10L, null, false, 96, null);
    }

    private final boolean targetAlreadyDeploy(ClientSession session, Deployment deployment) {
        try {
            session.executeRemoteCommand("docker ps|grep " + deployment.getImageUrl() + ':' + deployment.getImageTag());
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final <T> T runInNode(String taskName, ServiceNode node, LoggingApi loggingApi, Function0<? extends T> func, long timeout, TimeUnit unit, boolean allowTimeout) {
        Future<Object> future = this.executorService.submit(() -> ServiceDeployer.runInNode$lambda$12(func));
        try {
            return (T)future.get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw new NodeRelatedIllegalStateException(node, e.getMessage(), e.getCause());
        }
        catch (TimeoutException e) {
            if (allowTimeout) {
                loggingApi.logMessage(LogLevel.INFO, "\u6267\u884c" + taskName + "\u65f6\u8d85\u65f6,\u4f46\u6709\u53ef\u80fd\u662f\u6b63\u5e38\u60c5\u51b5", null);
                return null;
            }
            future.cancel(true);
            throw new NodeRelatedIllegalStateException(node, "\u6267\u884c" + taskName + "\u65f6\u8d85\u65f6", e);
        }
    }

    static /* synthetic */ Object runInNode$default(ServiceDeployer serviceDeployer, String string, ServiceNode serviceNode, LoggingApi loggingApi, Function0 function0, long l, TimeUnit timeUnit, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        return serviceDeployer.runInNode(string, serviceNode, loggingApi, function0, l, timeUnit, bl);
    }

    private static final Object runInNode$lambda$12(Function0 $func) {
        Intrinsics.checkNotNullParameter((Object)$func, (String)"$func");
        return $func.invoke();
    }

    public static final /* synthetic */ Duration access$getSleepAfterSuspend$p(ServiceDeployer $this) {
        return $this.sleepAfterSuspend;
    }
}

