/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.test.solitary;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wix.mysql.EmbeddedMysql;
import com.wix.mysql.Sources;
import com.wix.mysql.SqlScriptSource;
import com.wix.mysql.config.AdditionalConfig;
import com.wix.mysql.config.Charset;
import com.wix.mysql.config.DownloadConfig;
import com.wix.mysql.config.MysqldConfig;
import com.wix.mysql.distribution.Version;
import io.github.caijiang.common.test.solitary.RedisServerEntry;
import io.github.caijiang.common.test.solitary.SolitaryHelper;
import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jdbc.datasource.init.ScriptUtils;
import org.springframework.util.StringUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013JA\u0010\u0014\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0007J\b\u0010\u001e\u001a\u00020\u001aH\u0002JA\u0010\u001f\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010 \u001a\u0004\u0018\u00010\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J-\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\"2\u0016\b\u0002\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00170$H\u0000\u00a2\u0006\u0002\b%R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/github/caijiang/common/test/solitary/SolitaryHelper;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mysqlInstance", "Ljava/io/Closeable;", "redisServer", "Lio/github/caijiang/common/test/solitary/RedisServerEntry;", "createMysql", "version", "Lcom/wix/mysql/distribution/Version;", "serverConfigBuilderFunction", "Ljava/util/function/Function;", "Lcom/wix/mysql/config/MysqldConfig$Builder;", "initScripts", "", "Lcom/wix/mysql/SqlScriptSource;", "(Lcom/wix/mysql/distribution/Version;Ljava/util/function/Function;[Lcom/wix/mysql/SqlScriptSource;)Ljava/io/Closeable;", "createMysqlOrProvided", "createRedis", "noEmptyButCanBeNullPassword", "", "createRedisServer", "port", "", "password", "currentMysqlDatasource", "Ljavax/sql/DataSource;", "freePort", "mysql", "redis", "runInAliyunFlow", "", "toEnv", "Lkotlin/Function1;", "runInAliyunFlow$common_ext", "common-ext"})
@SourceDebugExtension(value={"SMAP\nSolitaryHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolitaryHelper.kt\nio/github/caijiang/common/test/solitary/SolitaryHelper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,357:1\n13309#2,2:358\n1603#3,9:360\n1855#3:369\n1856#3:371\n1612#3:372\n1#4:370\n*S KotlinDebug\n*F\n+ 1 SolitaryHelper.kt\nio/github/caijiang/common/test/solitary/SolitaryHelper\n*L\n195#1:358,2\n326#1:360,9\n326#1:369\n326#1:371\n326#1:372\n326#1:370\n*E\n"})
public final class SolitaryHelper {
    @NotNull
    public static final SolitaryHelper INSTANCE = new SolitaryHelper();
    @Nullable
    private static volatile Closeable mysqlInstance;
    @Nullable
    private static volatile RedisServerEntry redisServer;
    private static final Logger log;

    private SolitaryHelper() {
    }

    @JvmStatic
    @NotNull
    public static final Closeable mysql(@Nullable Version version, @Nullable Function<MysqldConfig.Builder, MysqldConfig.Builder> serverConfigBuilderFunction, SqlScriptSource ... initScripts) {
        Intrinsics.checkNotNullParameter((Object)initScripts, (String)"initScripts");
        if (mysqlInstance != null) {
            Closeable closeable = mysqlInstance;
            Intrinsics.checkNotNull((Object)closeable);
            return closeable;
        }
        Closeable target = SolitaryHelper.createMysqlOrProvided(version, serverConfigBuilderFunction, Arrays.copyOf(initScripts, initScripts.length));
        Closeable closeable = mysqlInstance = () -> SolitaryHelper.mysql$lambda$0(target);
        Intrinsics.checkNotNull((Object)closeable);
        return closeable;
    }

    @JvmStatic
    @Nullable
    public static final RedisServerEntry redis(@Nullable String noEmptyButCanBeNullPassword) {
        if (redisServer != null) {
            return redisServer;
        }
        redisServer = SolitaryHelper.createRedis(noEmptyButCanBeNullPassword);
        return redisServer;
    }

    @JvmStatic
    @NotNull
    public static final RedisServerEntry createRedis(@Nullable String noEmptyButCanBeNullPassword) {
        try {
            int port = INSTANCE.freePort();
            String string = noEmptyButCanBeNullPassword;
            if (string == null) {
                string = RandomStringUtils.randomNumeric((int)6);
            }
            String password = string;
            Intrinsics.checkNotNull((Object)password);
            RedisServerEntry ss = INSTANCE.createRedisServer(port, password);
            System.setProperty("redis.port", String.valueOf(port));
            System.setProperty("redis.password", password);
            ss.start();
            Thread thread = new Thread(() -> SolitaryHelper.createRedis$lambda$1(ss));
            thread.setDaemon(true);
            Runtime.getRuntime().addShutdownHook(thread);
            return ss;
        }
        catch (Exception e) {
            log.error("\u542f\u52a8\u5185\u7f6eredis \u5b9e\u4f8b", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private final RedisServerEntry createRedisServer(int port, String password) {
        Class<?> clazz;
        try {
            clazz = Class.forName("redis.embedded.core.RedisServerBuilder");
        }
        catch (Throwable e) {
            clazz = Class.forName("redis.embedded.RedisServerBuilder");
        }
        Class<?> type = clazz;
        try {
            Method portMethod2 = (Method)Arrays.stream(type.getDeclaredMethods()).filter(arg_0 -> SolitaryHelper.createRedisServer$lambda$2(createRedisServer.portMethod.1.INSTANCE, arg_0)).findFirst().orElseThrow(SolitaryHelper::createRedisServer$lambda$3);
            Class[] classArray = new Class[]{String.class};
            Method settingMethod = type.getDeclaredMethod("setting", classArray);
            Method buildMethod = type.getDeclaredMethod("build", new Class[0]);
            Object builder = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Object[] objectArray = new Object[]{port};
            builder = portMethod2.invoke(builder, objectArray);
            objectArray = new Object[]{"requirepass " + password};
            builder = settingMethod.invoke(builder, objectArray);
            Object object = buildMethod.invoke(builder, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
            return new RedisServerEntry(object);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final Closeable createMysqlOrProvided(@Nullable Version version, @Nullable Function<MysqldConfig.Builder, MysqldConfig.Builder> serverConfigBuilderFunction, SqlScriptSource ... initScripts) {
        String string;
        String username;
        String string2;
        String port;
        Intrinsics.checkNotNullParameter((Object)initScripts, (String)"initScripts");
        String string3 = System.getenv("provided_mysql_host");
        if (string3 == null) {
            return SolitaryHelper.createMysql(version, serverConfigBuilderFunction, Arrays.copyOf(initScripts, initScripts.length));
        }
        String host = string3;
        String string4 = System.getenv("provided_mysql_database");
        if (string4 == null) {
            return SolitaryHelper.createMysql(version, serverConfigBuilderFunction, Arrays.copyOf(initScripts, initScripts.length));
        }
        String database = string4;
        String string5 = System.getenv("provided_mysql_port");
        if (string5 == null) {
            string5 = port = "3306";
        }
        if ((string2 = System.getenv("provided_mysql_username")) == null) {
            string2 = username = "root";
        }
        if ((string = System.getenv("provided_mysql_password")) == null) {
            string = "";
        }
        String password = string;
        log.info("use provided mysql @:{}", (Object)host);
        System.setProperty("mysql.host", host);
        System.setProperty("mysql.port", port);
        System.setProperty("mysql.username", username);
        System.setProperty("mysql.password", password);
        System.setProperty("mysql.database", database);
        DataSource dataSource = INSTANCE.currentMysqlDatasource();
        AutoCloseable autoCloseable = dataSource.getConnection();
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            SqlScriptSource[] $this$forEach$iv = initScripts;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String string6;
                SqlScriptSource element$iv;
                SqlScriptSource it = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.read(), (String)"read(...)");
                java.nio.charset.Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = string6.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                ScriptUtils.executeSqlScript((Connection)connection, (Resource)((Resource)new ByteArrayResource(byArray)));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return SolitaryHelper::createMysqlOrProvided$lambda$6;
    }

    @JvmStatic
    @NotNull
    public static final Closeable createMysql(@Nullable Version version, @Nullable Function<MysqldConfig.Builder, MysqldConfig.Builder> serverConfigBuilderFunction, SqlScriptSource ... initScripts) {
        Intrinsics.checkNotNullParameter((Object)initScripts, (String)"initScripts");
        try {
            Version version2;
            Function<MysqldConfig.Builder, MysqldConfig.Builder> scf;
            Function<Object, Object> function = serverConfigBuilderFunction;
            if (function == null) {
                function = scf = Function.identity();
            }
            if ((version2 = version) == null) {
                version2 = Version.v5_7_latest;
            }
            MysqldConfig config = scf.apply(MysqldConfig.aMysqldConfig((Version)version2).withCharset(Charset.UTF8).withFreePort().withTimeZone("Asia/Shanghai").withServerVariable("max_connect_errors", 666).withServerVariable("lower_case_table_names", 2).withServerVariable("innodb_use_native_aio", false).withServerVariable("innodb_rollback_on_timeout", true).withServerVariable("innodb_lock_wait_timeout", 4).withServerVariable("skip-log-bin", true).withServerVariable("skip_log_bin", true).withServerVariable("disable_log_bin", true)).build();
            System.setProperty("mysql.port", String.valueOf(config.getPort()));
            String database = "database";
            EmbeddedMysql.Builder builder = EmbeddedMysql.anEmbeddedMysql((MysqldConfig)config, (AdditionalConfig[])new AdditionalConfig[0]).addSchema(database, Arrays.copyOf(initScripts, initScripts.length));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"addSchema(...)");
            EmbeddedMysql.Builder builder2 = builder;
            List aliFlowCaches = SolitaryHelper.runInAliyunFlow$common_ext$default(INSTANCE, null, 1, null);
            Collection collection = aliFlowCaches;
            if (!(collection == null || collection.isEmpty())) {
                EmbeddedMysql.Builder builder3 = builder2.withDownloadConfig(DownloadConfig.aDownloadConfig().withCacheDir((String)CollectionsKt.last((List)aliFlowCaches) + "/mysql").build());
                Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"withDownloadConfig(...)");
                builder2 = builder3;
            } else {
                String dir = System.getenv("CI_PROJECT_DIR");
                if (StringUtils.hasLength((String)dir)) {
                    EmbeddedMysql.Builder builder4 = builder2.withDownloadConfig(DownloadConfig.aDownloadConfig().withCacheDir(dir + "/mysql").build());
                    Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"withDownloadConfig(...)");
                    builder2 = builder4;
                }
            }
            EmbeddedMysql instance = builder2.start();
            String username = "username";
            String password = "password";
            SqlScriptSource[] sqlScriptSourceArray = new SqlScriptSource[]{Sources.fromString((String)("create user '" + username + "'@'%' IDENTIFIED by '" + password + '\'')), Sources.fromString((String)("grant all on *.* to '" + username + "'@'%'"))};
            instance.executeScripts("information_schema", sqlScriptSourceArray);
            System.setProperty("mysql.host", "localhost");
            System.setProperty("mysql.database", database);
            System.setProperty("mysql.username", username);
            System.setProperty("mysql.password", password);
            Thread thread = new Thread(() -> SolitaryHelper.createMysql$lambda$7(instance));
            thread.setDaemon(true);
            Runtime.getRuntime().addShutdownHook(thread);
            return () -> SolitaryHelper.createMysql$lambda$8(instance);
        }
        catch (Exception e) {
            log.error("\u542f\u52a8\u5185\u7f6emysql \u5b9e\u4f8b", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<String> runInAliyunFlow$common_ext(@NotNull Function1<? super String, String> toEnv) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(toEnv, (String)"toEnv");
        if (toEnv.invoke((Object)"CI_RUNTIME_VERSION") == null) {
            return null;
        }
        String caches = (String)toEnv.invoke((Object)"caches");
        if (!StringUtils.hasText((String)caches)) {
            return null;
        }
        JsonNode jsonNode = new ObjectMapper().readTree(caches);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
        Iterable $this$mapNotNull$iv = (Iterable)jsonNode;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JsonNode it = (JsonNode)element$iv$iv;
            boolean bl2 = false;
            if ((it.isTextual() ? it.textValue() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List runInAliyunFlow$common_ext$default(SolitaryHelper solitaryHelper, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = runInAliyunFlow.1.INSTANCE;
        }
        return solitaryHelper.runInAliyunFlow$common_ext((Function1<? super String, String>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int freePort() {
        Closeable closeable = new ServerSocket(0);
        Throwable throwable = null;
        try {
            ServerSocket socket = (ServerSocket)closeable;
            boolean bl = false;
            socket.setReuseAddress(true);
            int n = socket.getLocalPort();
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @JvmStatic
    @NotNull
    public static final DataSource currentMysqlDatasource() {
        String string = System.getProperty("mysql.port");
        if (string == null) {
            throw new IllegalStateException("\u6ca1\u6709\u8c03\u7528\u8fc7 SolitaryHelper.createMysql");
        }
        String $this$currentMysqlDatasource_u24lambda_u2411 = string = new DriverManagerDataSource("jdbc:mysql://" + System.getProperty("mysql.host", "localhost") + ':' + string + '/' + System.getProperty("mysql.database"), System.getProperty("mysql.username"), System.getProperty("mysql.password"));
        boolean bl = false;
        $this$currentMysqlDatasource_u24lambda_u2411.setDriverClassName("com.mysql.jdbc.Driver");
        return (DataSource)((Object)string);
    }

    private static final void mysql$lambda$0(Closeable $target) {
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        $target.close();
        mysqlInstance = null;
    }

    private static final void createRedis$lambda$1(RedisServerEntry $ss) {
        Intrinsics.checkNotNullParameter((Object)$ss, (String)"$ss");
        log.info("try to stop redis");
        try {
            $ss.stop();
        }
        catch (Throwable e) {
            log.warn("when stop", e);
        }
    }

    private static final boolean createRedisServer$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final IllegalStateException createRedisServer$lambda$3() {
        return new IllegalStateException("\u627e\u4e0d\u5230 port \u65b9\u6cd5");
    }

    private static final void createMysqlOrProvided$lambda$6() {
    }

    private static final void createMysql$lambda$7(EmbeddedMysql $instance) {
        log.info("try to stop mysql");
        try {
            $instance.stop();
        }
        catch (Throwable e) {
            log.warn("when stop mysql", e);
        }
    }

    private static final void createMysql$lambda$8(EmbeddedMysql $instance) {
        $instance.stop();
    }

    static {
        log = LoggerFactory.getLogger(INSTANCE.getClass());
    }
}

