/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.lock;

import io.github.caijiang.common.lock.AutoLock;
import io.github.caijiang.common.lock.Evaluator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KAnnotatedElements;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.Ordered;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.util.StringUtils;

@Configuration
@EnableAspectJAutoProxy
@Aspect
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0007J \u0010\u0017\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010\u001b\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/caijiang/common/lock/AutoLockConfig;", "Lorg/springframework/core/Ordered;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Lorg/springframework/context/ApplicationContext;)V", "evaluator", "Lio/github/caijiang/common/lock/Evaluator;", "lockRegistry", "Lorg/springframework/integration/support/locks/LockRegistry;", "lockerNamePrefix", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "aroundAutoLock", "", "pjp", "Lorg/aspectj/lang/ProceedingJoinPoint;", "forAutoLock", "", "getOrder", "", "init", "multiLock", "inputLockers", "", "toLockerStrings", "point", "common-ext"})
@SourceDebugExtension(value={"SMAP\nAutoLockConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoLockConfig.kt\nio/github/caijiang/common/lock/AutoLockConfig\n+ 2 BeanFactoryExtensions.kt\norg/springframework/beans/factory/BeanFactoryExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n28#2:114\n1549#3:115\n1620#3,3:116\n*S KotlinDebug\n*F\n+ 1 AutoLockConfig.kt\nio/github/caijiang/common/lock/AutoLockConfig\n*L\n32#1:114\n101#1:115\n101#1:116,3\n*E\n"})
public class AutoLockConfig
implements Ordered {
    private final Logger log;
    @NotNull
    private final LockRegistry lockRegistry;
    @NotNull
    private final String lockerNamePrefix;
    @NotNull
    private final Evaluator evaluator;

    /*
     * WARNING - void declaration
     */
    public AutoLockConfig(@NotNull ApplicationContext applicationContext) {
        LockRegistry lockRegistry;
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.log = LoggerFactory.getLogger(AutoLockConfig.class);
        AutoLockConfig autoLockConfig = this;
        try {
            AutoLockConfig autoLockConfig2 = autoLockConfig;
            BeanFactory $this$getBean$iv = (BeanFactory)applicationContext;
            boolean $i$f$getBean = false;
            Object object = $this$getBean$iv.getBean(LockRegistry.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getBean(T::class.java)");
            lockRegistry = (LockRegistry)object;
        }
        catch (Exception $i$f$getBean) {
            void e;
            AutoLockConfig autoLockConfig3 = autoLockConfig;
            throw new IllegalStateException("consider add spring-boot-starter-data-redis or spring-integration-redis into your project to create LockRegistry bean", (Throwable)e);
        }
        autoLockConfig2.lockRegistry = lockRegistry;
        this.lockerNamePrefix = "AO";
        this.evaluator = new Evaluator((BeanFactory)applicationContext);
    }

    @PostConstruct
    public final void init() {
        try {
            Lock key = this.lockRegistry.obtain((Object)(this.lockerNamePrefix + "-HC"));
            this.log.info("current lock implements is " + key.getClass().getSimpleName());
            key.lock();
            key.unlock();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getOrder() {
        return -2147483643;
    }

    @Pointcut(value="@annotation(AutoLock)||@annotation(AutoLocks)")
    public final void forAutoLock() {
    }

    @Around(value="forAutoLock()")
    @Nullable
    public final Object aroundAutoLock(@NotNull ProceedingJoinPoint pjp) {
        Intrinsics.checkNotNullParameter((Object)pjp, (String)"pjp");
        List<String> lockers = this.toLockerStrings(pjp);
        if (this.log.isDebugEnabled()) {
            this.log.debug("prepare into LOCK method:" + pjp.toShortString() + " with lockers:" + String.join((CharSequence)",", (Iterable<? extends CharSequence>)lockers));
        }
        return this.multiLock(CollectionsKt.toList((Iterable)CollectionsKt.toSet((Iterable)lockers)), pjp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object multiLock(List<String> inputLockers, ProceedingJoinPoint pjp) {
        List currentLockers = CollectionsKt.toMutableList((Collection)inputLockers);
        String string = ((String)CollectionsKt.removeFirst((List)currentLockers)).intern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intern(...)");
        String lockStr = string;
        Lock locker = this.lockRegistry.obtain((Object)lockStr);
        this.log.debug(Thread.currentThread().getName() + " entering LOCK method:" + pjp.toShortString() + " with locker instance: " + lockStr);
        locker.lock();
        try {
            Object object = currentLockers.isEmpty() ? pjp.proceed() : this.multiLock(currentLockers, pjp);
            return object;
        }
        finally {
            locker.unlock();
            this.log.debug(Thread.currentThread().getName() + " exited LOCK method:" + pjp.toShortString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> toLockerStrings(ProceedingJoinPoint point) {
        void $this$mapTo$iv$iv;
        Object object = point.getSignature();
        MethodSignature methodSignature = object instanceof MethodSignature ? (MethodSignature)object : null;
        if (methodSignature == null) {
            throw new IllegalStateException("can not work for signature:" + point.getSignature());
        }
        MethodSignature method2 = methodSignature;
        Method method3 = method2.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)method3, (String)"getMethod(...)");
        KFunction kFunction = ReflectJvmMapping.getKotlinFunction((Method)method3);
        List list2 = kFunction != null ? KAnnotatedElements.findAnnotations((KAnnotatedElement)((KAnnotatedElement)kFunction), (KClass)Reflection.getOrCreateKotlinClass(AutoLock.class)) : null;
        object = list2;
        if (object == null || object.isEmpty()) {
            throw new IllegalStateException("can not work for signature:" + point.getSignature() + "; AutoLock not be found.");
        }
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            String keyName;
            AutoLock autoLock = (AutoLock)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = keyName = StringUtils.hasText((String)it.value()) ? it.value() : point.toLongString();
            if (StringUtils.hasText((String)it.key())) {
                Method method4 = method2.getMethod();
                Intrinsics.checkNotNullExpressionValue((Object)method4, (String)"getMethod(...)");
                Object[] objectArray = point.getArgs();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getArgs(...)");
                Object object2 = point.getTarget();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getTarget(...)");
                EvaluationContext context = this.evaluator.createEvaluationContext$common_ext(method4, objectArray, object2);
                Expression expression = this.evaluator.getCachedExpression(it.key(), it);
                string = Objects.toString(expression.getValue(context));
            } else {
                Object[] objectArray = point.getArgs();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getArgs(...)");
                string = Objects.toString(ArraysKt.getOrNull((Object[])objectArray, (int)0));
            }
            String key = string;
            collection.add(this.lockerNamePrefix + '-' + keyName + '-' + key);
        }
        return (List)destination$iv$iv;
    }
}

