/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.http;

import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.http.ForwardRequest;
import io.github.caijiang.common.http.NewHttpRequestUrl;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lio/github/caijiang/common/http/ForwardRequestSpringRestTemplate;", "", "()V", "forward", "Lorg/springframework/http/ResponseEntity;", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "Lio/github/caijiang/common/HttpServletRequest;", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "changer", "Lio/github/caijiang/common/http/NewHttpRequestUrl;", "common-ext"})
@SourceDebugExtension(value={"SMAP\nForwardRequestSpringRestTemplate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForwardRequestSpringRestTemplate.kt\nio/github/caijiang/common/http/ForwardRequestSpringRestTemplate\n+ 2 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n+ 3 RestOperationsExtensions.kt\norg/springframework/web/client/RestOperationsExtensionsKt\n*L\n1#1,57:1\n16#2:58\n16#2:60\n249#3:59\n*S KotlinDebug\n*F\n+ 1 ForwardRequestSpringRestTemplate.kt\nio/github/caijiang/common/http/ForwardRequestSpringRestTemplate\n*L\n41#1:58\n50#1:60\n42#1:59\n*E\n"})
public final class ForwardRequestSpringRestTemplate {
    @NotNull
    public static final ForwardRequestSpringRestTemplate INSTANCE = new ForwardRequestSpringRestTemplate();

    private ForwardRequestSpringRestTemplate() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final ResponseEntity<byte[]> forward(@NotNull HttpServletRequest request, @NotNull RestTemplate restTemplate, @NotNull NewHttpRequestUrl changer) {
        void $this$exchange$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        Intrinsics.checkNotNullParameter((Object)changer, (String)"changer");
        String string = request.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethod(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        HttpMethod method2 = HttpMethod.valueOf((String)string2);
        HttpHeaders requestHeaders = new HttpHeaders();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Intrinsics.checkNotNull((Object)headerName);
            if (ForwardRequest.ignoreHeaders$default(ForwardRequest.INSTANCE, headerName, false, 2, null)) continue;
            requestHeaders.set(headerName, request.getHeader(headerName));
        }
        ByteArrayOutputStream body = new ByteArrayOutputStream();
        StreamUtils.copy((InputStream)((InputStream)request.getInputStream()), (OutputStream)body);
        HttpEntity requestEntity = new HttpEntity((Object)body.toByteArray(), (MultiValueMap)requestHeaders);
        String url = changer.newUrl(request);
        Slf4j.Companion companion = Slf4j.Companion;
        ForwardRequestSpringRestTemplate $this$log$iv = INSTANCE;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(ForwardRequestSpringRestTemplate.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("forwarding request to {}:{}", (Object)method2, (Object)url);
        $this$log$iv = (RestOperations)restTemplate;
        Object uriVariables$iv = new Object[]{};
        boolean $i$f$exchange = false;
        ResponseEntity responseEntity = $this$exchange$iv.exchange(url, method2, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<byte[]>(){}, Arrays.copyOf(uriVariables$iv, ((Object[])uriVariables$iv).length));
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"exchange(url, method, re\u2026e<T>() {}, *uriVariables)");
        ResponseEntity entity = responseEntity;
        HttpHeaders headers = new HttpHeaders();
        entity.getHeaders().forEach((arg_0, arg_1) -> ForwardRequestSpringRestTemplate.forward$lambda$0((Function2)new Function2<String, List<String>, Unit>(headers){
            final /* synthetic */ HttpHeaders $headers;
            {
                this.$headers = $headers;
                super(2);
            }

            public final void invoke(String t, List<String> u) {
                Intrinsics.checkNotNull((Object)t);
                if (!ForwardRequest.INSTANCE.ignoreHeaders(t, false)) {
                    this.$headers.addAll(t, u);
                }
            }
        }, arg_0, arg_1));
        uriVariables$iv = Slf4j.Companion;
        ForwardRequestSpringRestTemplate $this$log$iv2 = INSTANCE;
        boolean $i$f$getLog2 = false;
        Logger logger2 = LoggerFactory.getLogger(ForwardRequestSpringRestTemplate.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        logger2.debug("response status:{}", (Object)entity.getStatusCode());
        ResponseEntity responseEntity2 = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)entity.getStatusCode()).headers(headers)).body(entity.getBody());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"body(...)");
        return responseEntity2;
    }

    private static final void forward$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }
}

