/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.debounce.bean;

import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.debounce.DebounceService;
import io.github.caijiang.common.debounce.DelayMQData;
import io.github.caijiang.common.debounce.MqSender;
import java.time.Duration;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0001\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/github/caijiang/common/debounce/bean/DebounceServiceImpl;", "Lio/github/caijiang/common/debounce/DebounceService;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "debounceRedisTemplate", "Lorg/springframework/data/redis/core/RedisTemplate;", "", "", "(Lorg/springframework/context/ApplicationContext;Lorg/springframework/data/redis/core/RedisTemplate;)V", "debounceAbsent", "Lorg/springframework/data/redis/core/script/RedisScript;", "mqSender", "Lio/github/caijiang/common/debounce/MqSender;", "debounce", "", "type", "arg", "debounceDuration", "Ljava/time/Duration;", "deathDuration", "saveOrQueryTraceId", "Lkotlin/Pair;", "", "Ljava/util/UUID;", "common-ext"})
@SourceDebugExtension(value={"SMAP\nDebounceServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebounceServiceImpl.kt\nio/github/caijiang/common/debounce/bean/DebounceServiceImpl\n+ 2 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n*L\n1#1,76:1\n16#2:77\n*S KotlinDebug\n*F\n+ 1 DebounceServiceImpl.kt\nio/github/caijiang/common/debounce/bean/DebounceServiceImpl\n*L\n44#1:77\n*E\n"})
public final class DebounceServiceImpl
implements DebounceService {
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final RedisTemplate<String, Object> debounceRedisTemplate;
    @Nullable
    private MqSender mqSender;
    @NotNull
    private final RedisScript<String> debounceAbsent;

    public DebounceServiceImpl(@NotNull ApplicationContext applicationContext, @Qualifier(value="debounceRedisTemplate") @NotNull RedisTemplate<String, Object> debounceRedisTemplate2) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter(debounceRedisTemplate2, (String)"debounceRedisTemplate");
        this.applicationContext = applicationContext;
        this.debounceRedisTemplate = debounceRedisTemplate2;
        RedisScript redisScript = RedisScript.of((Resource)((Resource)new ClassPathResource("/lua/debounce-absent.lua")), String.class);
        Intrinsics.checkNotNullExpressionValue((Object)redisScript, (String)"of(...)");
        this.debounceAbsent = redisScript;
    }

    private final Pair<Boolean, UUID> saveOrQueryTraceId(String type, String arg) {
        String key = DelayMQData.Companion.redisHashKeyFor(type, arg);
        Slf4j.Companion companion = Slf4j.Companion;
        DebounceServiceImpl $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(DebounceServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.trace("saveOrQueryTraceId for hash:{}", (Object)key);
        UUID inputTrace = UUID.randomUUID();
        Object[] objectArray = new Object[]{inputTrace.toString()};
        String string = (String)this.debounceRedisTemplate.execute(this.debounceAbsent, CollectionsKt.listOf((Object)key), objectArray);
        if (string == null) {
            return new Pair((Object)true, (Object)inputTrace);
        }
        String resultTrace = string;
        return new Pair((Object)false, (Object)UUID.fromString(resultTrace));
    }

    @Override
    public void debounce(@NotNull String type, @NotNull String arg, @NotNull Duration debounceDuration, @NotNull Duration deathDuration) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            Intrinsics.checkNotNullParameter((Object)debounceDuration, (String)"debounceDuration");
            Intrinsics.checkNotNullParameter((Object)deathDuration, (String)"deathDuration");
            if (this.mqSender == null) {
                this.mqSender = (MqSender)this.applicationContext.getBean(MqSender.class);
            }
            Pair<Boolean, UUID> pair = this.saveOrQueryTraceId(type, arg);
            boolean created = (Boolean)pair.component1();
            UUID id = (UUID)pair.component2();
            if (created) {
                Message message = MessageBuilder.withPayload((Object)new DelayMQData(type, arg, id, null)).setHeaderIfAbsent("common-debounce", (Object)true).build();
                MqSender mqSender = this.mqSender;
                if (mqSender != null) {
                    Intrinsics.checkNotNull((Object)message);
                    mqSender.sendDelay((Message<DelayMQData>)message, deathDuration);
                }
            }
            DelayMQData mqWithDebounce = new DelayMQData(type, arg, id, System.currentTimeMillis() + debounceDuration.toMillis());
            HashOperations hash = this.debounceRedisTemplate.opsForHash();
            String string = mqWithDebounce.redisHashKey();
            Long l = mqWithDebounce.getDebounceTimestamp();
            Intrinsics.checkNotNull((Object)l);
            hash.put((Object)string, (Object)"debounce", (Object)l);
            Message message = MessageBuilder.withPayload((Object)mqWithDebounce).setHeaderIfAbsent("common-debounce", (Object)true).build();
            MqSender mqSender = this.mqSender;
            if (mqSender == null) break block3;
            Intrinsics.checkNotNull((Object)message);
            mqSender.sendDelay((Message<DelayMQData>)message, debounceDuration);
        }
    }
}

