/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.debounce.rocket;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinFeature;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.debounce.DelayMQData;
import io.github.caijiang.common.debounce.MqSender;
import io.github.caijiang.common.debounce.config.DebounceProperties;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/github/caijiang/common/debounce/rocket/RocketMqSender;", "Lio/github/caijiang/common/debounce/MqSender;", "template", "Lorg/apache/rocketmq/spring/core/RocketMQTemplate;", "properties", "Lio/github/caijiang/common/debounce/config/DebounceProperties;", "(Lorg/apache/rocketmq/spring/core/RocketMQTemplate;Lio/github/caijiang/common/debounce/config/DebounceProperties;)V", "rocketMqDelayLevels", "", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "", "supportCustomTime", "", "isBrokerAbove5", "sendDelay", "", "message", "Lorg/springframework/messaging/Message;", "Lio/github/caijiang/common/debounce/DelayMQData;", "duration", "Companion", "TheSendCallback", "common-ext"})
@SourceDebugExtension(value={"SMAP\nRocketMqSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RocketMqSender.kt\nio/github/caijiang/common/debounce/rocket/RocketMqSender\n+ 2 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n*L\n1#1,116:1\n16#2:117\n16#2:118\n16#2:119\n16#2:120\n*S KotlinDebug\n*F\n+ 1 RocketMqSender.kt\nio/github/caijiang/common/debounce/rocket/RocketMqSender\n*L\n91#1:117\n102#1:118\n110#1:119\n113#1:120\n*E\n"})
public final class RocketMqSender
implements MqSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RocketMQTemplate template;
    @NotNull
    private final DebounceProperties properties;
    private final boolean supportCustomTime;
    @NotNull
    private final Map<Duration, Integer> rocketMqDelayLevels;
    @NotNull
    private static final ObjectMapper rocketMqMapper;

    public RocketMqSender(@NotNull RocketMQTemplate template, @NotNull DebounceProperties properties) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.template = template;
        this.properties = properties;
        this.supportCustomTime = this.isBrokerAbove5(this.template);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Duration.ofSeconds(1L), (Object)1), TuplesKt.to((Object)Duration.ofSeconds(5L), (Object)2), TuplesKt.to((Object)Duration.ofSeconds(10L), (Object)3), TuplesKt.to((Object)Duration.ofSeconds(30L), (Object)4), TuplesKt.to((Object)Duration.ofMinutes(1L), (Object)5), TuplesKt.to((Object)Duration.ofMinutes(2L), (Object)6), TuplesKt.to((Object)Duration.ofMinutes(3L), (Object)7), TuplesKt.to((Object)Duration.ofMinutes(4L), (Object)8), TuplesKt.to((Object)Duration.ofMinutes(5L), (Object)9), TuplesKt.to((Object)Duration.ofMinutes(6L), (Object)10), TuplesKt.to((Object)Duration.ofMinutes(7L), (Object)11), TuplesKt.to((Object)Duration.ofMinutes(8L), (Object)12), TuplesKt.to((Object)Duration.ofMinutes(9L), (Object)13), TuplesKt.to((Object)Duration.ofMinutes(10L), (Object)14), TuplesKt.to((Object)Duration.ofMinutes(20L), (Object)15), TuplesKt.to((Object)Duration.ofMinutes(30L), (Object)16), TuplesKt.to((Object)Duration.ofHours(1L), (Object)17), TuplesKt.to((Object)Duration.ofHours(2L), (Object)18)};
        this.rocketMqDelayLevels = MapsKt.mapOf((Pair[])pairArray);
    }

    private final boolean isBrokerAbove5(RocketMQTemplate template) {
        if (this.properties.getRocketMqAbove5() != null) {
            Boolean bl = this.properties.getRocketMqAbove5();
            Intrinsics.checkNotNull((Object)bl);
            return bl;
        }
        return false;
    }

    @Override
    public void sendDelay(@NotNull Message<DelayMQData> message, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Message realMessage = MessageBuilder.withPayload((Object)rocketMqMapper.writeValueAsString(message.getPayload())).copyHeaders((Map)message.getHeaders()).build();
        if (this.properties.getAsyncSending()) {
            Slf4j.Companion companion = Slf4j.Companion;
            RocketMqSender $this$log$iv2 = this;
            boolean $i$f$getLog = false;
            Logger logger = LoggerFactory.getLogger(RocketMqSender.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.trace("rocketMQ 5.0 -- template.asyncSend with {}", (Object)realMessage);
            String string = this.properties.getTopic();
            Intrinsics.checkNotNull((Object)realMessage);
            Integer n = this.rocketMqDelayLevels.get(duration);
            if (n == null) {
                throw new IllegalStateException("RocketMQ 5.0 \u4e4b\u524d\u7684\u7248\u672c\u6216\u8005\u5f02\u6b65\u53d1\u9001\uff0c\u53ea\u80fd\u4f7f\u7528:" + this.rocketMqDelayLevels.keySet());
            }
            this.template.asyncSend(string, realMessage, (SendCallback)new TheSendCallback(realMessage), (long)this.template.getProducer().getSendMsgTimeout(), n.intValue());
        } else {
            Slf4j.Companion this_$iv;
            SendResult sendResult;
            boolean $i$f$getLog;
            RocketMqSender $this$log$iv;
            if (!this.supportCustomTime) {
                Slf4j.Companion $this$log$iv2 = Slf4j.Companion;
                $this$log$iv = this;
                $i$f$getLog = false;
                Logger logger = LoggerFactory.getLogger(RocketMqSender.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                logger.trace("rocketMQ 5.0 -- template.syncSend with {}", (Object)realMessage);
                Integer n = this.rocketMqDelayLevels.get(duration);
                if (n == null) {
                    throw new IllegalStateException("RocketMQ 5.0 \u4e4b\u524d\u7684\u7248\u672c\uff0c\u53ea\u80fd\u4f7f\u7528:" + this.rocketMqDelayLevels.keySet());
                }
                sendResult = this.template.syncSend(this.properties.getTopic(), realMessage, (long)this.template.getProducer().getSendMsgTimeout(), n.intValue());
            } else {
                this_$iv = Slf4j.Companion;
                $this$log$iv = this;
                $i$f$getLog = false;
                Logger logger = LoggerFactory.getLogger(RocketMqSender.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                logger.trace("rocketMQ 5.0 ++ template.syncSendDelayTimeMills with {}", (Object)realMessage);
                sendResult = this.template.syncSendDelayTimeMills(this.properties.getTopic(), realMessage, duration.toMillis());
            }
            SendResult result = sendResult;
            this_$iv = Slf4j.Companion;
            $this$log$iv = this;
            $i$f$getLog = false;
            Logger logger = LoggerFactory.getLogger(RocketMqSender.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.debug("send message:{} to rocketMQ with result = {}", (Object)realMessage, (Object)result);
        }
    }

    static {
        Module[] moduleArray = new Module[]{new KotlinModule.Builder().withReflectionCacheSize(512).configure(KotlinFeature.NullToEmptyCollection, false).configure(KotlinFeature.NullToEmptyMap, false).configure(KotlinFeature.NullIsSameAsDefault, false).configure(KotlinFeature.StrictNullChecks, true).build()};
        ObjectMapper objectMapper = new ObjectMapper().registerModules(moduleArray);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"registerModules(...)");
        rocketMqMapper = objectMapper;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/caijiang/common/debounce/rocket/RocketMqSender$Companion;", "", "()V", "rocketMqMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getRocketMqMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "common-ext"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectMapper getRocketMqMapper() {
            return rocketMqMapper;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/github/caijiang/common/debounce/rocket/RocketMqSender$TheSendCallback;", "Lorg/apache/rocketmq/client/producer/SendCallback;", "message", "Lorg/springframework/messaging/Message;", "(Lorg/springframework/messaging/Message;)V", "onException", "", "e", "", "onSuccess", "sendResult", "Lorg/apache/rocketmq/client/producer/SendResult;", "common-ext"})
    @SourceDebugExtension(value={"SMAP\nRocketMqSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RocketMqSender.kt\nio/github/caijiang/common/debounce/rocket/RocketMqSender$TheSendCallback\n+ 2 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n*L\n1#1,116:1\n16#2:117\n16#2:118\n*S KotlinDebug\n*F\n+ 1 RocketMqSender.kt\nio/github/caijiang/common/debounce/rocket/RocketMqSender$TheSendCallback\n*L\n76#1:117\n80#1:118\n*E\n"})
    private static final class TheSendCallback
    implements SendCallback {
        @NotNull
        private final Message<?> message;

        public TheSendCallback(@NotNull Message<?> message) {
            Intrinsics.checkNotNullParameter(message, (String)"message");
            this.message = message;
        }

        public void onSuccess(@Nullable SendResult sendResult) {
            Slf4j.Companion companion = Slf4j.Companion;
            TheSendCallback $this$log$iv = this;
            boolean $i$f$getLog = false;
            Logger logger = LoggerFactory.getLogger(TheSendCallback.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.debug("send message:{} to rocketMQ with result = {}", this.message, (Object)sendResult);
        }

        public void onException(@Nullable Throwable e) {
            Slf4j.Companion companion = Slf4j.Companion;
            TheSendCallback $this$log$iv = this;
            boolean $i$f$getLog = false;
            Logger logger = LoggerFactory.getLogger(TheSendCallback.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.warn("send message:{} to rocketMQ with exception:", this.message, (Object)e);
        }
    }
}

