/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.http;

import io.github.caijiang.common.http.ForwardRequest;
import io.github.caijiang.common.http.NewHttpRequestUrl;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\n\u001a\u00020\u000b2\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lio/github/caijiang/common/http/ForwardRequest4;", "", "()V", "convert", "Lorg/apache/http/client/methods/HttpUriRequest;", "request", "Ljavax/servlet/http/HttpServletRequest;", "Lio/github/caijiang/common/HttpServletRequest;", "changer", "Lio/github/caijiang/common/http/NewHttpRequestUrl;", "forward", "", "response", "Ljavax/servlet/http/HttpServletResponse;", "Lio/github/caijiang/common/HttpServletResponse;", "toHttpEntity", "Lorg/apache/http/HttpEntity;", "common-ext"})
@SourceDebugExtension(value={"SMAP\nForwardRequest4.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForwardRequest4.kt\nio/github/caijiang/common/http/ForwardRequest4\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n3792#2:94\n4307#2,2:95\n1855#3,2:97\n*S KotlinDebug\n*F\n+ 1 ForwardRequest4.kt\nio/github/caijiang/common/http/ForwardRequest4\n*L\n81#1:94\n81#1:95,2\n82#1:97,2\n*E\n"})
public final class ForwardRequest4 {
    @NotNull
    public static final ForwardRequest4 INSTANCE = new ForwardRequest4();

    private ForwardRequest4() {
    }

    private final HttpEntity toHttpEntity(HttpServletRequest request) {
        if (request.getContentLengthLong() == 0L) {
            return null;
        }
        return (HttpEntity)new InputStreamEntity((InputStream)request.getInputStream(), request.getContentLengthLong());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final HttpUriRequest convert(HttpServletRequest request, NewHttpRequestUrl changer) {
        String method2 = request.getMethod();
        String url = changer.newUrl(request);
        HttpUriRequest httpUriRequest = null;
        String string = method2;
        if (string == null) throw new UnsupportedOperationException("Unsupported HTTP method: " + method2);
        int n = -1;
        switch (string.hashCode()) {
            case 2012838315: {
                if (string.equals("DELETE")) {
                    n = 1;
                }
                break;
            }
            case 2461856: {
                if (string.equals("POST")) {
                    n = 2;
                }
                break;
            }
            case 70454: {
                if (string.equals("GET")) {
                    n = 3;
                }
                break;
            }
            case 79599: {
                if (string.equals("PUT")) {
                    n = 4;
                }
                break;
            }
            case 75900968: {
                if (string.equals("PATCH")) {
                    n = 5;
                }
                break;
            }
        }
        switch (n) {
            case 3: {
                httpUriRequest = (HttpUriRequest)new HttpGet(url);
                break;
            }
            case 2: {
                HttpPost t = new HttpPost(url);
                t.setEntity(this.toHttpEntity(request));
                httpUriRequest = (HttpUriRequest)t;
                break;
            }
            case 4: {
                HttpPost t = new HttpPut(url);
                t.setEntity(this.toHttpEntity(request));
                httpUriRequest = (HttpUriRequest)t;
                break;
            }
            case 5: {
                HttpPost t = new HttpPatch(url);
                t.setEntity(this.toHttpEntity(request));
                httpUriRequest = (HttpUriRequest)t;
                break;
            }
            case 1: {
                httpUriRequest = (HttpUriRequest)new HttpDelete(url);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported HTTP method: " + method2);
            }
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            Object e = headerNames.nextElement();
            Intrinsics.checkNotNullExpressionValue(e, (String)"nextElement(...)");
            String headerName = (String)e;
            if (ForwardRequest.ignoreHeaders$default(ForwardRequest.INSTANCE, headerName, false, 2, null)) continue;
            String headerValue = request.getHeader(headerName);
            httpUriRequest.setHeader(headerName, headerValue);
        }
        return httpUriRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void forward(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response2, @NotNull NewHttpRequestUrl changer) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)changer, (String)"changer");
        Closeable closeable = (Closeable)HttpClientBuilder.create().build();
        Throwable throwable = null;
        try {
            CloseableHttpClient client = (CloseableHttpClient)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)client.execute(INSTANCE.convert(request, changer));
            Throwable throwable2 = null;
            try {
                CloseableHttpResponse httpResponse = (CloseableHttpResponse)closeable2;
                boolean bl2 = false;
                try {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    response2.setStatus(httpResponse.getStatusLine().getStatusCode());
                    Header[] headerArray = httpResponse.getAllHeaders();
                    Intrinsics.checkNotNullExpressionValue((Object)headerArray, (String)"getAllHeaders(...)");
                    Object[] objectArray = headerArray;
                    boolean $i$f$filter = false;
                    Iterator iterator = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (void element$iv$iv : $this$filterTo$iv$iv) {
                        Header it = (Header)element$iv$iv;
                        boolean bl3 = false;
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (!(!ForwardRequest.INSTANCE.ignoreHeaders(string, false))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Header it = (Header)element$iv;
                        boolean bl4 = false;
                        response2.addHeader(it.getName(), it.getValue());
                    }
                    HttpEntity httpEntity = httpResponse.getEntity();
                    if (httpEntity != null) {
                        httpEntity.writeTo((OutputStream)response2.getOutputStream());
                    }
                    response2.getOutputStream().flush();
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

