/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.aliyun.oss;

import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.comm.SignVersion;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.StorageClass;
import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.aliyun.oss.OssProperties;
import io.github.caijiang.common.aliyun.oss.OssUsageService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.util.Date;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/caijiang/common/aliyun/oss/OssUsageServiceImpl;", "Lio/github/caijiang/common/aliyun/oss/OssUsageService;", "properties", "Lio/github/caijiang/common/aliyun/oss/OssProperties;", "(Lio/github/caijiang/common/aliyun/oss/OssProperties;)V", "ossClient", "Lcom/aliyun/oss/OSS;", "privateResourceTemporaryUrl", "", "resourcePath", "publicResourceUrl", "uploadPrivateResource", "", "data", "Ljava/io/InputStream;", "uploadPublicResource", "common-ext"})
@SourceDebugExtension(value={"SMAP\nOssUsageServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OssUsageServiceImpl.kt\nio/github/caijiang/common/aliyun/oss/OssUsageServiceImpl\n+ 2 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n*L\n1#1,118:1\n16#2:119\n16#2:120\n16#2:121\n*S KotlinDebug\n*F\n+ 1 OssUsageServiceImpl.kt\nio/github/caijiang/common/aliyun/oss/OssUsageServiceImpl\n*L\n34#1:119\n37#1:120\n40#1:121\n*E\n"})
public final class OssUsageServiceImpl
implements OssUsageService {
    @NotNull
    private final OssProperties properties;
    @NotNull
    private final OSS ossClient;

    public OssUsageServiceImpl(@NotNull OssProperties properties) {
        Object this_$iv;
        boolean $i$f$getLog;
        OssUsageServiceImpl $this$log$iv;
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
        ClientBuilderConfiguration clientBuilderConfiguration = new ClientBuilderConfiguration();
        clientBuilderConfiguration.setSignatureVersion(SignVersion.V4);
        OSS oSS = OSSClientBuilder.create().endpoint(this.properties.getEndPoint()).credentialsProvider((CredentialsProvider)new DefaultCredentialProvider(this.properties.getAccessKey(), this.properties.getAccessSecret())).clientConfiguration((ClientConfiguration)clientBuilderConfiguration).region(this.properties.getRegion()).build();
        Intrinsics.checkNotNullExpressionValue((Object)oSS, (String)"build(...)");
        this.ossClient = oSS;
        Object object = this.properties.getPrvBucket();
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            object = Slf4j.Companion;
            $this$log$iv = this;
            $i$f$getLog = false;
            Logger logger = LoggerFactory.getLogger(OssUsageServiceImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.warn("oss.prv-bucket \u5c1a\u672a\u914d\u7f6e,\u8bbf\u95ee\u79c1\u6709\u8d44\u6e90\u65f6\u4f1a\u62a5\u544a\u5f02\u5e38");
        }
        if ((this_$iv = (CharSequence)this.properties.getPubBucket()) == null || StringsKt.isBlank((CharSequence)this_$iv)) {
            this_$iv = Slf4j.Companion;
            $this$log$iv = this;
            $i$f$getLog = false;
            Logger logger = LoggerFactory.getLogger(OssUsageServiceImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.warn("oss.pub-bucket \u5c1a\u672a\u914d\u7f6e,\u8bbf\u95ee\u516c\u5f00\u8d44\u6e90\u65f6\u4f1a\u62a5\u544a\u5f02\u5e38");
        }
        if ((this_$iv = (CharSequence)this.properties.getDomain()) == null || StringsKt.isBlank((CharSequence)this_$iv)) {
            this_$iv = Slf4j.Companion;
            $this$log$iv = this;
            $i$f$getLog = false;
            Logger logger = LoggerFactory.getLogger(OssUsageServiceImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.warn("oss.domain \u5c1a\u672a\u914d\u7f6e,\u8bbf\u95ee\u516c\u5f00\u8d44\u6e90\u65f6\u4f1a\u62a5\u544a\u5f02\u5e38");
        }
    }

    @Override
    @NotNull
    public String uploadPublicResource(@NotNull String resourcePath, @NotNull InputStream data) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = this.properties.getPubBucket();
        if (string == null) {
            throw new NotImplementedError("\u914d\u7f6e\u4e0d\u652f\u6301");
        }
        PutObjectRequest request = new PutObjectRequest(string, resourcePath, data);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setHeader("x-oss-storage-class", (Object)StorageClass.Standard.toString());
        metadata.setObjectAcl(CannedAccessControlList.PublicRead);
        request.setMetadata(metadata);
        try {
            this.ossClient.putObject(request);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        String string2 = this.properties.getDomain();
        if (string2 == null) {
            throw new NotImplementedError("\u914d\u7f6e\u4e0d\u652f\u6301");
        }
        return string2 + StringsKt.removePrefix((String)resourcePath, (CharSequence)"/");
    }

    @Override
    @NotNull
    public String publicResourceUrl(@NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        String string = this.properties.getDomain();
        if (string == null) {
            throw new NotImplementedError("\u914d\u7f6e\u4e0d\u652f\u6301");
        }
        return string + StringsKt.removePrefix((String)resourcePath, (CharSequence)"/");
    }

    @Override
    public void uploadPrivateResource(@NotNull String resourcePath, @NotNull InputStream data) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = this.properties.getPrvBucket();
        if (string == null) {
            throw new NotImplementedError("\u914d\u7f6e\u4e0d\u652f\u6301");
        }
        PutObjectRequest request = new PutObjectRequest(string, resourcePath, data);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setHeader("x-oss-storage-class", (Object)StorageClass.Standard.toString());
        metadata.setObjectAcl(CannedAccessControlList.Private);
        request.setMetadata(metadata);
        try {
            this.ossClient.putObject(request);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    @NotNull
    public String privateResourceTemporaryUrl(@NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        String string = this.properties.getPrvBucket();
        if (string == null) {
            throw new NotImplementedError("\u914d\u7f6e\u4e0d\u652f\u6301");
        }
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(string, resourcePath, HttpMethod.GET);
        long l = System.currentTimeMillis();
        Duration duration = this.properties.getExpireDuration();
        if (duration == null) {
            duration = Duration.ofHours(1L);
        }
        request.setExpiration(new Date(l + duration.toMillis()));
        try {
            ClientBuilderConfiguration clientBuilderConfiguration = new ClientBuilderConfiguration();
            clientBuilderConfiguration.setSignatureVersion(SignVersion.V4);
            String string2 = this.properties.getEndPoint();
            OSS client = OSSClientBuilder.create().endpoint(string2 != null ? StringsKt.replace$default((String)string2, (String)"-internal", (String)"", (boolean)false, (int)4, null) : null).credentialsProvider((CredentialsProvider)new DefaultCredentialProvider(this.properties.getAccessKey(), this.properties.getAccessSecret())).clientConfiguration((ClientConfiguration)clientBuilderConfiguration).region(this.properties.getRegion()).build();
            URL signedUrl = client.generatePresignedUrl(request);
            String string3 = signedUrl.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            return string3;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

