/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.http;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\b\u001a\u00020\tH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/github/caijiang/common/http/CurlHttpRequestInterceptor4;", "Lorg/apache/http/HttpRequestInterceptor;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "process", "", "request", "Lorg/apache/http/HttpRequest;", "context", "Lorg/apache/http/protocol/HttpContext;", "toBodyLine", "", "", "toHeaderLine", "", "Companion", "common-ext"})
@SourceDebugExtension(value={"SMAP\nCurlHttpRequestInterceptor4.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurlHttpRequestInterceptor4.kt\nio/github/caijiang/common/http/CurlHttpRequestInterceptor4\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n3792#2:75\n4307#2,2:76\n1855#3,2:78\n*S KotlinDebug\n*F\n+ 1 CurlHttpRequestInterceptor4.kt\nio/github/caijiang/common/http/CurlHttpRequestInterceptor4\n*L\n46#1:75\n46#1:76,2\n49#1:78,2\n*E\n"})
public final class CurlHttpRequestInterceptor4
implements HttpRequestInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log = LoggerFactory.getLogger(CurlHttpRequestInterceptor4.class);
    @NotNull
    private static final Set<String> hideHeaders;

    public void process(@NotNull HttpRequest request, @Nullable HttpContext context) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!this.log.isInfoEnabled()) {
            return;
        }
        try {
            List<String> bodyLines = this.toBodyLine(request);
            List<String> lines = this.toHeaderLine(request);
            lines.addAll((Collection<String>)bodyLines);
            this.log.info('\n' + CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)" \\\n", null, null, (int)0, null, null, (int)62, null));
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> toHeaderLine(HttpRequest request) {
        void $this$filterTo$iv$iv;
        if (!(request instanceof HttpUriRequest)) {
            throw new IllegalArgumentException("can not write curl for " + request);
        }
        if (!(request instanceof HttpRequestWrapper)) {
            throw new IllegalArgumentException("can not write curl for " + request);
        }
        List lines = new ArrayList();
        lines.add("curl -k -v --location --request " + ((HttpRequestWrapper)request).getMethod() + " '" + ((HttpRequestWrapper)request).getTarget().toURI() + ((HttpRequestWrapper)request).getURI() + '\'');
        Header[] headerArray = ((HttpRequestWrapper)request).getAllHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)headerArray, (String)"getAllHeaders(...)");
        Object[] $this$filter$iv = headerArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Header it = (Header)element$iv$iv;
            boolean bl = false;
            if (!(!hideHeaders.contains(it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Header header = (Header)element$iv;
            boolean bl = false;
            lines.add("--header '" + header.getName() + ": " + header.getValue() + '\'');
        }
        return lines;
    }

    private final List<String> toBodyLine(HttpRequest request) {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            return CollectionsKt.emptyList();
        }
        HttpEntity httpEntity = ((HttpEntityEnclosingRequest)request).getEntity();
        if (httpEntity == null) {
            return CollectionsKt.emptyList();
        }
        HttpEntity entity = httpEntity;
        if (!entity.isRepeatable()) {
            throw new IllegalArgumentException("HttpEntity \u65e0\u6cd5\u91cd\u590d");
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)buf);
        buf.flush();
        StringBuilder stringBuilder = new StringBuilder().append("-d '");
        byte[] byArray = buf.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] byArray2 = byArray;
        return CollectionsKt.listOf((Object)stringBuilder.append(new String(byArray2, Charsets.UTF_8)).append('\'').toString());
    }

    static {
        Object[] objectArray = new String[]{"Content-Length", "Connection", "Host"};
        hideHeaders = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/github/caijiang/common/http/CurlHttpRequestInterceptor4$Companion;", "", "()V", "hideHeaders", "", "", "getHideHeaders", "()Ljava/util/Set;", "common-ext"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getHideHeaders() {
            return hideHeaders;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

