/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.http;

import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.http.ForwardRequest;
import io.github.caijiang.common.http.NewHttpRequestUrl;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lio/github/caijiang/common/http/ForwardRequestSpringClientHttpRequestFactory;", "", "()V", "forward", "Lorg/springframework/http/ResponseEntity;", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "Lio/github/caijiang/common/HttpServletRequest;", "factory", "Lorg/springframework/http/client/ClientHttpRequestFactory;", "changer", "Lio/github/caijiang/common/http/NewHttpRequestUrl;", "common-ext"})
@SourceDebugExtension(value={"SMAP\nForwardRequestSpringClientHttpRequestFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForwardRequestSpringClientHttpRequestFactory.kt\nio/github/caijiang/common/http/ForwardRequestSpringClientHttpRequestFactory\n+ 2 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n*L\n1#1,57:1\n16#2:58\n16#2:59\n*S KotlinDebug\n*F\n+ 1 ForwardRequestSpringClientHttpRequestFactory.kt\nio/github/caijiang/common/http/ForwardRequestSpringClientHttpRequestFactory\n*L\n28#1:58\n43#1:59\n*E\n"})
public final class ForwardRequestSpringClientHttpRequestFactory {
    @NotNull
    public static final ForwardRequestSpringClientHttpRequestFactory INSTANCE = new ForwardRequestSpringClientHttpRequestFactory();

    private ForwardRequestSpringClientHttpRequestFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final ResponseEntity<byte[]> forward(@NotNull HttpServletRequest request, @NotNull ClientHttpRequestFactory factory, @NotNull NewHttpRequestUrl changer) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)changer, (String)"changer");
        String string = request.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethod(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        HttpMethod method2 = HttpMethod.valueOf((String)string2);
        String url = changer.newUrl(request);
        Slf4j.Companion companion = Slf4j.Companion;
        ForwardRequestSpringClientHttpRequestFactory $this$log$iv = INSTANCE;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(ForwardRequestSpringClientHttpRequestFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("forwarding request to {}:{}", (Object)method2, (Object)url);
        ClientHttpRequest clientRequest = factory.createRequest(new URI(url), method2);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Intrinsics.checkNotNull((Object)headerName);
            if (ForwardRequest.ignoreHeaders$default(ForwardRequest.INSTANCE, headerName, false, 2, null)) continue;
            clientRequest.getHeaders().add(headerName, request.getHeader(headerName));
        }
        StreamUtils.copy((InputStream)((InputStream)request.getInputStream()), (OutputStream)clientRequest.getBody());
        Closeable closeable = (Closeable)clientRequest.execute();
        Throwable throwable = null;
        try {
            ClientHttpResponse response2 = (ClientHttpResponse)closeable;
            boolean bl = false;
            Slf4j.Companion companion2 = Slf4j.Companion;
            ForwardRequestSpringClientHttpRequestFactory $this$log$iv2 = INSTANCE;
            boolean $i$f$getLog2 = false;
            Logger logger2 = LoggerFactory.getLogger(ForwardRequestSpringClientHttpRequestFactory.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
            logger2.debug("response status:{}", (Object)response2.getStatusCode());
            HttpHeaders headers = new HttpHeaders();
            response2.getHeaders().forEach((arg_0, arg_1) -> ForwardRequestSpringClientHttpRequestFactory.forward$lambda$1$lambda$0((Function2)new Function2<String, List<String>, Unit>(headers){
                final /* synthetic */ HttpHeaders $headers;
                {
                    this.$headers = $headers;
                    super(2);
                }

                public final void invoke(String t, List<String> u) {
                    Intrinsics.checkNotNull((Object)t);
                    if (!ForwardRequest.INSTANCE.ignoreHeaders(t, false)) {
                        this.$headers.addAll(t, u);
                    }
                }
            }, arg_0, arg_1));
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            StreamUtils.copy((InputStream)response2.getBody(), (OutputStream)buffer);
            ResponseEntity responseEntity2 = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)response2.getStatusCode()).headers(headers)).body((Object)buffer.toByteArray());
            responseEntity = responseEntity2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"use(...)");
        return responseEntity;
    }

    private static final void forward$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }
}

