/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.debounce.bean;

import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.debounce.DebounceCallbackService;
import io.github.caijiang.common.debounce.DelayMQData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B#\u0012\u0014\b\u0001\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/github/caijiang/common/debounce/bean/MqMessageHandler;", "", "debounceRedisTemplate", "Lorg/springframework/data/redis/core/RedisTemplate;", "", "debounceCallbackService", "Lio/github/caijiang/common/debounce/DebounceCallbackService;", "(Lorg/springframework/data/redis/core/RedisTemplate;Lio/github/caijiang/common/debounce/DebounceCallbackService;)V", "handleIt", "", "message", "Lio/github/caijiang/common/debounce/DelayMQData;", "common-ext"})
@SourceDebugExtension(value={"SMAP\nMqMessageHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MqMessageHandler.kt\nio/github/caijiang/common/debounce/bean/MqMessageHandler\n+ 2 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n*L\n1#1,42:1\n16#2:43\n16#2:44\n*S KotlinDebug\n*F\n+ 1 MqMessageHandler.kt\nio/github/caijiang/common/debounce/bean/MqMessageHandler\n*L\n25#1:43\n32#1:44\n*E\n"})
public final class MqMessageHandler {
    @NotNull
    private final RedisTemplate<String, Object> debounceRedisTemplate;
    @NotNull
    private final DebounceCallbackService debounceCallbackService;

    public MqMessageHandler(@Qualifier(value="debounceRedisTemplate") @NotNull RedisTemplate<String, Object> debounceRedisTemplate2, @NotNull DebounceCallbackService debounceCallbackService) {
        Intrinsics.checkNotNullParameter(debounceRedisTemplate2, (String)"debounceRedisTemplate");
        Intrinsics.checkNotNullParameter((Object)debounceCallbackService, (String)"debounceCallbackService");
        this.debounceRedisTemplate = debounceRedisTemplate2;
        this.debounceCallbackService = debounceCallbackService;
    }

    public final void handleIt(@NotNull DelayMQData message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        HashOperations hash = this.debounceRedisTemplate.opsForHash();
        String key = message.redisHashKey();
        Object currentTrace = hash.get((Object)key, (Object)"trace");
        Slf4j.Companion companion = Slf4j.Companion;
        Object $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(MqMessageHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Object[] this_$iv = new Object[]{message, currentTrace, key};
        logger.debug("received debounce callback, message:{},currentTrace:{},hash:{}", this_$iv);
        if (currentTrace == null || !Intrinsics.areEqual((Object)currentTrace, (Object)message.getId().toString())) {
            return;
        }
        if (message.getDebounceTimestamp() != null) {
            Long debounce = (Long)hash.get((Object)("debounce:" + message.getType() + ':' + message.getArg()), (Object)"debounce");
            $this$log$iv = Slf4j.Companion;
            MqMessageHandler $this$log$iv2 = this;
            boolean $i$f$getLog2 = false;
            Logger logger2 = LoggerFactory.getLogger(MqMessageHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
            logger2.debug("that's not death call, debounce:{}", (Object)debounce);
            if (debounce != null && !Intrinsics.areEqual((Object)debounce, (Object)message.getDebounceTimestamp())) {
                return;
            }
        }
        Boolean bl = this.debounceRedisTemplate.delete((Object)key);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"delete(...)");
        if (bl.booleanValue()) {
            this.debounceCallbackService.invokeBusiness(message.getType(), message.getArg());
        }
    }
}

