/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.job.worker;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import io.github.caijiang.common.Common;
import io.github.caijiang.common.http.SimpleHttpResponse;
import io.github.caijiang.common.http.SimpleHttpUtils;
import io.github.caijiang.common.job.scheduler.Scheduler;
import io.github.caijiang.common.job.worker.PersistentJob;
import io.github.caijiang.common.job.worker.TemporaryJob;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/caijiang/common/job/worker/RemoteScheduler;", "Lio/github/caijiang/common/job/scheduler/Scheduler;", "url", "", "(Ljava/lang/String;)V", "submitPersistentJob", "", "env", "hostname", "cron", "job", "Lio/github/caijiang/common/job/worker/PersistentJob;", "timezone", "Ljava/util/TimeZone;", "submitTemporaryJob", "Lio/github/caijiang/common/job/worker/TemporaryJob;", "common-ext"})
public final class RemoteScheduler
implements Scheduler {
    @NotNull
    private final String url;

    public RemoteScheduler(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }

    @Override
    public void submitTemporaryJob(@NotNull String env, @NotNull String hostname, @NotNull TemporaryJob job) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        SimpleHttpResponse response2 = SimpleHttpUtils.httpAccess(this.url + "/t/" + env + '/' + hostname + '/' + job.getType(), "POST", MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/json")), (Function1<? super SimpleHttpUtils.EntityBuilder, Unit>)((Function1)new Function1<SimpleHttpUtils.EntityBuilder, Unit>(job){
            final /* synthetic */ TemporaryJob $job;
            {
                this.$job = $job;
                super(1);
            }

            public final void invoke(@NotNull SimpleHttpUtils.EntityBuilder it) {
                byte[] byArray;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Map<String, String> input$iv = this.$job.getParameters();
                boolean $i$f$writeToBinary = false;
                if (Common.isClassPresent$default("kotlinx.serialization.json.Json", null, 2, null)) {
                    ByteArrayOutputStream buf$iv = new ByteArrayOutputStream();
                    Json $this$encodeToStream$iv$iv = (Json)Json.Default;
                    boolean $i$f$encodeToStream = false;
                    $this$encodeToStream$iv$iv.getSerializersModule();
                    JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv$iv, (SerializationStrategy)((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE)), input$iv, (OutputStream)buf$iv);
                    buf$iv.close();
                    byte[] byArray2 = buf$iv.toByteArray();
                    byArray = byArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
                } else if (Common.isClassPresent$default("com.alibaba.fastjson.JSON", null, 2, null)) {
                    byte[] byArray3 = JSON.toJSONBytes(input$iv, (SerializerFeature[])new SerializerFeature[0]);
                    byArray = byArray3;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"toJSONBytes(...)");
                } else if (Common.isClassPresent$default("com.google.gson.Gson", null, 2, null)) {
                    String string = new Gson().toJson(input$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                    byte[] byArray4 = string.getBytes(Charsets.UTF_8);
                    byArray = byArray4;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getBytes(...)");
                } else if (Common.isClassPresent$default("com.fasterxml.jackson.databind.ObjectMapper", null, 2, null)) {
                    byte[] byArray5 = new ObjectMapper().writeValueAsBytes(input$iv);
                    byArray = byArray5;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"writeValueAsBytes(...)");
                } else {
                    throw new IllegalStateException("\u5565 Json\u73af\u5883\u652f\u6301\u90fd\u6ca1\u6709");
                }
                it.setBinary(byArray);
            }
        }));
        if (response2.getStatus() / 100 != 2) {
            byte[] byArray;
            throw new IllegalStateException("\u8fdc\u7a0b\u8c03\u5ea6\u54cd\u5e94\u5931\u8d25:" + response2.getStatus() + ':' + ((byArray = response2.getBody()) != null ? new String(byArray, Charsets.UTF_8) : null));
        }
    }

    @Override
    public void submitPersistentJob(@NotNull String env, @NotNull String hostname, @NotNull String cron, @NotNull PersistentJob job, @NotNull TimeZone timezone) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)cron, (String)"cron");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        SimpleHttpResponse response2 = SimpleHttpUtils.httpAccess(this.url + "/p/" + env + '/' + hostname + '/' + job.getType() + '/' + job.getName() + "?cron=" + URLEncoder.encode(cron, "UTF-8") + "&timezone=" + URLEncoder.encode(timezone.getID(), "UTF-8"), "POST", MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/json")), (Function1<? super SimpleHttpUtils.EntityBuilder, Unit>)((Function1)new Function1<SimpleHttpUtils.EntityBuilder, Unit>(job){
            final /* synthetic */ PersistentJob $job;
            {
                this.$job = $job;
                super(1);
            }

            public final void invoke(@NotNull SimpleHttpUtils.EntityBuilder it) {
                byte[] byArray;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Map<String, String> input$iv = this.$job.getParameters();
                boolean $i$f$writeToBinary = false;
                if (Common.isClassPresent$default("kotlinx.serialization.json.Json", null, 2, null)) {
                    ByteArrayOutputStream buf$iv = new ByteArrayOutputStream();
                    Json $this$encodeToStream$iv$iv = (Json)Json.Default;
                    boolean $i$f$encodeToStream = false;
                    $this$encodeToStream$iv$iv.getSerializersModule();
                    JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv$iv, (SerializationStrategy)((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE)), input$iv, (OutputStream)buf$iv);
                    buf$iv.close();
                    byte[] byArray2 = buf$iv.toByteArray();
                    byArray = byArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
                } else if (Common.isClassPresent$default("com.alibaba.fastjson.JSON", null, 2, null)) {
                    byte[] byArray3 = JSON.toJSONBytes(input$iv, (SerializerFeature[])new SerializerFeature[0]);
                    byArray = byArray3;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"toJSONBytes(...)");
                } else if (Common.isClassPresent$default("com.google.gson.Gson", null, 2, null)) {
                    String string = new Gson().toJson(input$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                    byte[] byArray4 = string.getBytes(Charsets.UTF_8);
                    byArray = byArray4;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getBytes(...)");
                } else if (Common.isClassPresent$default("com.fasterxml.jackson.databind.ObjectMapper", null, 2, null)) {
                    byte[] byArray5 = new ObjectMapper().writeValueAsBytes(input$iv);
                    byArray = byArray5;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"writeValueAsBytes(...)");
                } else {
                    throw new IllegalStateException("\u5565 Json\u73af\u5883\u652f\u6301\u90fd\u6ca1\u6709");
                }
                it.setBinary(byArray);
            }
        }));
        if (response2.getStatus() / 100 != 2) {
            byte[] byArray;
            throw new IllegalStateException("\u8fdc\u7a0b\u8c03\u5ea6\u54cd\u5e94\u5931\u8d25:" + response2.getStatus() + ':' + ((byArray = response2.getBody()) != null ? new String(byArray, Charsets.UTF_8) : null));
        }
    }
}

