/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.job.worker.bean;

import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.job.scheduler.Scheduler;
import io.github.caijiang.common.job.worker.JobTypeRunner;
import io.github.caijiang.common.job.worker.PersistentJob;
import io.github.caijiang.common.job.worker.ScheduleJobService;
import io.github.caijiang.common.job.worker.TemporaryJob;
import io.github.caijiang.common.job.worker.bean.WorkerRunner;
import io.github.caijiang.common.k8s.KubernetesUtils;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/github/caijiang/common/job/worker/bean/SchedulerScheduleJobService;", "Lio/github/caijiang/common/job/worker/ScheduleJobService;", "runner", "Lio/github/caijiang/common/job/worker/JobTypeRunner;", "scheduler", "Lio/github/caijiang/common/job/scheduler/Scheduler;", "env", "", "hostname", "(Lio/github/caijiang/common/job/worker/JobTypeRunner;Lio/github/caijiang/common/job/scheduler/Scheduler;Ljava/lang/String;Ljava/lang/String;)V", "submitPersistentJob", "", "cron", "job", "Lio/github/caijiang/common/job/worker/PersistentJob;", "timezone", "Ljava/util/TimeZone;", "springCronSeconds", "submitTemporaryJob", "Lio/github/caijiang/common/job/worker/TemporaryJob;", "common-ext"})
@SourceDebugExtension(value={"SMAP\nSchedulerScheduleJobService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchedulerScheduleJobService.kt\nio/github/caijiang/common/job/worker/bean/SchedulerScheduleJobService\n+ 2 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n*L\n1#1,34:1\n16#2:35\n16#2:36\n*S KotlinDebug\n*F\n+ 1 SchedulerScheduleJobService.kt\nio/github/caijiang/common/job/worker/bean/SchedulerScheduleJobService\n*L\n24#1:35\n29#1:36\n*E\n"})
public final class SchedulerScheduleJobService
implements ScheduleJobService {
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private final String env;
    @NotNull
    private final String hostname;

    public SchedulerScheduleJobService(@NotNull JobTypeRunner runner, @NotNull Scheduler scheduler, @NotNull String env, @NotNull String hostname) {
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        this.scheduler = scheduler;
        this.env = env;
        this.hostname = hostname;
        WorkerRunner.INSTANCE.executeCurrentJob(runner);
    }

    public /* synthetic */ SchedulerScheduleJobService(JobTypeRunner jobTypeRunner, Scheduler scheduler, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        String string3;
        if ((n & 4) != 0 && (string3 = KubernetesUtils.currentNamespace()) == null) {
            string3 = string = "default";
        }
        if ((n & 8) != 0) {
            String string4 = System.getenv("HOSTNAME");
            if (string4 == null) {
                string4 = "localhost";
            }
            string2 = string4;
        }
        this(jobTypeRunner, scheduler, string, string2);
    }

    @Override
    public void submitTemporaryJob(@NotNull TemporaryJob job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Slf4j.Companion companion = Slf4j.Companion;
        SchedulerScheduleJobService $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(SchedulerScheduleJobService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("\u5411 Scheduler \u53d1\u8d77 temporary \u8c03\u5ea6\u8bf7\u6c42:\u5f53\u524d\u8bbe\u5907:{},\u7c7b\u578b:{}", (Object)this.hostname, (Object)job.getType());
        this.scheduler.submitTemporaryJob(this.env, this.hostname, job);
    }

    @Override
    public void submitPersistentJob(@NotNull String cron, @NotNull PersistentJob job, @NotNull TimeZone timezone, @NotNull String springCronSeconds) {
        Intrinsics.checkNotNullParameter((Object)cron, (String)"cron");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        Intrinsics.checkNotNullParameter((Object)springCronSeconds, (String)"springCronSeconds");
        Object[] objectArray = Slf4j.Companion;
        SchedulerScheduleJobService $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(SchedulerScheduleJobService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        objectArray = new Object[]{this.hostname, job.getType(), job.getName()};
        logger.debug("\u5411 Scheduler \u53d1\u8d77 persistent \u8c03\u5ea6\u8bf7\u6c42:\u5f53\u524d\u8bbe\u5907:{},\u7c7b\u578b:{},\u540d\u79f0:{}", objectArray);
        this.scheduler.submitPersistentJob(this.env, this.hostname, cron, job, timezone);
    }
}

