/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.job.worker.bean;

import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.job.worker.JobTypeRunner;
import io.github.caijiang.common.job.worker.PersistentJob;
import io.github.caijiang.common.job.worker.ScheduleJobService;
import io.github.caijiang.common.job.worker.TemporaryJob;
import io.github.caijiang.common.job.worker.bean.WorkerRunner;
import java.util.Date;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/github/caijiang/common/job/worker/bean/TaskSchedulerScheduleJobService;", "Lio/github/caijiang/common/job/worker/ScheduleJobService;", "runner", "Lio/github/caijiang/common/job/worker/JobTypeRunner;", "taskScheduler", "Lorg/springframework/scheduling/TaskScheduler;", "(Lio/github/caijiang/common/job/worker/JobTypeRunner;Lorg/springframework/scheduling/TaskScheduler;)V", "submitPersistentJob", "", "cron", "", "job", "Lio/github/caijiang/common/job/worker/PersistentJob;", "timezone", "Ljava/util/TimeZone;", "springCronSeconds", "submitTemporaryJob", "Lio/github/caijiang/common/job/worker/TemporaryJob;", "common-ext"})
@SourceDebugExtension(value={"SMAP\nTaskSchedulerScheduleJobService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskSchedulerScheduleJobService.kt\nio/github/caijiang/common/job/worker/bean/TaskSchedulerScheduleJobService\n+ 2 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n*L\n1#1,45:1\n16#2:46\n16#2:47\n16#2:48\n16#2:49\n*S KotlinDebug\n*F\n+ 1 TaskSchedulerScheduleJobService.kt\nio/github/caijiang/common/job/worker/bean/TaskSchedulerScheduleJobService\n*L\n27#1:46\n38#1:47\n30#1:48\n40#1:49\n*E\n"})
public final class TaskSchedulerScheduleJobService
implements ScheduleJobService {
    @NotNull
    private final JobTypeRunner runner;
    @NotNull
    private final TaskScheduler taskScheduler;

    public TaskSchedulerScheduleJobService(@NotNull JobTypeRunner runner, @NotNull TaskScheduler taskScheduler) {
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)taskScheduler, (String)"taskScheduler");
        this.runner = runner;
        this.taskScheduler = taskScheduler;
        WorkerRunner.INSTANCE.executeCurrentJob(this.runner);
    }

    public /* synthetic */ TaskSchedulerScheduleJobService(JobTypeRunner jobTypeRunner, TaskScheduler taskScheduler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ThreadPoolTaskScheduler threadPoolTaskScheduler;
            ThreadPoolTaskScheduler $this$_init__u24lambda_u240 = threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
            boolean bl = false;
            $this$_init__u24lambda_u240.initialize();
            taskScheduler = (TaskScheduler)threadPoolTaskScheduler;
        }
        this(jobTypeRunner, taskScheduler);
    }

    @Override
    public void submitTemporaryJob(@NotNull TemporaryJob job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Slf4j.Companion companion = Slf4j.Companion;
        TaskSchedulerScheduleJobService $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(TaskSchedulerScheduleJobService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("\u5411 TaskScheduler \u53d1\u8d77 temporary \u8c03\u5ea6\u8bf7\u6c42:\u7c7b\u578b:{}", (Object)job.getType());
        this.taskScheduler.schedule(() -> TaskSchedulerScheduleJobService.submitTemporaryJob$lambda$1(this, job), new Date());
    }

    @Override
    public void submitPersistentJob(@NotNull String cron, @NotNull PersistentJob job, @NotNull TimeZone timezone, @NotNull String springCronSeconds) {
        Intrinsics.checkNotNullParameter((Object)cron, (String)"cron");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        Intrinsics.checkNotNullParameter((Object)springCronSeconds, (String)"springCronSeconds");
        Slf4j.Companion companion = Slf4j.Companion;
        TaskSchedulerScheduleJobService $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(TaskSchedulerScheduleJobService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("\u5411 TaskScheduler \u53d1\u8d77 persistent \u8c03\u5ea6\u8bf7\u6c42:\u7c7b\u578b:{},\u540d\u79f0:{}", (Object)job.getType(), (Object)job.getName());
        this.taskScheduler.schedule(() -> TaskSchedulerScheduleJobService.submitPersistentJob$lambda$2(this, job), (Trigger)new CronTrigger(springCronSeconds + ' ' + cron, TimeZone.getDefault()));
    }

    private static final void submitTemporaryJob$lambda$1(TaskSchedulerScheduleJobService this$0, TemporaryJob $job) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
        Slf4j.Companion companion = Slf4j.Companion;
        TaskSchedulerScheduleJobService $this$log$iv = this$0;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(TaskSchedulerScheduleJobService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("TaskScheduler \u6267\u884c temporary \u8c03\u5ea6\u8bf7\u6c42:\u7c7b\u578b:{}", (Object)$job.getType());
        this$0.runner.run($job);
    }

    private static final void submitPersistentJob$lambda$2(TaskSchedulerScheduleJobService this$0, PersistentJob $job) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
        Slf4j.Companion companion = Slf4j.Companion;
        TaskSchedulerScheduleJobService $this$log$iv = this$0;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(TaskSchedulerScheduleJobService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("TaskScheduler \u6267\u884c persistent \u8c03\u5ea6\u8bf7\u6c42:\u7c7b\u578b:{},\u540d\u79f0:{}", (Object)$job.getType(), (Object)$job.getName());
        this$0.runner.run($job);
    }
}

