/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.k8s;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0007J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lio/github/caijiang/common/k8s/KubernetesUtils;", "", "()V", "currentNamespace", "", "topOwner", "Lio/fabric8/kubernetes/api/model/HasMetadata;", "input", "client", "Lio/fabric8/kubernetes/client/KubernetesClient;", "common-ext"})
public final class KubernetesUtils {
    @NotNull
    public static final KubernetesUtils INSTANCE = new KubernetesUtils();

    private KubernetesUtils() {
    }

    @JvmStatic
    @Nullable
    public static final String currentNamespace() {
        String env;
        String string = System.getenv("kubenamespace");
        if (string == null) {
            string = System.getProperty("kubenamespace");
        }
        String string2 = env = string;
        boolean bl = string2 != null ? !StringsKt.isBlank((CharSequence)string2) : false;
        if (bl) {
            return env;
        }
        try {
            return FilesKt.readText$default((File)new File("/var/run/secrets/kubernetes.io/serviceaccount/namespace"), null, (int)1, null);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @NotNull
    public final HasMetadata topOwner(@NotNull HasMetadata input, @NotNull KubernetesClient client) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        int i = 0;
        HasMetadata currentResource = input;
        while (i++ < 10) {
            List ownerReferenceList = currentResource.getMetadata().getOwnerReferences();
            Collection collection = ownerReferenceList;
            if (collection == null || collection.isEmpty()) {
                return currentResource;
            }
            Intrinsics.checkNotNull((Object)ownerReferenceList);
            OwnerReference target = (OwnerReference)CollectionsKt.first((List)ownerReferenceList);
            GenericKubernetesResource genericKubernetesResource = (GenericKubernetesResource)((Resource)((NonNamespaceOperation)client.genericKubernetesResources(target.getApiVersion(), target.getKind()).inNamespace(currentResource.getMetadata().getNamespace())).withName(target.getName())).get();
            if (genericKubernetesResource == null) {
                return currentResource;
            }
            currentResource = (HasMetadata)genericKubernetesResource;
        }
        return currentResource;
    }
}

