/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.test.assertion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import io.github.caijiang.common.test.assertion.BusinessResult;
import io.github.caijiang.common.test.assertion.ToBusinessResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/github/caijiang/common/test/assertion/StdToBusinessResult;", "Lio/github/caijiang/common/test/assertion/ToBusinessResult;", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "call", "Lio/github/caijiang/common/test/assertion/BusinessResult;", "entity", "Lorg/springframework/http/ResponseEntity;", "", "readyBody", "Lcom/fasterxml/jackson/databind/JsonNode;", "common-ext"})
public final class StdToBusinessResult
implements ToBusinessResult {
    @NotNull
    public static final StdToBusinessResult INSTANCE = new StdToBusinessResult();
    @NotNull
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private StdToBusinessResult() {
    }

    @Override
    @NotNull
    public BusinessResult call(@NotNull ResponseEntity<String> entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        boolean success = entity.getStatusCode().is2xxSuccessful();
        String string = entity.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String message = string;
        JsonNode body = StringUtils.hasText((String)((String)entity.getBody())) ? this.readyBody(entity) : null;
        return new BusinessResult(success, entity, message, body){
            final /* synthetic */ boolean $success;
            final /* synthetic */ ResponseEntity<String> $entity;
            final /* synthetic */ String $message;
            final /* synthetic */ JsonNode $body;
            {
                this.$success = $success;
                this.$entity = $entity;
                this.$message = $message;
                this.$body = $body;
            }

            public boolean getSuccess() {
                return this.$success;
            }

            @NotNull
            public String getErrorCode() {
                return String.valueOf(this.$entity.getStatusCodeValue());
            }

            @NotNull
            public String getErrorMessage() {
                return this.$message;
            }

            @Nullable
            public JsonNode getBody() {
                return this.$body;
            }
        };
    }

    private final JsonNode readyBody(ResponseEntity<String> entity) {
        block5: {
            block4: {
                MediaType mediaType = entity.getHeaders().getContentType();
                if (mediaType != null ? mediaType.isCompatibleWith(MediaType.APPLICATION_JSON) : false) break block4;
                MediaType mediaType2 = entity.getHeaders().getContentType();
                boolean bl = mediaType2 != null ? mediaType2.isCompatibleWith(MediaType.APPLICATION_PROBLEM_JSON) : false;
                if (!bl) break block5;
            }
            JsonNode jsonNode = objectMapper.readTree((String)entity.getBody());
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
            return jsonNode;
        }
        MediaType mediaType = entity.getHeaders().getContentType();
        boolean bl = mediaType != null ? mediaType.isCompatibleWith(MediaType.TEXT_PLAIN) : false;
        if (bl) {
            TextNode textNode = TextNode.valueOf((String)((String)entity.getBody()));
            Intrinsics.checkNotNullExpressionValue((Object)textNode, (String)"valueOf(...)");
            return (JsonNode)textNode;
        }
        throw new IllegalStateException("unsupported contentType:" + entity.getHeaders().getContentType());
    }
}

